/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dsql;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.identity.spi.AwsCredentialsIdentity;
import software.amazon.awssdk.identity.spi.IdentityProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.dsql.DefaultDsqlUtilities;
import software.amazon.awssdk.services.dsql.model.GenerateAuthTokenRequest;

@SdkPublicApi
public interface DsqlUtilities {
    public static Builder builder() {
        return new DefaultDsqlUtilities.DefaultBuilder();
    }

    default public String generateDbConnectAuthToken(Consumer<GenerateAuthTokenRequest.Builder> request) {
        return this.generateDbConnectAuthToken(((GenerateAuthTokenRequest.Builder)GenerateAuthTokenRequest.builder().applyMutation(request)).build());
    }

    default public String generateDbConnectAuthToken(GenerateAuthTokenRequest request) {
        throw new UnsupportedOperationException();
    }

    default public String generateDbConnectAdminAuthToken(Consumer<GenerateAuthTokenRequest.Builder> request) {
        return this.generateDbConnectAdminAuthToken(((GenerateAuthTokenRequest.Builder)GenerateAuthTokenRequest.builder().applyMutation(request)).build());
    }

    default public String generateDbConnectAdminAuthToken(GenerateAuthTokenRequest request) {
        throw new UnsupportedOperationException();
    }

    @SdkPublicApi
    public static interface Builder {
        public Builder region(Region var1);

        default public Builder credentialsProvider(AwsCredentialsProvider credentialsProvider) {
            return this.credentialsProvider((IdentityProvider<? extends AwsCredentialsIdentity>)credentialsProvider);
        }

        default public Builder credentialsProvider(IdentityProvider<? extends AwsCredentialsIdentity> credentialsProvider) {
            throw new UnsupportedOperationException();
        }

        public DsqlUtilities build();
    }
}

