/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.sched.system.win;

import com.dbeaver.ee.sched.system.BaseSystemScheduler;
import com.dbeaver.ee.sched.system.GenericTaskScheduleInfo;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.task.DBTScheduler;
import org.jkiss.dbeaver.model.task.DBTSchedulerExternalSettings;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskScheduleConfiguration;
import org.jkiss.dbeaver.model.task.DBTTaskScheduleInfo;
import org.jkiss.dbeaver.registry.timezone.TimezoneRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.Pair;
import org.jkiss.utils.csv.CSVReader;
import org.jkiss.utils.xml.XMLException;
import org.jkiss.utils.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WinSystemScheduler
extends BaseSystemScheduler {
    private static final Log log = Log.getLog(WinSystemScheduler.class);
    public static final String DEFAULT_TASK_PREFIX = "DBeaver\\";
    public static final String SEARCH_TASK_PREFIX = "\\DBeaver\\";
    @Nullable
    private static final String USER_DEFINED_DATE_FORMAT = System.getProperty("dbeaver.scheduler.windows.dateFormat");
    private static final boolean USE_JAVA_FORMAT = false;
    private final Map<String, GenericTaskScheduleInfo> detailsMap = new LinkedHashMap<String, GenericTaskScheduleInfo>();

    @NotNull
    public String getSchedulerName() {
        return "Local Windows Task Scheduler";
    }

    public boolean supportsFeature(String feature) {
        switch (feature) {
            case "frequency.daily": 
            case "frequency.monthly.last_day": 
            case "frequency.monthly.startDate": 
            case "frequency.minutely.recurrence.greaterThan59": 
            case "frequency.minutely.startDatetime": 
            case "frequency.onetime": 
            case "frequency.weekly.startDate": 
            case "openExternalSettings": 
            case "frequency.minutely": 
            case "frequency.hourly.recurrence.greaterThan23": 
            case "frequency.daily.recurrence": 
            case "frequency.daily.recurrence.greaterThan31": 
            case "frequency.hourly": 
            case "frequency.daily.startDate": 
            case "frequency.monthly": 
            case "frequency.weekly": 
            case "frequency.weekly.recurrence": 
            case "frequency.onetime.startDatetime": 
            case "frequency.hourly.startDatetime": {
                return true;
            }
        }
        return false;
    }

    public DBTScheduler.RecurrenceType getRecurrenceType() {
        return DBTScheduler.RecurrenceType.Interval;
    }

    @NotNull
    public List<DBTTaskScheduleInfo> getAllScheduledTasks() {
        return new ArrayList<DBTTaskScheduleInfo>(this.detailsMap.values());
    }

    @Nullable
    public DBTTaskScheduleInfo getScheduledTaskInfo(@NotNull DBTTask task) {
        return this.detailsMap.get(task.getName());
    }

    @Nullable
    public DBTTaskScheduleConfiguration getScheduledTaskConfiguration(@NotNull DBTTask task) throws DBException {
        String csv = this.executeSchTasks("/Query", "/XML", "/TN", this.makeTaskName(task));
        try {
            Document taskInfoDoc = XMLUtils.parseDocument((Reader)new StringReader(csv));
            return this.parseWTSConfiguration(task, taskInfoDoc);
        }
        catch (XMLException e) {
            throw new DBException("Error parsing task info XML", (Throwable)e);
        }
    }

    private DBTTaskScheduleConfiguration parseWTSConfiguration(DBTTask task, Document document) {
        DBTTaskScheduleConfiguration cfg;
        block74: {
            Element domNode;
            Element sbmNode;
            block79: {
                Element calTriggerNode;
                block77: {
                    block76: {
                        Element triggersNode;
                        block75: {
                            String interval;
                            Element timeTriggerNode;
                            cfg = new DBTTaskScheduleConfiguration();
                            cfg.frequency = DBTTaskScheduleConfiguration.Frequency.MINUTELY;
                            triggersNode = XMLUtils.getChildElement((Element)document.getDocumentElement(), (String)"Triggers");
                            Element element = timeTriggerNode = triggersNode == null ? null : XMLUtils.getChildElement((Element)triggersNode, (String)"TimeTrigger");
                            if (timeTriggerNode == null) break block75;
                            this.parseStartBoundary(cfg, timeTriggerNode);
                            Element repetitionNode = XMLUtils.getChildElement((Element)timeTriggerNode, (String)"Repetition");
                            String string = interval = repetitionNode == null ? null : XMLUtils.getChildElementBody((Element)repetitionNode, (String)"Interval");
                            if (CommonUtils.isEmpty((String)interval)) break block74;
                            try {
                                Duration duration = Duration.parse(interval);
                                if (duration.toHours() > 0L) {
                                    cfg.frequency = DBTTaskScheduleConfiguration.Frequency.HOURLY;
                                    cfg.recurrence = (int)duration.toHours();
                                } else if (duration.toMinutes() > 0L) {
                                    cfg.frequency = DBTTaskScheduleConfiguration.Frequency.MINUTELY;
                                    cfg.recurrence = (int)duration.toMinutes();
                                }
                                break block74;
                            }
                            catch (Exception e) {
                                log.error((Object)("Error parsing interval (" + interval + ")"), (Throwable)e);
                            }
                            break block74;
                        }
                        Element element = calTriggerNode = triggersNode == null ? null : XMLUtils.getChildElement((Element)triggersNode, (String)"CalendarTrigger");
                        if (calTriggerNode == null) break block74;
                        this.parseStartBoundary(cfg, calTriggerNode);
                        Element sbdNode = XMLUtils.getChildElement((Element)calTriggerNode, (String)"ScheduleByDay");
                        if (sbdNode == null) break block76;
                        cfg.frequency = DBTTaskScheduleConfiguration.Frequency.DAILY;
                        cfg.recurrence = CommonUtils.toInt((Object)XMLUtils.getChildElementBody((Element)sbdNode, (String)"DaysInterval"));
                        break block74;
                    }
                    Element sbwNode = XMLUtils.getChildElement((Element)calTriggerNode, (String)"ScheduleByWeek");
                    if (sbwNode == null) break block77;
                    cfg.frequency = DBTTaskScheduleConfiguration.Frequency.WEEKLY;
                    cfg.recurrence = CommonUtils.toInt((Object)XMLUtils.getChildElementBody((Element)sbwNode, (String)"WeeksInterval"));
                    Element dowNode = XMLUtils.getChildElement((Element)sbwNode, (String)"DaysOfWeek");
                    if (dowNode == null) break block74;
                    cfg.days = new ArrayList();
                    for (Element dNode : XMLUtils.getChildElementList((Element)dowNode)) {
                        String dayName = dNode.getTagName();
                        if (dayName == null) continue;
                        int dayNum = switch (dayName = dayName.toLowerCase(Locale.ENGLISH)) {
                            case "monday" -> 2;
                            case "tuesday" -> 3;
                            case "wednesday" -> 4;
                            case "thursday" -> 5;
                            case "friday" -> 6;
                            case "saturday" -> 7;
                            case "sunday" -> 1;
                            default -> -1;
                        };
                        if (dayNum < 0) continue;
                        cfg.days.add((short)dayNum);
                    }
                    break block74;
                }
                sbmNode = XMLUtils.getChildElement((Element)calTriggerNode, (String)"ScheduleByMonth");
                if (sbmNode == null) break block74;
                cfg.frequency = DBTTaskScheduleConfiguration.Frequency.MONTHLY;
                Element monNode = XMLUtils.getChildElement((Element)sbmNode, (String)"Months");
                if (monNode == null) break block79;
                cfg.months = new ArrayList();
                for (Element mNode : XMLUtils.getChildElementList((Element)monNode)) {
                    String monthName = mNode.getTagName();
                    if (monthName == null) continue;
                    int monthNum = switch (monthName = monthName.toLowerCase(Locale.ENGLISH)) {
                        case "january" -> 0;
                        case "february" -> 1;
                        case "march" -> 2;
                        case "april" -> 3;
                        case "may" -> 4;
                        case "june" -> 5;
                        case "july" -> 6;
                        case "august" -> 7;
                        case "september" -> 8;
                        case "october" -> 9;
                        case "november" -> 10;
                        case "december" -> 11;
                        default -> -1;
                    };
                    if (monthNum < 0) continue;
                    cfg.months.add((short)monthNum);
                }
            }
            if ((domNode = XMLUtils.getChildElement((Element)sbmNode, (String)"DaysOfMonth")) != null) {
                cfg.days = new ArrayList();
                for (Element dNode : XMLUtils.getChildElementList((Element)domNode)) {
                    String dayNum = XMLUtils.getElementBody((Element)dNode);
                    if (dayNum == null) continue;
                    cfg.days.add((short)CommonUtils.toInt((Object)dayNum));
                }
            }
        }
        return cfg;
    }

    private void parseStartBoundary(DBTTaskScheduleConfiguration cfg, Element timeTriggerNode) {
        String startBoundary = XMLUtils.getChildElementBody((Element)timeTriggerNode, (String)"StartBoundary");
        if (!CommonUtils.isEmpty((String)startBoundary)) {
            try {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                format.setTimeZone(TimeZone.getTimeZone(TimezoneRegistry.getUserDefaultTimezone()));
                cfg.startTime = format.parse(startBoundary);
            }
            catch (ParseException e) {
                log.error((Object)("Error parsing StartBoundary (" + startBoundary + ")"), (Throwable)e);
            }
        }
    }

    public boolean setTaskSchedule(@NotNull DBTTask task, @NotNull DBTTaskScheduleConfiguration configuration) throws DBException {
        String resultStr;
        DBTTaskScheduleInfo taskInfo;
        ArrayList<String> mdList;
        if (!DBWorkbench.getPlatform().getApplication().isStandalone()) {
            throw new DBException("Cannot schedule tasks in Windows scheduler in plugin mode. Use standalone application.");
        }
        boolean isUpdate = this.getScheduledTaskInfo(task) != null;
        ArrayList<Short> days = null;
        boolean isLastDay = false;
        if (!CommonUtils.isEmpty((Collection)configuration.days)) {
            days = new ArrayList<Short>();
            for (Short dayNum : configuration.days) {
                if (dayNum == 32) {
                    isLastDay = true;
                    continue;
                }
                if (dayNum == 33) continue;
                days.add(dayNum);
            }
        }
        ArrayList<String> params = new ArrayList<String>();
        params.add("/Create");
        params.add("/SC");
        params.add(WinSystemScheduler.getWTSScheduleFrequency(configuration.frequency));
        if (configuration.recurrence > 0) {
            params.add("/MO");
            params.add(String.valueOf(configuration.recurrence));
        }
        if (isLastDay) {
            params.add("/MO");
            params.add("LASTDAY");
        } else if (!CommonUtils.isEmpty(days)) {
            params.add("/D");
            if (configuration.frequency == DBTTaskScheduleConfiguration.Frequency.WEEKLY) {
                ArrayList<String> wdList = new ArrayList<String>();
                for (Short dayNum : days) {
                    wdList.add(this.getWTSWeekDay(dayNum));
                }
                params.add(String.join((CharSequence)",", wdList));
            } else {
                mdList = new ArrayList<String>();
                Iterator iterator = days.iterator();
                if (iterator.hasNext()) {
                    Short dayNum;
                    dayNum = (Short)iterator.next();
                    mdList.add(String.valueOf(dayNum));
                }
                params.add(String.join((CharSequence)",", mdList));
            }
        }
        if (!CommonUtils.isEmpty((Collection)configuration.months)) {
            params.add("/M");
            mdList = new ArrayList();
            for (Short monthNum : configuration.months) {
                mdList.add(this.getWTSScheduleMonth(monthNum.shortValue()));
            }
            params.add(String.join((CharSequence)",", mdList));
        }
        if (configuration.repetitionInterval > 0) {
            params.add("/RI");
            params.add(String.valueOf(configuration.repetitionInterval));
        }
        if (!(configuration.startTime == null || configuration.frequency == DBTTaskScheduleConfiguration.Frequency.ONE_TIME && configuration.startTime.before(new Date()))) {
            String startDate = new SimpleDateFormat(this.getDatePattern()).format(configuration.startTime);
            params.add("/SD");
            params.add(startDate);
            String startTime = new SimpleDateFormat("HH:mm").format(configuration.startTime);
            params.add("/ST");
            params.add(startTime);
        }
        String taskName = this.makeTaskName(task);
        params.add("/TN");
        params.add(taskName);
        params.add("/TR");
        params.add("\\\"%s\\\" -data \\\"%s\\\" -runTask \\\"%s\\\" -nosplash".formatted(System.getProperty("eclipse.launcher"), WinSystemScheduler.getDataParameter(task), WinSystemScheduler.getRunTaskParameter(task)));
        if (isUpdate && (taskInfo = this.getScheduledTaskInfo(task)) != null) {
            try {
                this.removeTaskSchedule(task, taskInfo);
            }
            catch (DBException e) {
                log.debug((Object)"Error deleting previous task", (Throwable)e);
            }
        }
        if ((resultStr = this.executeSchTasks(params.toArray(new String[0]))).startsWith("ERROR")) {
            throw new DBException("Error scheduling task: " + resultStr);
        }
        log.debug((Object)("schtasks.exe: " + resultStr));
        return true;
    }

    @NotNull
    private String getDatePattern() {
        if (USER_DEFINED_DATE_FORMAT != null) {
            return USER_DEFINED_DATE_FORMAT;
        }
        DateFormat dateInstance = DateFormat.getDateInstance(3);
        try {
            String curDate = RuntimeUtils.executeProcess((String)"cmd.exe", (String[])new String[]{"/C", "echo %DATE%"});
            if (curDate != null) {
                int divPos = (curDate = curDate.trim()).indexOf(32);
                if (divPos != -1) {
                    curDate = curDate.substring(divPos + 1).trim();
                }
                Calendar cal = Calendar.getInstance();
                cal.setTimeInMillis(System.currentTimeMillis());
                int datOfMonth = cal.get(5);
                String[] dateParts = curDate.split("/");
                if (dateParts.length == 3) {
                    if (String.valueOf(datOfMonth).equals(dateParts[0])) {
                        return "dd/MM/yyyy";
                    }
                    return "MM/dd/yyyy";
                }
            }
        }
        catch (DBException e) {
            log.debug((Object)e);
        }
        return "dd/MM/yyyy";
    }

    private String makeTaskName(DBTTask task) {
        return DEFAULT_TASK_PREFIX + WinSystemScheduler.encodeTaskReference(task.getProject().getName(), task.getName());
    }

    private String getWTSWeekDay(Short dayNum) {
        switch (dayNum) {
            case 2: {
                return "MON";
            }
            case 3: {
                return "TUE";
            }
            case 4: {
                return "WED";
            }
            case 5: {
                return "THU";
            }
            case 6: {
                return "FRI";
            }
            case 7: {
                return "SAT";
            }
            case 1: {
                return "SUN";
            }
        }
        return "*";
    }

    private String getWTSScheduleMonth(int monthNum) {
        switch (monthNum) {
            case 0: {
                return "JAN";
            }
            case 1: {
                return "FEB";
            }
            case 2: {
                return "MAR";
            }
            case 3: {
                return "APR";
            }
            case 4: {
                return "MAY";
            }
            case 5: {
                return "JUN";
            }
            case 6: {
                return "JUL";
            }
            case 7: {
                return "AUG";
            }
            case 8: {
                return "SEP";
            }
            case 9: {
                return "OCT";
            }
            case 10: {
                return "NOV";
            }
            case 11: {
                return "DEC";
            }
        }
        return null;
    }

    private static String getWTSScheduleFrequency(DBTTaskScheduleConfiguration.Frequency frequency) {
        switch (frequency) {
            case MINUTELY: {
                return "MINUTE";
            }
            case HOURLY: {
                return "HOURLY";
            }
            case DAILY: {
                return "DAILY";
            }
            case WEEKLY: {
                return "WEEKLY";
            }
            case MONTHLY: {
                return "MONTHLY";
            }
        }
        return "ONCE";
    }

    public void removeTaskSchedule(@NotNull DBTTask task, DBTTaskScheduleInfo scheduleInfo) throws DBException {
        ArrayList<String> params = new ArrayList<String>();
        params.add("/Delete");
        String taskName = this.makeTaskName(task);
        params.add("/TN");
        params.add(taskName);
        params.add("/F");
        String resultStr = this.executeSchTasks(params.toArray(new String[0]));
        if (resultStr.startsWith("ERROR")) {
            throw new DBException("Error removing scheduled task: " + resultStr);
        }
    }

    public void refreshScheduledTasks(@NotNull DBRProgressMonitor monitor) throws DBException {
        String csv = this.executeSchTasks("/Query", "/FO", "CSV");
        ArrayList<GenericTaskScheduleInfo> details = new ArrayList<GenericTaskScheduleInfo>();
        try {
            Throwable throwable = null;
            Iterator iterator = null;
            try (CSVReader csvReader = new CSVReader((Reader)new StringReader(csv), ',', '\"', '|');){
                List strings = csvReader.readAll();
                int i = 1;
                while (i < strings.size()) {
                    String[] line = (String[])strings.get(i);
                    if (line.length == 3) {
                        String taskId = line[0];
                        String projectId = null;
                        try {
                            Pair<String, String> pair = WinSystemScheduler.decodeTaskReference(line[0]);
                            projectId = (String)pair.getFirst();
                            taskId = (String)pair.getSecond();
                        }
                        catch (IllegalArgumentException e) {
                            log.warn((Object)("Invalid task reference: " + line[0]), (Throwable)e);
                        }
                        String nextRunTime = line[1];
                        String status = line[2];
                        if (!CommonUtils.isEmpty((String)taskId) && taskId.startsWith(SEARCH_TASK_PREFIX)) {
                            taskId = taskId.substring(SEARCH_TASK_PREFIX.length());
                            details.add(new GenericTaskScheduleInfo(projectId, taskId, nextRunTime, status));
                        }
                    }
                    ++i;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new DBException("IO error", (Throwable)e);
        }
        this.detailsMap.clear();
        for (GenericTaskScheduleInfo info : details) {
            this.detailsMap.put(info.getTaskId(), info);
        }
    }

    public DBTSchedulerExternalSettings openSchedulerSettings() throws DBException {
        RuntimeUtils.executeProcess((String)"cmd.exe", (String[])new String[]{"/C", "start", "taskschd.msc"});
        return null;
    }

    private String executeSchTasks(String ... parameters) throws DBException {
        ArrayList<String> args = new ArrayList<String>();
        args.add("/C");
        args.add("schtasks.exe");
        Collections.addAll(args, parameters);
        log.debug((Object)("Run Windows scheduler with parameters [" + String.join((CharSequence)" ", parameters) + "]"));
        return RuntimeUtils.executeProcess((String)"cmd.exe", (String[])args.toArray(new String[0]));
    }
}

