/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.sched.system.win;

import com.dbeaver.ee.sched.system.BaseSystemScheduler;
import com.dbeaver.ee.sched.system.GenericTaskScheduleInfo;
import com.dbeaver.model.win32.com.ICollection;
import com.dbeaver.model.win32.com.IPrincipal;
import com.dbeaver.model.win32.com.IRegisteredTask;
import com.dbeaver.model.win32.com.IRegistrationInfo;
import com.dbeaver.model.win32.com.ITaskDefinition;
import com.dbeaver.model.win32.com.ITaskFolder;
import com.dbeaver.model.win32.com.ITaskService;
import com.dbeaver.model.win32.com.TaskCreationFlags;
import com.dbeaver.model.win32.com.TaskDayOfMonth;
import com.dbeaver.model.win32.com.TaskDayOfWeek;
import com.dbeaver.model.win32.com.TaskLogon;
import com.dbeaver.model.win32.com.TaskMonthOfYear;
import com.dbeaver.model.win32.com.TaskRunLevel;
import com.dbeaver.model.win32.com.action.IAction;
import com.dbeaver.model.win32.com.action.IActionCollection;
import com.dbeaver.model.win32.com.action.IActionExecute;
import com.dbeaver.model.win32.com.trigger.IDailyTrigger;
import com.dbeaver.model.win32.com.trigger.IMonthlyTrigger;
import com.dbeaver.model.win32.com.trigger.ITrigger;
import com.dbeaver.model.win32.com.trigger.ITriggerCollection;
import com.dbeaver.model.win32.com.trigger.IWeeklyTrigger;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.COM.COMException;
import com.sun.jna.platform.win32.COM.util.ComThread;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.connection.DBPAuthInfo;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.task.DBTScheduler;
import org.jkiss.dbeaver.model.task.DBTSchedulerExternalSettings;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskScheduleConfiguration;
import org.jkiss.dbeaver.model.task.DBTTaskScheduleInfo;
import org.jkiss.dbeaver.registry.timezone.TimezoneRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class COMSystemScheduler
extends BaseSystemScheduler {
    private static final Log log = Log.getLog(COMSystemScheduler.class);
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final String DEFAULT_FOLDER = "DBeaver";
    private static final String PROP_USER_ID = "task.userId";
    private static final String PROP_REQUIRE_LOGON = "task.requireLogon";
    private static final String PROP_STORE_PASSWORD = "task.storePassword";
    private static final String PROP_ELEVATE_PRIVILEGES = "task.elevatePrivileges";
    private static final Pattern TASK_NAME_PATTERN = Pattern.compile("^.*\\(([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})\\)$");
    private static final ComThread comThread = new ComThread("COM scheduler thread", 5000L, (t, e) -> log.error((Object)"Uncaught exception on the COM thread", e));
    private final Map<String, GenericTaskScheduleInfo> registeredTasks = new LinkedHashMap<String, GenericTaskScheduleInfo>();
    private final ITaskService service = this.runInComThread(() -> {
        ITaskService service = new ITaskService();
        try {
            service.connect(null, null, null, null);
        }
        catch (COMException e) {
            throw new DBException("Error connecting to the task scheduler service", (Throwable)e);
        }
        return service;
    });
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$com$dbeaver$model$win32$com$TaskLogon;
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$com$dbeaver$model$win32$com$trigger$ITrigger$Type;

    @NotNull
    public String getSchedulerName() {
        return "Local Windows Task Scheduler";
    }

    public boolean supportsFeature(String feature) {
        switch (feature) {
            case "frequency.daily": 
            case "frequency.monthly.last_day": 
            case "frequency.monthly.startDate": 
            case "frequency.minutely.recurrence.greaterThan59": 
            case "frequency.minutely.startDatetime": 
            case "frequency.onetime": 
            case "frequency.weekly.startDate": 
            case "openExternalSettings": 
            case "frequency.minutely": 
            case "frequency.hourly.recurrence.greaterThan23": 
            case "frequency.daily.recurrence": 
            case "frequency.daily.recurrence.greaterThan31": 
            case "frequency.hourly": 
            case "frequency.daily.startDate": 
            case "frequency.monthly": 
            case "frequency.weekly": 
            case "frequency.weekly.recurrence": 
            case "frequency.onetime.startDatetime": 
            case "frequency.hourly.startDatetime": {
                return true;
            }
        }
        return false;
    }

    public DBTScheduler.RecurrenceType getRecurrenceType() {
        return DBTScheduler.RecurrenceType.Interval;
    }

    @NotNull
    public List<DBTTaskScheduleInfo> getAllScheduledTasks() {
        return new ArrayList<DBTTaskScheduleInfo>(this.registeredTasks.values());
    }

    @Nullable
    public DBTTaskScheduleInfo getScheduledTaskInfo(@NotNull DBTTask task) {
        GenericTaskScheduleInfo info = this.registeredTasks.get(task.getName());
        if (info != null) {
            return info;
        }
        return this.registeredTasks.get(task.getId());
    }

    @Nullable
    public DBTTaskScheduleConfiguration getScheduledTaskConfiguration(@NotNull DBTTask task) throws DBException {
        return this.runInComThread(() -> this.getScheduledTaskConfigurationCom(task));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private DBTTaskScheduleConfiguration getScheduledTaskConfigurationCom(@NotNull DBTTask task) {
        configuration = new DBTTaskScheduleConfiguration();
        var4_3 = null;
        var5_8 = null;
        try {
            block92: {
                block89: {
                    block90: {
                        registeredTask = COMSystemScheduler.findRegisteredTaskCom(this.getTasksFolderCom(), task);
                        if (registeredTask == null) {
                            if (registeredTask == null) return null;
                            registeredTask.close();
                            return null;
                        }
                        {
                            var7_16 = null;
                            var8_18 = null;
                            try {
                                definition = registeredTask.getDefinition();
                                var10_23 = null;
                                var11_26 = null;
                                try {
                                    block88: {
                                        triggers = definition.getTriggers();
                                        if (triggers.getCount() < 1) {
                                            COMSystemScheduler.log.error((Object)("Cannot find triggers for task '" + task.getName() + "'"));
                                            if (triggers == null) break block88;
                                        }
                                        ** GOTO lbl-1000
                                        triggers.close();
                                    }
                                    if (definition != null) {
                                        definition.close();
                                    }
                                    if (registeredTask == null) return null;
                                    registeredTask.close();
                                    return null;
                                }
                                catch (Throwable var11_27) {
                                    if (var10_23 == null) {
                                        var10_23 = var11_27;
                                        throw var10_23;
                                    }
                                    if (var10_23 == var11_27) throw var10_23;
                                    var10_23.addSuppressed(var11_27);
                                    throw var10_23;
                                }
                            }
                            catch (Throwable var8_19) {
                                if (var7_16 == null) {
                                    var7_16 = var8_19;
                                    throw var7_16;
                                }
                                if (var7_16 == var8_19) throw var7_16;
                                var7_16.addSuppressed(var8_19);
                                throw var7_16;
                            }
                            catch (Throwable var7_17) {
                                throw var7_17;
                            }
                        }
lbl-1000:
                        // 1 sources

                        {
                            trigger = (ITrigger)triggers.getItem(0);
                            startBoundary = trigger.getStartBoundary();
                            if (startBoundary != null) break block89;
                            COMSystemScheduler.log.error((Object)("Missing start boundary of trigger for task '" + task.getName() + "'"));
                            if (triggers == null) break block90;
                        }
                        triggers.close();
                    }
                    if (definition != null) {
                        definition.close();
                    }
                    if (registeredTask == null) return null;
                    registeredTask.close();
                    return null;
                }
                ** try [egrp 10[TRYBLOCK] [17 : 195->584)] { 
lbl68:
                // 1 sources

                ** try [egrp 14[TRYBLOCK] [2 : 195->216)] { 
lbl69:
                // 1 sources

                break block92;
lbl70:
                // 1 sources

                finally {
                    if (triggers != null) {
                        triggers.close();
                    }
                }
            }
            configuration.startTime = Date.from(startBoundary.atZone(ZoneId.of(TimezoneRegistry.getUserDefaultTimezone())).toInstant());
            var10_23 = null;
            var11_26 = null;
            try {
                principal = definition.getPrincipal();
                try {
                    properties = configuration.properties;
                    switch (COMSystemScheduler.$SWITCH_TABLE$com$dbeaver$model$win32$com$TaskLogon()[principal.getLogonType().ordinal()]) {
                        case 1: {
                            properties.put("task.requireLogon", true);
                            properties.put("task.storePassword", true);
                            break;
                        }
                        case 2: {
                            properties.put("task.requireLogon", true);
                            properties.put("task.storePassword", false);
                            break;
                        }
                        case 3: {
                            properties.put("task.requireLogon", false);
                            properties.put("task.storePassword", false);
                            break;
                        }
                    }
                    properties.put("task.elevatePrivileges", principal.getRunLevel() == TaskRunLevel.HIGHEST);
                    properties.put("task.userId", principal.getUserId());
                }
                finally {
                    if (principal != null) {
                        principal.close();
                    }
                }
            }
            catch (Throwable var11_28) {
                if (var10_23 == null) {
                    var10_23 = var11_28;
                    throw var10_23;
                }
                if (var10_23 == var11_28) throw var10_23;
                var10_23.addSuppressed(var11_28);
                throw var10_23;
            }
lbl117:
            // 1 sources

            finally {
                if (registeredTask != null) {
                    registeredTask.close();
                }
            }
        }
        catch (Throwable var5_9) {
            if (var4_3 == null) {
                var4_3 = var5_9;
                throw var4_3;
            }
            if (var4_3 == var5_9) throw var4_3;
            var4_3.addSuppressed(var5_9);
            throw var4_3;
        }
        switch (COMSystemScheduler.$SWITCH_TABLE$com$dbeaver$model$win32$com$trigger$ITrigger$Type()[trigger.getType().ordinal()]) {
            case 1: {
                var5_8 = null;
                registeredTask = null;
                try {
                    timeTrigger = trigger.asTimeTrigger();
                    try {
                        var8_18 = null;
                        var9_21 = null;
                        try {
                            repetition = timeTrigger.getRepetition();
                            try {
                                interval = repetition.getInterval();
                            }
                            finally {
                                if (repetition != null) {
                                    repetition.close();
                                }
                            }
                        }
                        catch (Throwable var9_22) {
                            if (var8_18 == null) {
                                var8_18 = var9_22;
                                throw var8_18;
                            }
                            if (var8_18 == var9_22) throw var8_18;
                            var8_18.addSuppressed(var9_22);
                            throw var8_18;
                        }
                    }
                    finally {
                        if (timeTrigger != null) {
                            timeTrigger.close();
                        }
                    }
                }
                catch (Throwable registeredTask) {
                    if (var5_8 == null) {
                        var5_8 = registeredTask;
                        throw var5_8;
                    }
                    if (var5_8 == registeredTask) throw var5_8;
                    var5_8.addSuppressed(registeredTask);
                    throw var5_8;
                }
                if (interval == null) {
                    configuration.frequency = DBTTaskScheduleConfiguration.Frequency.ONE_TIME;
                    return configuration;
                }
                if (interval.toHours() > 0L) {
                    configuration.frequency = DBTTaskScheduleConfiguration.Frequency.HOURLY;
                    configuration.recurrence = (int)interval.toHours();
                    return configuration;
                }
                configuration.frequency = DBTTaskScheduleConfiguration.Frequency.MINUTELY;
                configuration.recurrence = (int)interval.toMinutes();
                return configuration;
            }
            case 2: {
                var4_3 = null;
                var5_8 = null;
                try {
                    dailyTrigger = trigger.asDailyTrigger();
                    try {
                        configuration.frequency = DBTTaskScheduleConfiguration.Frequency.DAILY;
                        configuration.recurrence = dailyTrigger.getDaysInterval();
                        return configuration;
                    }
                    finally {
                        if (dailyTrigger != null) {
                            dailyTrigger.close();
                        }
                    }
                }
                catch (Throwable var5_11) {
                    if (var4_3 == null) {
                        var4_3 = var5_11;
                        throw var4_3;
                    }
                    if (var4_3 == var5_11) throw var4_3;
                    var4_3.addSuppressed(var5_11);
                    throw var4_3;
                }
            }
            case 3: {
                var4_3 = null;
                var5_8 = null;
                try {
                    weeklyTrigger = trigger.asWeeklyTrigger();
                    try {
                        configuration.frequency = DBTTaskScheduleConfiguration.Frequency.WEEKLY;
                        configuration.recurrence = weeklyTrigger.getWeeksInterval();
                        configuration.days = weeklyTrigger.getDaysOfWeek().stream().map((Function<TaskDayOfWeek, Short>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$3(com.dbeaver.model.win32.com.TaskDayOfWeek ), (Lcom/dbeaver/model/win32/com/TaskDayOfWeek;)Ljava/lang/Short;)()).collect(Collectors.toList());
                        return configuration;
                    }
                    finally {
                        if (weeklyTrigger != null) {
                            weeklyTrigger.close();
                        }
                    }
                }
                catch (Throwable var5_12) {
                    if (var4_3 == null) {
                        var4_3 = var5_12;
                        throw var4_3;
                    }
                    if (var4_3 == var5_12) throw var4_3;
                    var4_3.addSuppressed(var5_12);
                    throw var4_3;
                }
            }
            case 4: {
                var4_3 = null;
                var5_8 = null;
                try {
                    monthlyTrigger = trigger.asMonthlyTrigger();
                    try {
                        configuration.frequency = DBTTaskScheduleConfiguration.Frequency.MONTHLY;
                        configuration.days = monthlyTrigger.getDaysOfMonth().stream().map((Function<TaskDayOfMonth, Short>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$4(com.dbeaver.model.win32.com.TaskDayOfMonth ), (Lcom/dbeaver/model/win32/com/TaskDayOfMonth;)Ljava/lang/Short;)()).collect(Collectors.toList());
                        configuration.months = monthlyTrigger.getMonthsOfYear().stream().map((Function<TaskMonthOfYear, Short>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$5(com.dbeaver.model.win32.com.TaskMonthOfYear ), (Lcom/dbeaver/model/win32/com/TaskMonthOfYear;)Ljava/lang/Short;)()).collect(Collectors.toList());
                        if (monthlyTrigger.isRunOnLastDayOfMonth() == false) return configuration;
                        configuration.days.add((short)32);
                        return configuration;
                    }
                    finally {
                        if (monthlyTrigger != null) {
                            monthlyTrigger.close();
                        }
                    }
                }
                catch (Throwable var5_13) {
                    if (var4_3 == null) {
                        var4_3 = var5_13;
                        throw var4_3;
                    }
                    if (var4_3 == var5_13) throw var4_3;
                    var4_3.addSuppressed(var5_13);
                    throw var4_3;
                }
            }
        }
        COMSystemScheduler.log.error((Object)("Unsupported trigger type: " + String.valueOf(trigger.getType())));
        trigger.release();
        return null;
    }

    public boolean setTaskSchedule(@NotNull DBTTask task, @NotNull DBTTaskScheduleConfiguration configuration) throws DBException {
        TaskLogon logon;
        DBPAuthInfo credentials;
        Map properties = configuration.properties;
        boolean requireLogon = CommonUtils.toBoolean(properties.get(PROP_REQUIRE_LOGON));
        boolean storePassword = CommonUtils.toBoolean(properties.get(PROP_STORE_PASSWORD));
        boolean elevatePrivileges = CommonUtils.toBoolean(properties.get(PROP_ELEVATE_PRIVILEGES));
        if (requireLogon) {
            if (storePassword) {
                String userId = CommonUtils.toString(properties.get(PROP_USER_ID));
                if (CommonUtils.isEmpty((String)userId)) {
                    userId = Advapi32Util.getUserName();
                }
                if ((credentials = DBWorkbench.getPlatformUI().promptUserCredentials("Task Scheduler", "Enter user account information for running this task.", userId, null, false, false)) == null) {
                    return false;
                }
                logon = TaskLogon.PASSWORD;
            } else {
                credentials = null;
                logon = TaskLogon.SERVICE_FOR_USER;
            }
        } else {
            credentials = null;
            logon = TaskLogon.INTERACTIVE_TOKEN;
        }
        this.runInComThread(() -> {
            this.setTaskScheduleCom(task, configuration, logon, credentials, elevatePrivileges, requireLogon, storePassword);
            return null;
        });
        return true;
    }

    private void setTaskScheduleCom(@NotNull DBTTask task, @NotNull DBTTaskScheduleConfiguration configuration, @NotNull TaskLogon logon, @Nullable DBPAuthInfo credentials, boolean elevatePrivileges, boolean requireLogon, boolean storePassword) throws DBException {
        Throwable throwable = null;
        Object var9_10 = null;
        try (ITaskDefinition definition = this.service.newTask();){
            Throwable throwable2;
            Serializable startBoundary;
            Throwable throwable3 = null;
            Object var12_20 = null;
            try (IRegistrationInfo registrationInfo = definition.getRegistrationInfo();){
                registrationInfo.setDescription(GeneralUtils.getProductName());
                registrationInfo.setVersion(GeneralUtils.getProductVersion().toString());
            }
            catch (Throwable throwable4) {
                if (throwable3 == null) {
                    throwable3 = throwable4;
                } else if (throwable3 != throwable4) {
                    throwable3.addSuppressed(throwable4);
                }
                throw throwable3;
            }
            throwable3 = null;
            var12_20 = null;
            try (IPrincipal principal = definition.getPrincipal();){
                principal.setRunLevel(elevatePrivileges ? TaskRunLevel.HIGHEST : TaskRunLevel.LUA);
                principal.setLogonType(logon);
            }
            catch (Throwable throwable5) {
                if (throwable3 == null) {
                    throwable3 = throwable5;
                } else if (throwable3 != throwable5) {
                    throwable3.addSuppressed(throwable5);
                }
                throw throwable3;
            }
            throwable3 = null;
            var12_20 = null;
            try (ITriggerCollection triggers = definition.getTriggers();){
                startBoundary = configuration.startTime.toInstant().atZone(ZoneId.of(TimezoneRegistry.getUserDefaultTimezone())).toLocalDateTime();
                switch (configuration.frequency) {
                    case ONE_TIME: {
                        ITrigger trigger;
                        throwable2 = null;
                        Throwable throwable6 = null;
                        try {
                            trigger = triggers.create(ITrigger.Type.TIME).asTimeTrigger();
                            try {
                                trigger.setStartBoundary((LocalDateTime)startBoundary);
                                break;
                            }
                            finally {
                                if (trigger != null) {
                                    trigger.close();
                                }
                            }
                        }
                        catch (Throwable throwable7) {
                            if (throwable2 == null) {
                                throwable2 = throwable7;
                            } else if (throwable2 != throwable7) {
                                throwable2.addSuppressed(throwable7);
                            }
                            throw throwable2;
                        }
                    }
                    case MINUTELY: {
                        ITrigger trigger;
                        Throwable throwable8 = null;
                        Throwable throwable6 = null;
                        try {
                            trigger = triggers.create(ITrigger.Type.TIME).asTimeTrigger();
                            try {
                                trigger.setStartBoundary((LocalDateTime)startBoundary);
                                trigger.getRepetition().setInterval(Duration.ofMinutes(configuration.recurrence));
                                break;
                            }
                            finally {
                                if (trigger != null) {
                                    trigger.close();
                                }
                            }
                        }
                        catch (Throwable throwable9) {
                            if (throwable8 == null) {
                                throwable8 = throwable9;
                            } else if (throwable8 != throwable9) {
                                throwable8.addSuppressed(throwable9);
                            }
                            throw throwable8;
                        }
                    }
                    case HOURLY: {
                        ITrigger trigger;
                        Throwable throwable10 = null;
                        Throwable throwable6 = null;
                        try {
                            trigger = triggers.create(ITrigger.Type.TIME).asTimeTrigger();
                            try {
                                trigger.setStartBoundary((LocalDateTime)startBoundary);
                                trigger.getRepetition().setInterval(Duration.ofHours(configuration.recurrence));
                                break;
                            }
                            finally {
                                if (trigger != null) {
                                    trigger.close();
                                }
                            }
                        }
                        catch (Throwable throwable11) {
                            if (throwable10 == null) {
                                throwable10 = throwable11;
                            } else if (throwable10 != throwable11) {
                                throwable10.addSuppressed(throwable11);
                            }
                            throw throwable10;
                        }
                    }
                    case DAILY: {
                        ITrigger trigger;
                        Throwable throwable12 = null;
                        Throwable throwable6 = null;
                        try {
                            trigger = triggers.create(ITrigger.Type.DAILY).asDailyTrigger();
                            try {
                                trigger.setStartBoundary((LocalDateTime)startBoundary);
                                ((IDailyTrigger)trigger).setDaysInterval(configuration.recurrence);
                                break;
                            }
                            finally {
                                if (trigger != null) {
                                    trigger.close();
                                }
                            }
                        }
                        catch (Throwable throwable13) {
                            if (throwable12 == null) {
                                throwable12 = throwable13;
                            } else if (throwable12 != throwable13) {
                                throwable12.addSuppressed(throwable13);
                            }
                            throw throwable12;
                        }
                    }
                    case WEEKLY: {
                        List daysOfWeek = configuration.days.stream().map(x -> TaskDayOfWeek.values()[x - 1]).collect(Collectors.toList());
                        Throwable throwable6 = null;
                        ITrigger trigger = null;
                        try (IWeeklyTrigger trigger2 = triggers.create(ITrigger.Type.WEEKLY).asWeeklyTrigger();){
                            trigger2.setStartBoundary((LocalDateTime)startBoundary);
                            trigger2.setDaysOfWeek(EnumSet.copyOf(daysOfWeek));
                            trigger2.setWeeksInterval(configuration.recurrence);
                            break;
                        }
                        catch (Throwable trigger22) {
                            if (throwable6 == null) {
                                throwable6 = trigger22;
                            } else if (throwable6 != trigger22) {
                                throwable6.addSuppressed(trigger22);
                            }
                            throw throwable6;
                        }
                    }
                    case MONTHLY: {
                        boolean isLastDay = configuration.days.stream().anyMatch(x -> x == 32);
                        List daysOfMonths = configuration.days.stream().filter(x -> x != 32).map(x -> TaskDayOfMonth.values()[x - 1]).collect(Collectors.toList());
                        List monthsOfYear = configuration.months.stream().map(x -> TaskMonthOfYear.values()[x]).collect(Collectors.toList());
                        Object object = null;
                        Object var19_53 = null;
                        try (IMonthlyTrigger trigger = triggers.create(ITrigger.Type.MONTHLY).asMonthlyTrigger();){
                            trigger.setStartBoundary((LocalDateTime)startBoundary);
                            trigger.setDaysOfMonth(isLastDay && daysOfMonths.isEmpty() ? EnumSet.noneOf(TaskDayOfMonth.class) : EnumSet.copyOf(daysOfMonths));
                            trigger.setMonthsOfYear(EnumSet.copyOf(monthsOfYear));
                            trigger.setRunOnLastDayOfMonth(isLastDay);
                            break;
                        }
                        catch (Throwable throwable14) {
                            if (object == null) {
                                object = throwable14;
                            } else if (object != throwable14) {
                                ((Throwable)object).addSuppressed(throwable14);
                            }
                            throw object;
                        }
                    }
                    default: {
                        log.error((Object)("Unsupported schedule frequency: " + String.valueOf(configuration.frequency)));
                        break;
                    }
                }
            }
            catch (Throwable throwable15) {
                if (throwable3 == null) {
                    throwable3 = throwable15;
                } else if (throwable3 != throwable15) {
                    throwable3.addSuppressed(throwable15);
                }
                throw throwable3;
            }
            throwable3 = null;
            var12_20 = null;
            try (IActionCollection actions = definition.getActions();){
                startBoundary = null;
                throwable2 = null;
                try (IActionExecute executeAction = actions.create(IAction.Type.EXECUTE).asExecuteAction();){
                    executeAction.setPath(System.getProperty("eclipse.launcher"));
                    executeAction.setArguments(COMSystemScheduler.generateLaunchArguments(task));
                }
                catch (Throwable throwable16) {
                    if (startBoundary == null) {
                        startBoundary = throwable16;
                    } else if (startBoundary != throwable16) {
                        ((Throwable)startBoundary).addSuppressed(throwable16);
                    }
                    throw startBoundary;
                }
            }
            catch (Throwable throwable17) {
                if (throwable3 == null) {
                    throwable3 = throwable17;
                } else if (throwable3 != throwable17) {
                    throwable3.addSuppressed(throwable17);
                }
                throw throwable3;
            }
            try {
                throwable3 = null;
                var12_20 = null;
                try (ITaskFolder tasksFolder = this.getTasksFolderCom();){
                    startBoundary = null;
                    throwable2 = null;
                    try (ICollection<IRegisteredTask> registeredTasks = tasksFolder.getTasks();){
                        for (IRegisteredTask registeredTask : registeredTasks) {
                            String nameOrId = COMSystemScheduler.getTaskNameOrId(registeredTask);
                            if (!nameOrId.equals(task.getName()) && !nameOrId.equals(task.getId())) continue;
                            tasksFolder.deleteTask(registeredTask.getName());
                            break;
                        }
                    }
                    catch (Throwable throwable18) {
                        if (startBoundary == null) {
                            startBoundary = throwable18;
                        } else if (startBoundary != throwable18) {
                            ((Throwable)startBoundary).addSuppressed(throwable18);
                        }
                        throw startBoundary;
                    }
                    try {
                        tasksFolder.registerTask("\\" + COMSystemScheduler.getUniqueTaskName(task), definition, EnumSet.of(TaskCreationFlags.CREATE, TaskCreationFlags.UPDATE), credentials != null ? credentials.getUserName() : null, credentials != null ? credentials.getUserPassword() : null, logon, "").release();
                    }
                    catch (COMException e) {
                        if (elevatePrivileges && !Advapi32Util.isCurrentProcessElevated()) {
                            throw new DBException("The user does not have sufficient privileges to save the task.\nPlease restart DBeaver with administrator privileges.", (Throwable)e);
                        }
                        if (requireLogon && storePassword) {
                            throw new DBException("The user account is unknown, the password is incorrect, or the user account does not have permission to save the task.", (Throwable)e);
                        }
                        throw e;
                    }
                }
                catch (Throwable throwable19) {
                    if (throwable3 == null) {
                        throwable3 = throwable19;
                    } else if (throwable3 != throwable19) {
                        throwable3.addSuppressed(throwable19);
                    }
                    throw throwable3;
                }
            }
            catch (COMException e) {
                throw new DBException("Error registering task", (Throwable)e);
            }
        }
        catch (Throwable throwable20) {
            if (throwable == null) {
                throwable = throwable20;
            } else if (throwable != throwable20) {
                throwable.addSuppressed(throwable20);
            }
            throw throwable;
        }
    }

    public void removeTaskSchedule(@NotNull DBTTask task, DBTTaskScheduleInfo scheduleInfo) throws DBException {
        this.runInComThread(() -> {
            this.removeTaskScheduleCom(task);
            return null;
        });
    }

    private void removeTaskScheduleCom(@NotNull DBTTask task) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ITaskFolder folder = this.getTasksFolderCom();){
            Throwable throwable2 = null;
            Object var6_9 = null;
            try (IRegisteredTask registeredTask = COMSystemScheduler.findRegisteredTaskCom(folder, task);){
                if (registeredTask != null) {
                    folder.deleteTask(registeredTask.getName());
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    public void refreshScheduledTasks(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.runInComThread(() -> {
            this.refreshScheduledTasksCom();
            return null;
        });
    }

    private void refreshScheduledTasksCom() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ITaskFolder folder = this.getTasksFolderCom();){
            Throwable throwable2 = null;
            Object var5_8 = null;
            try (ICollection<IRegisteredTask> registeredTasks = folder.getTasks();){
                LinkedHashMap<String, GenericTaskScheduleInfo> tasks = new LinkedHashMap<String, GenericTaskScheduleInfo>();
                for (IRegisteredTask task : registeredTasks) {
                    try {
                        Throwable throwable3 = null;
                        Object var11_16 = null;
                        try (ITaskDefinition definition = task.getDefinition();){
                            String projectId = COMSystemScheduler.fetchProjectNameCom(definition);
                            String nameOrId = COMSystemScheduler.getTaskNameOrId(task);
                            GenericTaskScheduleInfo info = new GenericTaskScheduleInfo(projectId, nameOrId, COMSystemScheduler.formatNextRunTime(task.getNextRunTime()), task.getState().toString());
                            tasks.put(nameOrId, info);
                        }
                        catch (Throwable throwable4) {
                            if (throwable3 == null) {
                                throwable3 = throwable4;
                            } else if (throwable3 != throwable4) {
                                throwable3.addSuppressed(throwable4);
                            }
                            throw throwable3;
                        }
                    }
                    finally {
                        task.release();
                    }
                }
                this.registeredTasks.clear();
                this.registeredTasks.putAll(tasks);
            }
            catch (Throwable throwable5) {
                if (throwable2 == null) {
                    throwable2 = throwable5;
                } else if (throwable2 != throwable5) {
                    throwable2.addSuppressed(throwable5);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
            } else if (throwable != throwable6) {
                throwable.addSuppressed(throwable6);
            }
            throw throwable;
        }
    }

    @Nullable
    private static String fetchProjectNameCom(@NotNull ITaskDefinition definition) {
        String arguments = COMSystemScheduler.fetchRunTaskParameterCom(definition);
        if (arguments == null) {
            return null;
        }
        try {
            return (String)COMSystemScheduler.decodeTaskReference(arguments).getFirst();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    private static String fetchRunTaskParameterCom(@NotNull ITaskDefinition definition) {
        var1_1 = null;
        var2_3 = null;
        try {
            actions = definition.getActions();
            try {
                count = actions.getCount();
                i = 0;
                while (true) {
                    block22: {
                        block21: {
                            var6_8 = null;
                            var7_10 = null;
                            action = (IAction)actions.getItem(i);
                            arguments = action.asExecuteAction().getArguments();
                            if (arguments == null) break block21;
                            if (action != null) {
                                action.close();
                            }
                            return arguments;
                        }
                        try {
                            if (action != null) {
                                action.close();
                            }
                            break block22;
                            {
                                catch (Throwable var6_9) {
                                    if (action != null) {
                                        action.close();
                                    }
                                    throw var6_9;
                                }
                            }
                        }
                        catch (Throwable var7_11) {
                            if (var6_8 == null) {
                                var6_8 = var7_11;
                            } else if (var6_8 != var7_11) {
                                var6_8.addSuppressed(var7_11);
                            }
                            throw var6_8;
                        }
                    }
                    ++i;
                    return i;
                }
            }
            finally {
                if (i < count) ** continue;
            }
        }
        catch (Throwable var2_4) {
            if (var1_1 == null) {
                var1_1 = var2_4;
            } else if (var1_1 != var2_4) {
                var1_1.addSuppressed(var2_4);
            }
            throw var1_1;
        }
        return null;
    }

    @Nullable
    public DBTSchedulerExternalSettings openSchedulerSettings() throws DBException {
        RuntimeUtils.executeProcess((String)"cmd.exe", (String[])new String[]{"/C", "start", "taskschd.msc"});
        return null;
    }

    /*
     * Exception decompiling
     */
    @NotNull
    private ITaskFolder getTasksFolderCom() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK], 1[TRYBLOCK], 3[TRYBLOCK]], but top level block is 12[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    private static IRegisteredTask findRegisteredTaskCom(@NotNull ITaskFolder folder, @NotNull DBTTask task) {
        var2_2 = null;
        var3_4 = null;
        try {
            tasks = folder.getTasks();
            try {
                var6_7 = tasks.iterator();
                while (true) {
                    registeredTask = var6_7.next();
                    nameOrId = COMSystemScheduler.getTaskNameOrId(registeredTask);
                    if (task.getName().equals(nameOrId) || task.getId().equals(nameOrId)) {
                        return registeredTask;
                    }
                    registeredTask.release();
                    break;
                }
            }
            finally {
                if (var6_7.hasNext()) ** continue;
            }
        }
        catch (Throwable var3_5) {
            if (var2_2 == null) {
                var2_2 = var3_5;
            } else if (var2_2 != var3_5) {
                var2_2.addSuppressed(var3_5);
            }
            throw var2_2;
        }
        return null;
    }

    @NotNull
    private static String formatNextRunTime(@Nullable LocalDateTime nextRunTime) {
        if (nextRunTime == null) {
            return "N/A";
        }
        return DATE_TIME_FORMATTER.format(nextRunTime);
    }

    @NotNull
    private static String getUniqueTaskName(@NotNull DBTTask task) {
        return String.format("%s (%s)", task.getName().replaceAll("\\|/|:|\\*|\\?|\"|<|>|\\|", "\ufffd"), task.getId());
    }

    @NotNull
    private static String getTaskNameOrId(@NotNull IRegisteredTask task) {
        String name = task.getName();
        Matcher matcher = TASK_NAME_PATTERN.matcher(name);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return name;
    }

    @NotNull
    private static String generateLaunchArguments(@NotNull DBTTask task) {
        return "-data \"%s\" -runTask \"%s\" -nosplash".formatted(COMSystemScheduler.getDataParameter(task), COMSystemScheduler.getRunTaskParameter(task));
    }

    private <T> T runInComThread(@NotNull Callable<T> callable) throws DBException {
        try {
            return (T)comThread.execute(callable);
        }
        catch (InterruptedException | TimeoutException ex) {
            throw new RuntimeException(ex);
        }
        catch (ExecutionException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof DBException) {
                DBException db = (DBException)cause;
                throw db;
            }
            throw new DBException("Error in COM thread", (Throwable)ex);
        }
    }

    static /* synthetic */ int[] $SWITCH_TABLE$com$dbeaver$model$win32$com$TaskLogon() {
        if ($SWITCH_TABLE$com$dbeaver$model$win32$com$TaskLogon != null) {
            return $SWITCH_TABLE$com$dbeaver$model$win32$com$TaskLogon;
        }
        int[] nArray = new int[TaskLogon.values().length];
        try {
            nArray[TaskLogon.INTERACTIVE_TOKEN.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TaskLogon.PASSWORD.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TaskLogon.SERVICE_FOR_USER.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$com$dbeaver$model$win32$com$TaskLogon = nArray;
        return nArray;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$com$dbeaver$model$win32$com$trigger$ITrigger$Type() {
        if ($SWITCH_TABLE$com$dbeaver$model$win32$com$trigger$ITrigger$Type != null) {
            return $SWITCH_TABLE$com$dbeaver$model$win32$com$trigger$ITrigger$Type;
        }
        int[] nArray = new int[ITrigger.Type.values().length];
        try {
            nArray[ITrigger.Type.DAILY.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ITrigger.Type.MONTHLY.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ITrigger.Type.TIME.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ITrigger.Type.WEEKLY.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$com$dbeaver$model$win32$com$trigger$ITrigger$Type = nArray;
        return nArray;
    }

    private static /* synthetic */ Short lambda$3(TaskDayOfWeek x) {
        return (short)(x.ordinal() + 1);
    }

    private static /* synthetic */ Short lambda$4(TaskDayOfMonth x) {
        return (short)(x.ordinal() + 1);
    }

    private static /* synthetic */ Short lambda$5(TaskMonthOfYear x) {
        return (short)x.ordinal();
    }
}

