/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.sched.system.cron;

import com.dbeaver.ee.sched.system.BaseSystemScheduler;
import com.dbeaver.ee.sched.system.GenericTaskScheduleInfo;
import com.dbeaver.ee.sched.system.cron.ConfigurationConverter;
import com.dbeaver.ee.sched.system.cron.CrontabEditor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.task.DBTScheduler;
import org.jkiss.dbeaver.model.task.DBTSchedulerExternalSettings;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskScheduleConfiguration;
import org.jkiss.dbeaver.model.task.DBTTaskScheduleInfo;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.Pair;

public class CronSystemScheduler
extends BaseSystemScheduler {
    private static final Log log = Log.getLog(CronSystemScheduler.class);

    @NotNull
    public String getSchedulerName() {
        return "Local CRON scheduler";
    }

    public boolean supportsFeature(String feature) {
        return switch (feature) {
            case "frequency.hourly.executionMinute", "frequency.daily", "openExternalSettings", "frequency.minutely", "frequency.hourly", "frequency.monthly", "frequency.weekly" -> true;
            default -> false;
        };
    }

    public DBTScheduler.RecurrenceType getRecurrenceType() {
        return DBTScheduler.RecurrenceType.Cron;
    }

    @NotNull
    public List<DBTTaskScheduleInfo> getAllScheduledTasks() {
        CrontabEditor editor;
        try {
            editor = CrontabEditor.loadCrontab();
        }
        catch (IOException e) {
            log.warn((Object)"Failed to load crontab", (Throwable)e);
            return Collections.emptyList();
        }
        DBPWorkspace workspace = DBWorkbench.getPlatform().getWorkspace();
        ArrayList<GenericTaskScheduleInfo> info = new ArrayList<GenericTaskScheduleInfo>();
        for (Map.Entry<String, String> task : editor.getTasks().entrySet()) {
            String ref = task.getKey();
            String cronExpr = task.getValue();
            String projectId = null;
            String taskId = ref;
            try {
                Pair<String, String> pair = CronSystemScheduler.decodeTaskReference(ref);
                String projectName = (String)pair.getFirst();
                taskId = (String)pair.getSecond();
                projectId = Optional.ofNullable(workspace.getProject(projectName)).map(DBPProject::getId).orElse(null);
            }
            catch (IllegalArgumentException e) {
                log.warn((Object)("Invalid task reference: " + ref), (Throwable)e);
            }
            info.add(new GenericTaskScheduleInfo(projectId, taskId, ConfigurationConverter.nextRunInfo(this.extractCronExpression(cronExpr)), null));
        }
        return Collections.unmodifiableList(info);
    }

    @Nullable
    public DBTTaskScheduleInfo getScheduledTaskInfo(@NotNull DBTTask task) {
        CrontabEditor editor;
        try {
            editor = CrontabEditor.loadCrontab();
        }
        catch (IOException iOException) {
            return null;
        }
        String cronEntry = editor.get(CronSystemScheduler.getRunTaskParameter(task));
        if (cronEntry == null) {
            return null;
        }
        return new GenericTaskScheduleInfo(task.getProject().getId(), task.getId(), ConfigurationConverter.nextRunInfo(this.extractCronExpression(cronEntry)), null);
    }

    @Nullable
    public DBTTaskScheduleConfiguration getScheduledTaskConfiguration(@NotNull DBTTask task) throws DBException {
        CrontabEditor editor;
        try {
            editor = CrontabEditor.loadCrontab();
        }
        catch (IOException e) {
            throw new DBException("Unable to load crontab", (Throwable)e);
        }
        String entry = editor.get(CronSystemScheduler.getRunTaskParameter(task));
        if (entry == null) {
            return null;
        }
        String cronExpression = this.extractCronExpression(entry);
        if (cronExpression == null) {
            return null;
        }
        return ConfigurationConverter.toDBTTaskScheduleConfiguration(cronExpression);
    }

    public boolean setTaskSchedule(@NotNull DBTTask task, @NotNull DBTTaskScheduleConfiguration scheduleConfiguration) throws DBException {
        String crontabEntry = this.generateCrontabEntry(task, scheduleConfiguration);
        try {
            CrontabEditor editor = CrontabEditor.loadCrontab();
            editor.upsert(CronSystemScheduler.getRunTaskParameter(task), crontabEntry);
            editor.flush();
        }
        catch (IOException e) {
            throw new DBException("Unable to read or write to crontab", (Throwable)e);
        }
        return true;
    }

    public void removeTaskSchedule(@NotNull DBTTask task, DBTTaskScheduleInfo scheduleInfo) throws DBException {
        try {
            CrontabEditor editor = CrontabEditor.loadCrontab();
            editor.remove(CronSystemScheduler.getRunTaskParameter(task));
            editor.flush();
        }
        catch (IOException e) {
            throw new DBException("Unable to read or write to crontab", (Throwable)e);
        }
    }

    public void refreshScheduledTasks(@NotNull DBRProgressMonitor monitor) {
    }

    public DBTSchedulerExternalSettings openSchedulerSettings() throws DBException {
        try {
            DBTSchedulerExternalSettings settings = new DBTSchedulerExternalSettings();
            settings.setPlaintextDetails(CrontabEditor.readCrontab());
            return settings;
        }
        catch (IOException e) {
            throw new DBException("Error reading crontab", (Throwable)e);
        }
    }

    private String generateCrontabEntry(@NotNull DBTTask task, DBTTaskScheduleConfiguration scheduleConfiguration) throws DBException {
        String cronExpr = ConfigurationConverter.toCronExpression(scheduleConfiguration);
        return cronExpr + " PATH=" + CommonUtils.escapeBourneShellString((String)System.getenv("PATH")) + " " + CommonUtils.escapeBourneShellString((String)System.getProperty("eclipse.launcher")) + " -data " + CommonUtils.escapeBourneShellString((String)CronSystemScheduler.getDataParameter(task)) + " -runTask " + CommonUtils.escapeBourneShellString((String)CronSystemScheduler.getRunTaskParameter(task)) + " -nosplash";
    }

    private String extractCronExpression(String cronEntry) {
        int countOfSpaces = 0;
        int i = 0;
        while (i < cronEntry.length()) {
            if (cronEntry.charAt(i) == ' ') {
                ++countOfSpaces;
            }
            if (countOfSpaces == 5) {
                return cronEntry.substring(0, i);
            }
            ++i;
        }
        return null;
    }
}

