/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.google.bigtable.exec;

import com.dbeaver.db.google.bigtable.exec.BigTableSession;
import com.dbeaver.db.google.bigtable.model.BigTableDataSource;
import com.dbeaver.db.google.bigtable.model.BigTableInstance;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.exec.DBCCachedContextDefaults;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCFeatureNotSupportedException;
import org.jkiss.dbeaver.model.exec.DBCInvalidatePhase;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.impl.AbstractExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;

public class BigTableExecutionContext
extends AbstractExecutionContext<BigTableDataSource>
implements DBCExecutionContextDefaults<BigTableInstance, DBSSchema> {
    private static final Log log = Log.getLog(BigTableExecutionContext.class);
    private final BigTableInstance instance;

    public BigTableExecutionContext(BigTableInstance instance, String purpose) {
        super((DBPDataSource)instance.getDataSource(), purpose);
        this.instance = instance;
    }

    public void connect(DBRProgressMonitor monitor) throws DBCException {
        DBExecUtils.startContextInitiation((DBPDataSourceContainer)((BigTableDataSource)this.dataSource).getContainer());
        try {
            try {
                monitor.subTask("Open BigTableDB session");
                ((BigTableDataSource)this.dataSource).getContainer().getActualConnectionConfiguration();
                super.initContextBootstrap(monitor, true);
            }
            catch (Exception e) {
                throw new DBCException((Throwable)e, (DBCExecutionContext)this);
            }
        }
        finally {
            DBExecUtils.finishContextInitiation((DBPDataSourceContainer)((BigTableDataSource)this.dataSource).getContainer());
        }
    }

    @NotNull
    public BigTableSession openSession(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionPurpose purpose, @NotNull String taskTitle) {
        return new BigTableSession(monitor, purpose, taskTitle, this);
    }

    public void checkContextAlive(DBRProgressMonitor monitor) throws DBException {
        try {
            this.instance.getDataSource().getInstanceAdminClient().listInstances();
        }
        catch (Exception e) {
            throw new DBException("Error pinging BigTable", (Throwable)e);
        }
    }

    public BigTableInstance getOwnerInstance() {
        return this.instance;
    }

    public boolean isConnected() {
        return true;
    }

    public void invalidateContext(@NotNull DBRProgressMonitor monitor, @NotNull DBCInvalidatePhase phase) {
    }

    public void close() {
        super.closeContext();
    }

    @Nullable
    public DBCExecutionContextDefaults getContextDefaults() {
        return this;
    }

    public BigTableInstance getDefaultCatalog() {
        return ((BigTableDataSource)this.getDataSource()).getDefaultInstance();
    }

    public DBSSchema getDefaultSchema() {
        return null;
    }

    public boolean supportsCatalogChange() {
        return true;
    }

    public boolean supportsSchemaChange() {
        return false;
    }

    public void setDefaultCatalog(DBRProgressMonitor monitor, BigTableInstance catalog, DBSSchema schema) throws DBCException {
        ((BigTableDataSource)this.getDataSource()).setDefaultInstance(monitor, catalog, (DBCExecutionContext)this);
    }

    public void setDefaultSchema(DBRProgressMonitor monitor, DBSSchema schema) throws DBCException {
        throw new DBCFeatureNotSupportedException();
    }

    public boolean refreshDefaults(DBRProgressMonitor monitor, boolean useBootstrapSettings) throws DBException {
        return false;
    }

    @NotNull
    public DBCCachedContextDefaults getCachedDefault() {
        return new DBCCachedContextDefaults(this.instance.getName(), null);
    }
}

