/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.azure.sql;

import com.azure.resourcemanager.cosmos.CosmosManager;
import com.azure.resourcemanager.cosmos.models.CosmosDBAccount;
import com.azure.resourcemanager.cosmos.models.DatabaseAccountKind;
import com.dbeaver.cloud.azure.AzureCloudAbstractInstance;
import com.dbeaver.cloud.azure.AzureCloudService;
import com.dbeaver.cloud.azure.AzureCloudSession;
import com.dbeaver.cloud.azure.AzureCloudZone;
import com.dbeaver.net.auth.azure.AuthModelAzureCredentials;
import java.util.List;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class AzureCloudCosmosNoSQLInstance
extends AzureCloudAbstractInstance {
    private static final Log log = Log.getLog(AzureCloudCosmosNoSQLInstance.class);
    private final CosmosDBAccount instance;

    public AzureCloudCosmosNoSQLInstance(@NotNull AzureCloudSession session, @NotNull CosmosDBAccount instance) {
        super(session, new AzureCloudZone(instance.region()));
        this.instance = instance;
    }

    @NotNull
    public static List<AzureCloudAbstractInstance> list(@NotNull DBRProgressMonitor monitor, @NotNull AzureCloudSession session) throws DBException {
        AuthModelAzureCredentials credentials = session.getCredentials();
        CosmosManager manager = (CosmosManager)credentials.authenticateWithToken(monitor, (AuthModelAzureCredentials.AzureScopes)AuthModelAzureCredentials.Resource.MANAGEMENT, CosmosManager::authenticate);
        return manager.databaseAccounts().list().stream().filter(it -> it.kind().equals((Object)DatabaseAccountKind.GLOBAL_DOCUMENT_DB)).map(server -> new AzureCloudCosmosNoSQLInstance(session, (CosmosDBAccount)server)).collect(Collectors.toList());
    }

    public static AzureCloudCosmosNoSQLInstance get(@NotNull DBRProgressMonitor monitor, @NotNull AzureCloudSession session, @NotNull String instanceID) throws DBException {
        AuthModelAzureCredentials credentials = session.getCredentials();
        CosmosManager manager = (CosmosManager)credentials.authenticateWithToken(monitor, (AuthModelAzureCredentials.AzureScopes)AuthModelAzureCredentials.Resource.MANAGEMENT, CosmosManager::authenticate);
        CosmosDBAccount instance = (CosmosDBAccount)manager.databaseAccounts().getById(instanceID);
        return instance == null ? null : new AzureCloudCosmosNoSQLInstance(session, instance);
    }

    @Nullable
    public String getInstanceEndpoint() {
        return this.instance.documentEndpoint();
    }

    @NotNull
    public String getNodeId() {
        return this.instance.id();
    }

    @NotNull
    public String getNodeName() {
        return this.instance.name();
    }

    @NotNull
    public String getCloudResourceId() {
        return this.instance.id();
    }

    @Override
    protected void setDataSourceConfiguration(@NotNull DBPConnectionConfiguration configuration) throws DBException {
        configuration.setServerName(this.instance.documentEndpoint());
        configuration.setAuthModelId("azure_ad_cosmos_nosql");
    }

    @Override
    @NotNull
    protected AzureCloudService getCloudService() {
        return AzureCloudService.COSMOS_NOSQL;
    }
}

