/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.azure.config;

import com.dbeaver.cloud.azure.AzureCloudConfiguration;
import com.dbeaver.cloud.azure.AzureCloudServiceAccount;
import com.dbeaver.cloud.model.CPCloudConfiguration;
import com.dbeaver.cloud.model.CPCloudServiceAccount;
import com.dbeaver.cloud.registry.BaseCloudConfigurationProvider;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.secret.DBSSecretController;
import org.jkiss.utils.CommonUtils;

public class AzureLocalConfigurationProvider
extends BaseCloudConfigurationProvider<AzureCloudConfiguration> {
    private static final Log log = Log.getLog(AzureLocalConfigurationProvider.class);

    protected String getCloudTypeId() {
        return "azure";
    }

    public Class<AzureCloudConfiguration> getCloudConfigurationClass() {
        return AzureCloudConfiguration.class;
    }

    public Class<? extends CPCloudServiceAccount> getCloudServiceAccountClass() {
        return AzureCloudServiceAccount.class;
    }

    protected boolean loadSecureProperties(AzureCloudConfiguration cfg) throws DBException {
        boolean secureLoaded = super.loadSecureProperties((CPCloudConfiguration)cfg);
        try {
            DBSSecretController secretController = this.getSecretController();
            String secretKey = secretController.getPrivateSecretValue(this.getSecretId((CPCloudConfiguration)cfg, "azure.storage-account-key"));
            if (!CommonUtils.isEmpty((String)secretKey)) {
                cfg.setStorageAccountKey(secretKey);
            }
            return true;
        }
        catch (Exception e) {
            log.error((Object)e);
            return secureLoaded;
        }
    }

    protected boolean saveSecureProperties(AzureCloudConfiguration cfg) throws DBException {
        boolean isSecure = super.saveSecureProperties((CPCloudConfiguration)cfg);
        try {
            DBSSecretController secretController = this.getSecretController();
            String storageAccountKey = cfg.getStorageAccountKey();
            secretController.setPrivateSecretValue(this.getSecretId((CPCloudConfiguration)cfg, "azure.storage-account-key"), CommonUtils.isEmpty((String)storageAccountKey) ? null : storageAccountKey);
            return true;
        }
        catch (Exception e) {
            if (e instanceof DBException) {
                throw e;
            }
            log.error((Object)e);
            return isSecure;
        }
    }
}

