/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.azure;

import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.registry.DataSourceProviderDescriptor;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;

public enum AzureCloudService {
    SQLSERVER("sqlserver", "sqlserver-ee", "azure-ee"),
    POSTGRESQL("postgresql", "postgresql", "postgres-jdbc"),
    MYSQL("mysql", "mysql-ee", "mysql8"),
    COSMOS_MONGO("azure-cosmosdb-mongo", "cosmos-mongo", "cosmos-mongodb"),
    COSMOS_CASSANDRA("azure-cosmosdb-cassandra", "cosmos-cassandra", "cosmos-cassandra"),
    COSMOS_NOSQL("azure-cosmosdb-nosql", "cosmos-nosql", "cosmos-nosql");

    private final String id;
    private final String providerId;
    private final String driverId;

    private AzureCloudService(@NotNull String id, String providerId, String driverId) {
        this.id = id;
        this.providerId = providerId;
        this.driverId = driverId;
    }

    public static AzureCloudService getServiceByDriver(DBPDriver driver) {
        AzureCloudService[] azureCloudServiceArray = AzureCloudService.values();
        int n = azureCloudServiceArray.length;
        int n2 = 0;
        while (n2 < n) {
            AzureCloudService service = azureCloudServiceArray[n2];
            if (service.providerId.equals(driver.getProviderId()) && service.driverId.equals(driver.getId())) {
                return service;
            }
            ++n2;
        }
        return null;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getProviderId() {
        return this.providerId;
    }

    @NotNull
    public String getDriverId() {
        return this.driverId;
    }

    @NotNull
    public DBPDriver getInstanceDriver() throws DBException {
        DataSourceProviderDescriptor provider = DataSourceProviderRegistry.getInstance().getDataSourceProvider(this.providerId);
        if (provider == null) {
            throw new DBException("Datasource provider '" + this.providerId + "' not found");
        }
        DriverDescriptor driver = provider.getDriver(this.driverId);
        if (driver == null) {
            throw new DBException("Driver '" + this.driverId + "' not found");
        }
        return driver;
    }
}

