/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.azure;

import com.azure.resourcemanager.sql.SqlServerManager;
import com.azure.resourcemanager.sql.models.SqlDatabase;
import com.azure.resourcemanager.sql.models.SqlServer;
import com.dbeaver.cloud.azure.AzureCloudConfiguration;
import com.dbeaver.cloud.azure.AzureCloudDataSourceOrigin;
import com.dbeaver.cloud.azure.AzureCloudDataSourceStorage;
import com.dbeaver.cloud.azure.AzureCloudExplorer;
import com.dbeaver.cloud.azure.AzureCloudProvider;
import com.dbeaver.cloud.azure.AzureCloudSession;
import com.dbeaver.cloud.azure.AzureCloudZone;
import com.dbeaver.cloud.impl.AbstractCloud;
import com.dbeaver.cloud.impl.AbstractCloudConfiguration;
import com.dbeaver.cloud.model.CPCloudProvider;
import com.dbeaver.cloud.model.CPCloudSessionManager;
import com.dbeaver.cloud.registry.CloudProviderDescriptor;
import com.dbeaver.cloud.registry.CloudProviderRegistry;
import com.dbeaver.net.auth.azure.AuthModelAzureCredentials;
import java.util.LinkedHashMap;
import java.util.StringJoiner;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.auth.SMAuthSpace;
import org.jkiss.dbeaver.model.auth.SMSessionProviderService;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;

public class AzureCloud
extends AbstractCloud<AzureCloudProvider, AzureCloudConfiguration, AzureCloudZone, AzureCloudSession>
implements CPCloudSessionManager<AzureCloudSession, AzureCloudZone> {
    private static final Log log = Log.getLog(AzureCloud.class);
    private final AzureCloudDataSourceStorage dataSourceStorage = new AzureCloudDataSourceStorage(this);

    public AzureCloud(AzureCloudProvider provider, AzureCloudConfiguration configuration) {
        super((CPCloudProvider)provider, (AbstractCloudConfiguration)configuration);
    }

    @Nullable
    public AzureCloudSession getActiveSession() {
        DBPWorkspace workspace = DBWorkbench.getPlatform().getWorkspace();
        try {
            return (AzureCloudSession)workspace.getAuthContext().getSpaceSession((DBRProgressMonitor)new VoidProgressMonitor(), (SMAuthSpace)this, false);
        }
        catch (DBException e) {
            log.debug((Object)"Error retrieving cloud session", (Throwable)e);
            return null;
        }
    }

    public String testConnection(DBRProgressMonitor monitor) throws DBException {
        DBPWorkspace workspace = DBWorkbench.getPlatform().getWorkspace();
        SMSessionProviderService service = (SMSessionProviderService)DBWorkbench.getService(SMSessionProviderService.class);
        if (service == null) {
            throw new DBException("Can't obtain session provider");
        }
        monitor.beginTask("Connecting to Azure", 1);
        AzureCloudSession session = (AzureCloudSession)workspace.getAuthContext().getSpaceSession(monitor, (SMAuthSpace)this, true);
        if (session == null) {
            throw new DBException("Azure session not found");
        }
        try {
            AuthModelAzureCredentials credentials = session.getCredentials();
            SqlServerManager manager = (SqlServerManager)credentials.authenticateWithToken(monitor, (AuthModelAzureCredentials.AzureScopes)AuthModelAzureCredentials.Resource.MANAGEMENT, SqlServerManager::authenticate);
            StringJoiner joiner = new StringJoiner("\n");
            for (SqlServer server : manager.sqlServers().list()) {
                joiner.add(server.name() + ":");
                for (SqlDatabase database : manager.sqlServers().databases().listBySqlServer(server)) {
                    joiner.add(" - " + database.name() + " (" + database.databaseId() + ")");
                }
            }
            String string = joiner.toString();
            return string;
        }
        finally {
            session.close();
            monitor.done();
        }
    }

    public String refreshSession(DBRProgressMonitor monitor) {
        return null;
    }

    public void closeSession(DBRProgressMonitor monitor) {
    }

    @NotNull
    public AzureCloudDataSourceOrigin createOrigin(@NotNull AzureCloud cloud, @NotNull AzureCloudZone zone, @NotNull String resourceId) {
        CloudProviderDescriptor cloudProvider = CloudProviderRegistry.getInstance().getCloudProvider("azure");
        LinkedHashMap<String, Object> dsConfiguration = new LinkedHashMap<String, Object>();
        dsConfiguration.put("cloud-provider", cloudProvider.getId());
        dsConfiguration.put("cloud-id", cloud.getCloudId());
        dsConfiguration.put("cloud-zone-id", zone.getZoneId());
        dsConfiguration.put("azure-resource", resourceId);
        return new AzureCloudDataSourceOrigin(cloudProvider, dsConfiguration, null);
    }

    @NotNull
    public AzureCloudZone[] getAllZones() {
        return new AzureCloudZone[0];
    }

    @NotNull
    public AzureCloudExplorer createExplorer(@NotNull DBRProgressMonitor monitor, @NotNull AzureCloudSession session) {
        return new AzureCloudExplorer(this, session);
    }

    @NotNull
    public AzureCloudDataSourceStorage getDataSourceStorage() {
        return this.dataSourceStorage;
    }
}

