/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.databricks.diff.output.changelog;

import java.util.Arrays;
import liquibase.change.Change;
import liquibase.database.Database;
import liquibase.diff.Difference;
import liquibase.diff.ObjectDifferences;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.diff.output.changelog.core.ChangedViewChangeGenerator;
import liquibase.ext.databricks.change.AbstractAlterPropertiesChangeDatabricks;
import liquibase.ext.databricks.database.DatabricksDatabase;
import liquibase.ext.databricks.diff.output.changelog.ChangedTblPropertiesUtil;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.View;

public class ChangedViewChangeGeneratorDatabricks
extends ChangedViewChangeGenerator {
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (database instanceof DatabricksDatabase && super.getPriority(objectType, database) > -1) {
            return 5;
        }
        return -1;
    }

    public Change[] fixChanged(DatabaseObject changedObject, ObjectDifferences differences, DiffOutputControl control, Database referenceDatabase, Database comparisonDatabase, ChangeGeneratorChain chain) {
        Change[] otherChanges;
        Object[] changes = null;
        for (Difference difference : differences.getDifferences()) {
            if (!difference.getField().equals("tblProperties")) continue;
            AbstractAlterPropertiesChangeDatabricks[] change = ChangedTblPropertiesUtil.getAlterViewPropertiesChangeDatabricks((View)changedObject, control, difference);
            if (changes == null) {
                changes = change;
            } else {
                changes = Arrays.copyOf(changes, changes.length + change.length);
                System.arraycopy(change, 0, changes, changes.length - change.length, change.length);
            }
            differences.removeDifference("tblProperties");
        }
        if (differences.hasDifferences() && (otherChanges = super.fixChanged(changedObject, differences, control, referenceDatabase, comparisonDatabase, chain)) != null) {
            if (changes == null) {
                changes = otherChanges;
            } else {
                changes = Arrays.copyOf(changes, changes.length + otherChanges.length);
                System.arraycopy(otherChanges, 0, changes, changes.length - otherChanges.length, otherChanges.length);
            }
        }
        return changes;
    }
}

