/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.databricks.datatype;

import java.util.Locale;
import liquibase.Scope;
import liquibase.database.Database;
import liquibase.database.core.H2Database;
import liquibase.database.core.HsqlDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.database.core.SybaseASADatabase;
import liquibase.datatype.DataTypeInfo;
import liquibase.datatype.DatabaseDataType;
import liquibase.datatype.core.TimestampType;
import liquibase.exception.DatabaseIncapableOfOperation;
import liquibase.ext.databricks.database.DatabricksDatabase;
import liquibase.util.grammar.ParseException;
import org.apache.commons.lang3.StringUtils;

@DataTypeInfo(name="timestamp", aliases={"java.sql.Types.TIMESTAMP", "java.sql.Types.TIMESTAMP_WITH_TIMEZONE", "java.sql.Timestamp", "timestamptz"}, minParameters=0, maxParameters=0, priority=5)
public class TimestampDatatypeDatabricks
extends TimestampType {
    public DatabaseDataType toDatabaseDataType(Database database) {
        String originalDefinition = StringUtils.trimToEmpty((String)this.getRawDefinition());
        if (this.getParameters().length > 0) {
            int maxFractionalDigits;
            Integer desiredLength = null;
            try {
                desiredLength = Integer.parseInt(String.valueOf(this.getParameters()[0]));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (desiredLength != null && (maxFractionalDigits = database.getMaxFractionalDigitsForTimestamp()) < desiredLength) {
                throw new DatabaseIncapableOfOperation(String.format("Using a TIMESTAMP data type with a fractional precision of %d", desiredLength), String.format("A timestamp datatype with %d fractional digits was requested, but %s only supports %d digits.", desiredLength, database.getDatabaseProductName(), maxFractionalDigits), database);
            }
        }
        if (this.getParameters().length > 0) {
            int fractionalDigits;
            String fractionalDigitsInput = this.getParameters()[0].toString();
            try {
                fractionalDigits = Integer.parseInt(fractionalDigitsInput);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException((Throwable)new ParseException(String.format("A timestamp with '%s' fractional digits was requested, but '%s' does not seem to be an integer.", fractionalDigitsInput, fractionalDigitsInput)));
            }
            int maxFractionalDigits = database.getMaxFractionalDigitsForTimestamp();
            if (maxFractionalDigits < fractionalDigits) {
                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning(String.format("A timestamp datatype with %d fractional digits was requested, but the DBMS %s only supports %d digits. Because of this, the number of digits was reduced to %d.", fractionalDigits, database.getDatabaseProductName(), maxFractionalDigits, maxFractionalDigits));
            }
        }
        DatabaseDataType type = new DatabaseDataType("TIMESTAMP");
        if (originalDefinition.startsWith("java.sql.Types.TIMESTAMP_WITH_TIMEZONE") && (database instanceof PostgresDatabase || database instanceof OracleDatabase || database instanceof H2Database || database instanceof HsqlDatabase || database instanceof SybaseASADatabase)) {
            if (database instanceof PostgresDatabase || database instanceof H2Database || database instanceof SybaseASADatabase) {
                type.addAdditionalInformation("WITH TIME ZONE");
            } else {
                type.addAdditionalInformation("WITH TIMEZONE");
            }
            return type;
        }
        if (this.getAdditionalInformation() != null && (database instanceof PostgresDatabase || database instanceof OracleDatabase) || database instanceof H2Database || database instanceof HsqlDatabase || database instanceof SybaseASADatabase) {
            String additionalInformation = this.getAdditionalInformation();
            if (additionalInformation != null) {
                String additionInformation = additionalInformation.toUpperCase(Locale.US);
                if ((database instanceof PostgresDatabase || database instanceof H2Database || database instanceof SybaseASADatabase) && additionInformation.toUpperCase(Locale.US).contains("TIMEZONE")) {
                    additionalInformation = additionInformation.toUpperCase(Locale.US).replace("TIMEZONE", "TIME ZONE");
                }
            }
            type.addAdditionalInformation(additionalInformation);
            return type;
        }
        return super.toDatabaseDataType(database);
    }

    public boolean supports(Database database) {
        return database instanceof DatabricksDatabase;
    }
}

