/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.databricks.change.vacuumTable;

import liquibase.database.Database;
import liquibase.exception.ValidationErrors;
import liquibase.ext.databricks.change.vacuumTable.VacuumTableStatement;
import liquibase.ext.databricks.database.DatabricksDatabase;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.structure.DatabaseObject;

public class VacuumTableGenerator
extends AbstractSqlGenerator<VacuumTableStatement> {
    public boolean supports(VacuumTableStatement statement, Database database) {
        return database instanceof DatabricksDatabase;
    }

    public ValidationErrors validate(VacuumTableStatement statement, Database database, SqlGeneratorChain chain) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkRequiredField("tableName", (Object)statement.getTableName());
        return validationErrors;
    }

    public Sql[] generateSql(VacuumTableStatement statement, Database database, SqlGeneratorChain chain) {
        StringBuilder sql = new StringBuilder("VACUUM ");
        sql.append(database.escapeTableName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName()));
        if (statement.getRetentionHours() != null) {
            sql.append(" RETAIN ").append(statement.getRetentionHours().toString()).append(" HOURS ");
        }
        return new Sql[]{new UnparsedSql(sql.toString(), new DatabaseObject[0])};
    }
}

