/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.databricks.change.vacuumTable;

import java.text.MessageFormat;
import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.databricks.change.vacuumTable.VacuumTableStatement;
import liquibase.ext.databricks.database.DatabricksDatabase;
import liquibase.statement.SqlStatement;
import lombok.Generated;

@DatabaseChange(name="vacuumTable", description="Vacuum Old Files from Table", priority=5)
public class VacuumTableChange
extends AbstractChange {
    private String catalogName;
    private String schemaName;
    private String tableName;
    private Integer retentionHours;

    public String getConfirmationMessage() {
        return MessageFormat.format("{0}.{1}.{2} successfully vacuumed.", this.getCatalogName(), this.getSchemaName(), this.getTableName());
    }

    public boolean supports(Database database) {
        return database instanceof DatabricksDatabase;
    }

    protected Change[] createInverses() {
        return new Change[0];
    }

    public SqlStatement[] generateStatements(Database database) {
        VacuumTableStatement statement = new VacuumTableStatement();
        statement.setCatalogName(this.getCatalogName());
        statement.setSchemaName(this.getSchemaName());
        statement.setTableName(this.getTableName());
        if (this.getRetentionHours() == null) {
            statement.setRetentionHours(168);
        } else {
            statement.setRetentionHours(this.getRetentionHours());
        }
        return new SqlStatement[]{statement};
    }

    @Generated
    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    @Generated
    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @Generated
    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Generated
    public void setRetentionHours(Integer retentionHours) {
        this.retentionHours = retentionHours;
    }

    @Generated
    public String getCatalogName() {
        return this.catalogName;
    }

    @Generated
    public String getSchemaName() {
        return this.schemaName;
    }

    @Generated
    public String getTableName() {
        return this.tableName;
    }

    @Generated
    public Integer getRetentionHours() {
        return this.retentionHours;
    }
}

