/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.databricks.change.alterCluster;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import liquibase.change.AbstractChange;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.database.Database;
import liquibase.exception.ValidationErrors;
import liquibase.ext.databricks.change.alterCluster.AlterClusterDatabricksStatement;
import liquibase.ext.databricks.change.alterCluster.ColumnConfig;
import liquibase.ext.databricks.change.alterCluster.NoneConfig;
import liquibase.statement.SqlStatement;
import lombok.Generated;

@DatabaseChange(name="alterCluster", description="Alter Cluster", priority=505)
public class AlterClusterChangeDatabricks
extends AbstractChange {
    private String tableName;
    private String catalogName;
    private String schemaName;
    private List<ColumnConfig> columns = new ArrayList<ColumnConfig>();
    private List<NoneConfig> clusterBy = new ArrayList<NoneConfig>();

    public ValidationErrors validate(Database database) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.addAll(super.validate(database));
        if (this.columns == null && this.clusterBy == null) {
            validationErrors.addError("Alter Cluster change require list of columns or element 'ClusterBy', please add at least one option.");
        }
        return validationErrors;
    }

    public String getConfirmationMessage() {
        return MessageFormat.format("{0}.{1}.{2} successfully altered.", this.getCatalogName(), this.getSchemaName(), this.getTableName());
    }

    public SqlStatement[] generateStatements(Database database) {
        AlterClusterDatabricksStatement statement = new AlterClusterDatabricksStatement(this.tableName, this.catalogName, this.schemaName);
        if (this.getColumns() != null && !this.getColumns().isEmpty()) {
            statement.setColumns(this.getColumns());
        } else if (this.getClusterBy() != null && !this.getClusterBy().isEmpty()) {
            statement.setClusterBy(this.getClusterBy());
        }
        return new SqlStatement[]{statement};
    }

    @DatabaseChangeProperty
    public String getTableName() {
        return this.tableName;
    }

    @DatabaseChangeProperty
    public List<ColumnConfig> getColumns() {
        if (this.columns == null) {
            return new ArrayList<ColumnConfig>();
        }
        return this.columns;
    }

    @DatabaseChangeProperty
    public String getCatalogName() {
        return this.catalogName;
    }

    @DatabaseChangeProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @DatabaseChangeProperty
    public List<NoneConfig> getClusterBy() {
        if (this.clusterBy == null) {
            return new ArrayList<NoneConfig>();
        }
        return this.clusterBy;
    }

    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/databricks";
    }

    @Generated
    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Generated
    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    @Generated
    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @Generated
    public void setColumns(List<ColumnConfig> columns) {
        this.columns = columns;
    }

    @Generated
    public void setClusterBy(List<NoneConfig> clusterBy) {
        this.clusterBy = clusterBy;
    }
}

