/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.databricks.change;

import java.text.MessageFormat;
import java.util.ArrayList;
import liquibase.change.AbstractChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.database.Database;
import liquibase.exception.ValidationErrors;
import liquibase.ext.databricks.change.AbstractAlterPropertiesStatementDatabricks;
import liquibase.ext.databricks.change.alterTableProperties.SetExtendedTableProperties;
import liquibase.ext.databricks.change.alterTableProperties.UnsetExtendedTableProperties;
import liquibase.ext.databricks.database.DatabricksDatabase;
import liquibase.statement.SqlStatement;
import lombok.Generated;

public abstract class AbstractAlterPropertiesChangeDatabricks
extends AbstractChange {
    private String catalogName;
    private String schemaName;
    private SetExtendedTableProperties setExtendedTableProperties;
    private UnsetExtendedTableProperties unsetExtendedTableProperties;

    public boolean supports(Database database) {
        return database instanceof DatabricksDatabase;
    }

    public ValidationErrors validate(Database database) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.addAll(super.validate(database));
        if (this.setExtendedTableProperties == null && this.unsetExtendedTableProperties == null) {
            validationErrors.addError(this.getNoPropertiesErrorMessage());
        }
        return validationErrors;
    }

    protected abstract String getNoPropertiesErrorMessage();

    protected String applySubjectToErrorPattern(String subject) {
        return MessageFormat.format("Alter {0} Properties change require 'setExtendedTableProperties' or 'unsetExtendedTableProperties' element, please add at least one option.", subject);
    }

    protected String getConfirmationMessage(String elementName) {
        return MessageFormat.format("{0}.{1}.{2} successfully altered.", this.getCatalogName(), this.getSchemaName(), elementName);
    }

    protected SqlStatement[] generateStatements(AbstractAlterPropertiesStatementDatabricks statement) {
        if (this.setExtendedTableProperties != null) {
            statement.setSetExtendedTableProperties(this.setExtendedTableProperties);
        } else if (this.unsetExtendedTableProperties != null) {
            statement.setUnsetExtendedTableProperties(this.unsetExtendedTableProperties);
        }
        ArrayList<AbstractAlterPropertiesStatementDatabricks> statements = new ArrayList<AbstractAlterPropertiesStatementDatabricks>();
        statements.add(statement);
        return statements.toArray(SqlStatement.EMPTY_SQL_STATEMENT);
    }

    @DatabaseChangeProperty
    public String getCatalogName() {
        return this.catalogName;
    }

    @DatabaseChangeProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @DatabaseChangeProperty
    public SetExtendedTableProperties getSetExtendedTableProperties() {
        return this.setExtendedTableProperties;
    }

    @DatabaseChangeProperty
    public UnsetExtendedTableProperties getUnsetExtendedTableProperties() {
        return this.unsetExtendedTableProperties;
    }

    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/databricks";
    }

    @Generated
    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    @Generated
    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @Generated
    public void setSetExtendedTableProperties(SetExtendedTableProperties setExtendedTableProperties) {
        this.setExtendedTableProperties = setExtendedTableProperties;
    }

    @Generated
    public void setUnsetExtendedTableProperties(UnsetExtendedTableProperties unsetExtendedTableProperties) {
        this.unsetExtendedTableProperties = unsetExtendedTableProperties;
    }
}

