/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.google.firestore.edit;

import com.dbeaver.db.google.firestore.exec.FireStoreExecutionContext;
import com.dbeaver.db.google.firestore.model.FireStoreCollection;
import com.dbeaver.db.google.firestore.model.FireStoreDatasource;
import com.google.cloud.firestore.CollectionReference;
import com.google.cloud.firestore.Firestore;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.edit.DirectDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;

public class FirestoreCollectionManager
extends SQLObjectEditor<FireStoreCollection, FireStoreDatasource> {
    public long getMakerOptions(@NotNull DBPDataSource dataSource) {
        return 1L;
    }

    @Nullable
    public DBSObjectCache<? extends DBSObject, FireStoreCollection> getObjectsCache(FireStoreCollection object) {
        return ((FireStoreDatasource)object.getDataSource()).getCollectionCache();
    }

    protected FireStoreCollection createDatabaseObject(@NotNull DBRProgressMonitor monitor, @NotNull DBECommandContext context, Object container, Object copyFrom, @NotNull Map<String, Object> options) throws DBException {
        return new FireStoreCollection((FireStoreDatasource)((Object)container), "NewCollection", null, false);
    }

    protected void addObjectCreateActions(@NotNull DBRProgressMonitor monitor, final @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, final @NotNull SQLObjectEditor.ObjectCreateCommand command, @NotNull Map<String, Object> options) throws DBException {
        actions.add((DBEPersistAction)new DirectDatabasePersistAction("Create collection"){

            public void afterExecute(DBCSession session, Throwable error) throws DBCException {
                FireStoreCollection collection = (FireStoreCollection)command.getObject();
                ((FireStoreExecutionContext)executionContext).getService().collection(collection.getName()).document().set(new HashMap());
            }
        });
    }

    protected void addObjectDeleteActions(@NotNull DBRProgressMonitor monitor, final @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, final @NotNull SQLObjectEditor.ObjectDeleteCommand command, @NotNull Map<String, Object> options) throws DBException {
        actions.add((DBEPersistAction)new DirectDatabasePersistAction("Drop collection " + ((FireStoreCollection)command.getObject()).getFullyQualifiedName(DBPEvaluationContext.UI)){

            public void afterExecute(DBCSession session, Throwable error) throws DBCException {
                FireStoreCollection collection = (FireStoreCollection)command.getObject();
                Firestore service = ((FireStoreExecutionContext)executionContext).getService();
                CollectionReference collectionReference = service.collection(collection.getName());
                service.recursiveDelete(collectionReference);
            }
        });
    }
}

