/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.google.firestore.data;

import com.dbeaver.db.google.firestore.FirestoreUtils;
import com.dbeaver.db.google.firestore.data.FireStoreDocument;
import com.dbeaver.db.google.firestore.exec.FireStoreBaseStatement;
import com.dbeaver.db.google.firestore.exec.FireStoreSession;
import com.dbeaver.db.google.firestore.model.FireStoreDatasource;
import com.dbeaver.model.document.exec.DocumentResultSet;
import com.google.cloud.firestore.DocumentSnapshot;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.data.DBDSubCollectionResultSet;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCStatement;

public class FireStoreResultSet
extends DocumentResultSet<FireStoreSession, FireStoreBaseStatement>
implements DBDSubCollectionResultSet {
    private List<? extends DocumentSnapshot> docs = null;
    private long count = -1L;
    private Object curRow;

    public FireStoreResultSet(FireStoreBaseStatement statement, List<? extends DocumentSnapshot> docs) {
        super((DBCStatement)statement);
        this.docs = docs;
    }

    public FireStoreResultSet(FireStoreBaseStatement statement, long count) {
        super((DBCStatement)statement);
        this.count = count;
    }

    @Nullable
    public Object getAttributeValue(int index) throws DBCException {
        this.checkRowFetched();
        if (index == 0) {
            return this.curRow;
        }
        throw new DBCException("Index out of range (" + index + ")");
    }

    @Nullable
    public Object getAttributeValue(String name) throws DBCException {
        this.checkRowFetched();
        return this.curRow;
    }

    public boolean nextRow() throws DBCException {
        if (this.docs != null) {
            if (this.itemNumber + 1 < this.docs.size()) {
                this.curRow = this.createDocument(this.docs.get(this.itemNumber + 1));
                ++this.itemNumber;
                return true;
            }
            this.curRow = null;
            return false;
        }
        if (this.itemNumber == -1) {
            ++this.itemNumber;
            this.curRow = this.count;
            return true;
        }
        return false;
    }

    @NotNull
    private Object createDocument(DocumentSnapshot documentSnapshot) {
        Map<String, Object> rawData = FirestoreUtils.enrichDocumentMapWithProperties(documentSnapshot.getData(), documentSnapshot.getId(), documentSnapshot.getReference().getPath());
        return new FireStoreDocument((FireStoreDatasource)((FireStoreSession)this.getSession()).getDataSource(), rawData, documentSnapshot.getId(), documentSnapshot.getReference().getPath(), documentSnapshot.getCreateTime().toSqlTimestamp());
    }
}

