/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc;

import com.dbeaver.jdbc.JdbcDriverLicenseProvider;
import com.dbeaver.jdbc.JdbcDriverLicensed;
import com.dbeaver.lm.api.LMEncryption;
import com.dbeaver.lm.api.LMEnvironment;
import com.dbeaver.lm.api.LMException;
import com.dbeaver.lm.api.LMKeyProvider;
import com.dbeaver.lm.api.LMLicense;
import com.dbeaver.lm.api.LMLicenseManager;
import com.dbeaver.lm.api.LMProduct;
import com.dbeaver.lm.api.LMUtils;
import java.io.InputStream;
import java.security.Key;
import java.security.PublicKey;

public class FileJdbcDriverLicenseProvider
extends JdbcDriverLicenseProvider {
    public static void activate() {
        instance.compareAndSet(null, new FileJdbcDriverLicenseProvider());
    }

    @Override
    public LMLicense locateDriverLicense(JdbcDriverLicensed driver) throws LMException {
        LMEnvironment lmEnvironment = new LMEnvironment();
        lmEnvironment.setProductPurchaseURL("");
        lmEnvironment.setArchiveURL("");
        final PublicKey publicKey = FileJdbcDriverLicenseProvider.readPublicKey();
        LMLicenseManager licenseManager = new LMLicenseManager(lmEnvironment, new LMKeyProvider(){

            public Key getEncryptionKey(LMProduct product) {
                return null;
            }

            public Key getDecryptionKey(LMProduct product) {
                return publicKey;
            }
        }, null);
        LMLicense[] licenses = licenseManager.getProductLicenses(driver.getLicensedProduct());
        if (licenses.length == 0) {
            throw new LMException("No license found", LMLicenseManager.getLastLicenseReadError());
        }
        return licenses[0];
    }

    private static PublicKey readPublicKey() throws LMException {
        try {
            Throwable throwable = null;
            Object var1_3 = null;
            try (InputStream keyStream = FileJdbcDriverLicenseProvider.class.getResourceAsStream("jdbc-drivers-product-public.key");){
                byte[] keyData = LMUtils.readEncryptedString((InputStream)keyStream);
                return LMEncryption.generatePublicKey((byte[])keyData);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new LMException((Throwable)e);
        }
    }
}

