/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.editors.spelling;

import com.dbeaver.ui.editors.javadoc.IHtmlTagConstants;
import com.dbeaver.ui.editors.spelling.engine.DefaultSpellChecker;
import com.dbeaver.ui.editors.spelling.engine.ISpellCheckIterator;
import java.text.BreakIterator;
import java.util.LinkedList;
import java.util.Locale;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;

public class SpellCheckIterator
implements ISpellCheckIterator {
    private static final int WHITE_SPACE_TOKEN = -1;
    protected final String content;
    private final String delimiter;
    protected String lastToken = null;
    protected int next = 1;
    protected final int offset;
    private int predecessor;
    protected int previous = 0;
    private final LinkedList<Integer> sentenceBreaks = new LinkedList();
    private boolean startsSentence = false;
    protected int successor;
    private final BreakIterator wordIterator;
    private boolean isIgnoringSingleLetters;
    private boolean isIgnoringURLs;
    private final IProgressMonitor monitor;

    public SpellCheckIterator(IDocument document, IRegion region, Locale locale, IProgressMonitor monitor) {
        this(document, region, locale, BreakIterator.getWordInstance(locale), monitor);
    }

    public SpellCheckIterator(IDocument document, IRegion region, Locale locale, BreakIterator breakIterator, IProgressMonitor monitor) {
        String content;
        this.offset = region.getOffset();
        this.wordIterator = breakIterator;
        this.delimiter = TextUtilities.getDefaultLineDelimiter((IDocument)document);
        this.monitor = monitor == null ? new NullProgressMonitor() : monitor;
        try {
            content = document.get(region.getOffset(), region.getLength());
        }
        catch (Exception exception) {
            content = "";
        }
        this.content = content;
        this.wordIterator.setText(content);
        this.predecessor = this.wordIterator.first();
        this.successor = this.wordIterator.next();
        BreakIterator iterator = BreakIterator.getSentenceInstance(locale);
        iterator.setText(content);
        int offset = iterator.current();
        while (offset != -1) {
            this.sentenceBreaks.add(offset);
            offset = iterator.next();
        }
    }

    @Override
    public void setIgnoreSingleLetters(boolean state) {
        this.isIgnoringSingleLetters = state;
    }

    @Override
    public void setIgnoreURLs(boolean state) {
        this.isIgnoringURLs = state;
    }

    @Override
    public final int getBegin() {
        return this.previous + this.offset;
    }

    @Override
    public final int getEnd() {
        return this.next + this.offset - 1;
    }

    @Override
    public final boolean hasNext() {
        return this.successor != -1 && !this.monitor.isCanceled();
    }

    protected final boolean isAlphaNumeric(int begin, int end) {
        boolean letter = false;
        int index = begin;
        while (index < end) {
            char character = this.content.charAt(index);
            if (Character.isLetter(character)) {
                letter = true;
            }
            if (!Character.isLetterOrDigit(character)) {
                return false;
            }
            ++index;
        }
        return letter;
    }

    protected final boolean isToken(String[] tags) {
        return this.isToken(this.lastToken, tags);
    }

    protected final boolean isToken(String token, String[] tags) {
        if (token != null) {
            String[] stringArray = tags;
            int n = tags.length;
            int n2 = 0;
            while (n2 < n) {
                String tag = stringArray[n2];
                if (token.equals(tag)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    protected final boolean isSingleLetter(int begin) {
        if (!Character.isLetter(this.content.charAt(begin))) {
            return false;
        }
        if (begin > 0 && !Character.isWhitespace(this.content.charAt(begin - 1))) {
            return false;
        }
        return begin >= this.content.length() - 1 || Character.isWhitespace(this.content.charAt(begin + 1));
    }

    protected final boolean isUrlToken(int begin) {
        String[] stringArray = DefaultSpellChecker.URL_PREFIXES;
        int n = DefaultSpellChecker.URL_PREFIXES.length;
        int n2 = 0;
        while (n2 < n) {
            String prefix = stringArray[n2];
            if (this.content.startsWith(prefix, begin)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected final boolean isWhitespace(int begin, int end) {
        int index = begin;
        while (index < end) {
            if (!Character.isWhitespace(this.content.charAt(index))) {
                return false;
            }
            ++index;
        }
        return true;
    }

    @Override
    public String next() {
        String token = this.nextToken();
        while (token == null && this.successor != -1) {
            token = this.nextToken();
        }
        this.lastToken = token;
        return token;
    }

    protected final void nextBreak() {
        this.next = this.successor;
        this.predecessor = this.successor;
        this.successor = this.wordIterator.next();
    }

    protected final int nextSentence() {
        return this.sentenceBreaks.getFirst();
    }

    protected String nextToken() {
        String token = null;
        this.previous = this.predecessor;
        this.startsSentence = false;
        this.nextBreak();
        boolean update = false;
        if (this.next - this.previous > 0) {
            if (this.successor != -1 && this.content.charAt(this.previous) == '@') {
                int oldNextValue = this.next;
                this.nextBreak();
                if (Character.isLetter(this.content.charAt(this.previous + 1))) {
                    update = true;
                    token = this.content.substring(this.previous, oldNextValue);
                } else {
                    this.predecessor = this.next;
                }
            } else if (this.successor != -1 && this.content.charAt(this.previous) == '<' && (Character.isLetter(this.content.charAt(this.next)) || this.content.charAt(this.next) == '/')) {
                if (this.content.startsWith("</", this.previous)) {
                    this.nextBreak();
                }
                this.nextBreak();
                if (this.successor != -1 && this.content.charAt(this.next) == '>') {
                    this.nextBreak();
                    if (this.successor != -1) {
                        update = true;
                        token = this.content.substring(this.previous, this.next);
                    }
                }
            } else if (this.successor != -1 && this.content.charAt(this.previous) == '&' && Character.isLetter(this.content.charAt(this.next))) {
                this.nextBreak();
                if (this.successor != -1 && this.content.charAt(this.next) == ';') {
                    this.nextBreak();
                    if (this.isToken(this.content.substring(this.previous, this.next), IHtmlTagConstants.HTML_ENTITY_CODES)) {
                        this.skipTokens(this.previous, 59);
                        update = true;
                    } else {
                        token = this.content.substring(this.previous, this.next);
                    }
                } else {
                    token = this.content.substring(this.previous, this.next);
                }
                update = true;
            } else if (!this.isWhitespace(this.previous, this.next) && this.isAlphaNumeric(this.previous, this.next)) {
                if (this.isUrlToken(this.previous) && this.isIgnoringURLs) {
                    this.skipTokens(this.previous, -1);
                } else if (this.next - this.previous > 1 || this.isSingleLetter(this.previous) && !this.isIgnoringSingleLetters) {
                    token = this.content.substring(this.previous, this.next);
                }
                update = true;
            }
        }
        if (update && this.sentenceBreaks.size() > 0 && this.previous >= this.nextSentence()) {
            while (this.sentenceBreaks.size() > 0 && this.previous >= this.nextSentence()) {
                this.sentenceBreaks.removeFirst();
            }
            this.startsSentence = this.lastToken == null || token != null;
        }
        return token;
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException();
    }

    protected final void skipTokens(int begin, int stop) {
        boolean isStoppingOnWhiteSpace = stop == -1;
        int end = begin;
        while (end < this.content.length()) {
            char ch = this.content.charAt(end);
            if (ch == stop || isStoppingOnWhiteSpace && Character.isWhitespace(ch)) break;
            ++end;
        }
        if (end < this.content.length()) {
            this.predecessor = this.next = end;
            this.successor = this.wordIterator.following(this.next);
        } else {
            this.successor = -1;
        }
    }

    @Override
    public final boolean startsSentence() {
        return this.startsSentence;
    }
}

