/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.ui.explorer;

import com.dbeaver.cloud.internal.CloudUIMessages;
import com.dbeaver.cloud.model.CPCloudConfiguration;
import com.dbeaver.cloud.model.CPCloudUtils;
import com.dbeaver.cloud.model.navigator.DBNCloudDataSourceNode;
import com.dbeaver.cloud.model.navigator.DBNCloudNode;
import com.dbeaver.cloud.model.navigator.DBNCloudsRootNode;
import com.dbeaver.cloud.model.services.CPDatabaseNode;
import com.dbeaver.cloud.registry.CPCloudConfigurationProvider;
import com.dbeaver.cloud.registry.DataSourceOriginCloud;
import com.dbeaver.cloud.ui.explorer.CloudConfigurationDescriptor;
import com.dbeaver.cloud.ui.explorer.CloudConfigurationEditDialog;
import com.dbeaver.cloud.ui.explorer.CloudConfigurationEditPage;
import com.dbeaver.cloud.ui.explorer.CloudExplorerUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IToolTipProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceOrigin;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.UIWidgets;
import org.jkiss.dbeaver.ui.controls.ViewerColumnController;
import org.jkiss.dbeaver.ui.dialogs.connection.ProjectSelectorPanel;
import org.jkiss.dbeaver.ui.navigator.INavigatorFilter;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerObjectDelete;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorLabelProvider;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTree;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTreeFilter;
import org.jkiss.dbeaver.ui.navigator.dialogs.ObjectListDialog;
import org.jkiss.utils.CommonUtils;

public class CloudExplorerPanel
extends DialogPage {
    private final boolean showNavigator;
    private DatabaseNavigatorTree explorerTree;
    private ProjectSelectorPanel projectSelector;
    private ToolItem editConfigItem;
    private ToolItem deleteConfigItem;
    private ToolItem viewConnectionsItem;
    private Button addConnectionsButton;
    private PanelContainer container = lock -> {};
    private Font boldFont;
    private transient Map<String, DBPDataSourceContainer> allInstances;

    public CloudExplorerPanel(boolean showNavigator) {
        super(CloudUIMessages.cloud_explorer_dialog_title);
        this.showNavigator = showNavigator;
    }

    public void setContainer(PanelContainer container) {
        this.container = container;
    }

    public DatabaseNavigatorTree getExplorerTree() {
        return this.explorerTree;
    }

    public void createControl(Composite parent) {
        Composite group = UIUtils.createComposite((Composite)parent, (int)1);
        GridData gd = new GridData(1808);
        gd.heightHint = 400;
        gd.widthHint = 600;
        group.setLayoutData((Object)gd);
        this.createCloudBrowserPanel(group);
        if (this.showNavigator) {
            this.createCloudButtons(group);
        }
        this.refreshClouds(true);
        this.setControl((Control)group);
    }

    private void createCloudBrowserPanel(Composite group) {
        Composite composite = UIUtils.createComposite((Composite)group, (int)2);
        composite.setLayoutData((Object)new GridData(1808));
        this.createCloudBrowser(composite);
        if (this.hasConfigEditAccess()) {
            this.createCloudEditControls(composite);
        }
    }

    private boolean hasConfigEditAccess() {
        return DBWorkbench.getPlatform().getWorkspace().hasRealmPermission("configuration-manager");
    }

    private void createCloudEditControls(Composite composite) {
        ToolBar toolbar = new ToolBar(composite, 0x800200);
        toolbar.setLayoutData((Object)new GridData(2));
        if (this.showNavigator) {
            new ToolItem(toolbar, 2).setControl((Control)new Label((Composite)toolbar, 0));
        }
        UIUtils.createToolItem((ToolBar)toolbar, (String)"New...", (DBPImage)UIIcon.ADD, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CloudConfigurationEditDialog dialog = new CloudConfigurationEditDialog(CloudExplorerPanel.this.getShell(), null);
                dialog.open();
                CloudExplorerPanel.this.refreshClouds(true);
            }
        });
        this.editConfigItem = UIUtils.createToolItem((ToolBar)toolbar, (String)"Edit...", (DBPImage)UIIcon.EDIT, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CloudExplorerPanel.this.editSelectedItem();
            }
        });
        this.deleteConfigItem = UIUtils.createToolItem((ToolBar)toolbar, (String)"Delete", (DBPImage)UIIcon.DELETE, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    CloudExplorerPanel.this.deleteCloudConfiguration();
                }
                catch (DBException ex) {
                    DBWorkbench.getPlatformUI().showError("Delete configurations", "Error deleting cloud configurations", (Throwable)ex);
                }
            }
        });
        UIUtils.createToolBarSeparator((ToolBar)toolbar, (int)256);
        this.viewConnectionsItem = UIUtils.createToolItem((ToolBar)toolbar, (String)"View connections", (DBPImage)UIIcon.DATABASES, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CloudExplorerPanel.this.viewCloudConfigurationConnections();
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private void editSelectedItem() {
        void node;
        Object firstElement = ((StructuredSelection)this.explorerTree.getViewer().getSelection()).getFirstElement();
        if (!(firstElement instanceof DBNCloudNode)) {
            return;
        }
        DBNCloudNode dBNCloudNode = (DBNCloudNode)firstElement;
        CloudConfigurationDescriptor descriptor = new CloudConfigurationDescriptor(node.getCloudProvider(), node.getCloud().getCloudConfiguration());
        CloudConfigurationEditDialog dialog = new CloudConfigurationEditDialog(this.getShell(), descriptor);
        dialog.open();
        this.refreshClouds(true);
    }

    private void deleteCloudConfiguration() throws DBException {
        DBNCloudNode node = (DBNCloudNode)((StructuredSelection)this.explorerTree.getViewer().getSelection()).getFirstElement();
        CPCloudConfiguration configuration = node.getCloud().getCloudConfiguration();
        if (configuration.isDefaultConfiguration()) {
            UIUtils.showMessageBox((Shell)this.getShell(), (String)"Cannot delete configuration", (String)("Cloud configuration '" + configuration.getCloudName() + "' is provided and needed by system. It cannot be deleted."), (int)1);
            return;
        }
        if (!this.confirmDeletion(configuration)) {
            return;
        }
        List descriptors = CloudConfigurationDescriptor.getAllCloudConfigurations().stream().filter(c -> c.getCloudProvider().equals(node.getCloudProvider())).collect(Collectors.toList());
        CloudConfigurationDescriptor configToDelete = descriptors.stream().filter(cd -> Objects.equals(cd.getConfiguration().getCloudId(), node.getCloud().getCloudId())).findAny().orElse(null);
        if (configToDelete == null) {
            return;
        }
        descriptors.remove(configToDelete);
        if (descriptors.isEmpty()) {
            CPCloudConfigurationProvider<?> ccp = CloudConfigurationEditPage.getCloudConfigurationProvider(configToDelete);
            if (ccp != null) {
                try {
                    ccp.saveCloudConfigurations(Collections.emptyList());
                }
                catch (DBException ex) {
                    DBWorkbench.getPlatformUI().showError("Save empty cloud configurations", "Error saving empty cloud secure configurations", (Throwable)ex);
                }
            }
        } else {
            ArrayList<CloudConfigurationDescriptor> configurationsToSave = new ArrayList<CloudConfigurationDescriptor>();
            for (CloudConfigurationDescriptor cfgDesc : descriptors) {
                if (cfgDesc.getCloudProvider() != node.getCloudProvider()) continue;
                configurationsToSave.add(cfgDesc);
            }
            CloudConfigurationEditPage.saveConfigurations(configurationsToSave);
        }
        this.refreshClouds(true);
    }

    private boolean confirmDeletion(@NotNull CPCloudConfiguration<?> configuration) {
        List dsList = CPCloudUtils.getCloudDataSources(configuration);
        if (!dsList.isEmpty()) {
            if (!UIUtils.confirmAction((Shell)this.getShell(), (String)"Cannot delete configuration", (String)("Cloud configuration '" + configuration.getCloudName() + "' is used to connect to  " + dsList.size() + " datasource(s).\nDo you want to view and delete these connections?\n"))) {
                return false;
            }
            return NavigatorHandlerObjectDelete.tryDeleteObjects((IWorkbenchWindow)UIUtils.getActiveWorkbenchWindow(), CloudExplorerUtils.getDataSourceNodes(dsList));
        }
        return UIUtils.confirmAction((Shell)this.getShell(), (String)"Confirm configuration delete", (String)("Are you sure you want to delete cloud configuration '" + configuration.getCloudName() + "'?"));
    }

    private void viewCloudConfigurationConnections() {
        DBPDataSourceContainer dataSource;
        DBNCloudNode node = (DBNCloudNode)((StructuredSelection)this.explorerTree.getViewer().getSelection()).getFirstElement();
        CPCloudConfiguration configuration = node.getCloud().getCloudConfiguration();
        List dsList = CPCloudUtils.getCloudDataSources((CPCloudConfiguration)configuration);
        ObjectListDialog<DBPDataSourceContainer> conListDialog = new ObjectListDialog<DBPDataSourceContainer>(this.getShell(), configuration.getCloudName() + " connections", true, "cloud.connections", (Collection)dsList, null){

            protected IDialogSettings getDialogBoundsSettings() {
                return UIUtils.getDialogSettings((String)"CloudExplorerConnectionList");
            }
        };
        if (conListDialog.open() == 0 && (dataSource = (DBPDataSourceContainer)conListDialog.getSelectedObject()) != null) {
            DBNDatabaseNode dsNode;
            DBPProject project = dataSource.getProject();
            DBNProject projectNode = project.getNavigatorModel().getRoot().getProjectNode(project);
            if (projectNode != null) {
                projectNode.getDatabases().getDataSource(dataSource);
            }
            if ((dsNode = project.getNavigatorModel().getNodeByObject((DBSObject)dataSource)) != null) {
                NavigatorUtils.showNodeInNavigator((DBNDatabaseNode)dsNode);
            }
        }
    }

    private void createCloudBrowser(Composite parent) {
        Composite composite = UIUtils.createComposite((Composite)parent, (int)1);
        composite.setLayoutData((Object)new GridData(1808));
        DatabaseNavigatorTreeFilter navigatorFilter = null;
        if (this.showNavigator) {
            navigatorFilter = new DatabaseNavigatorTreeFilter(){

                public boolean isLeafObject(Object object) {
                    return object instanceof DBNDataSource;
                }

                public boolean filterObjectByPattern(Object object) {
                    return object instanceof DBNCloudDataSourceNode;
                }

                public boolean isConnectionsOnly() {
                    return true;
                }
            };
        }
        this.explorerTree = new DatabaseNavigatorTree(composite, (DBNNode)DBWorkbench.getPlatform().getNavigatorModel().getRoot(), 67586, false, (INavigatorFilter)navigatorFilter, CloudUIMessages.cloud_explorer_dialog_tree_filter_text){

            @NotNull
            protected DatabaseNavigatorLabelProvider createLabelProvider(DatabaseNavigatorTree tree) {
                return new CloudExplorerLabelProvider(tree);
            }
        };
        this.explorerTree.setLayoutData((Object)new GridData(1808));
        final TreeViewer treeViewer = this.explorerTree.getViewer();
        treeViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return !(element instanceof DBNProject);
            }
        });
        this.boldFont = UIUtils.modifyFont((Font)treeViewer.getTree().getFont(), (int)1);
        treeViewer.getTree().addDisposeListener(e -> this.boldFont.dispose());
        treeViewer.getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CloudExplorerPanel.this.editConfigItem != null) {
                    DBNCloudNode node;
                    Object object;
                    StructuredSelection selection = (StructuredSelection)treeViewer.getSelection();
                    boolean enabled = selection.size() == 1 && selection.getFirstElement() instanceof DBNCloudNode;
                    CloudExplorerPanel.this.editConfigItem.setEnabled(enabled);
                    CloudExplorerPanel.this.deleteConfigItem.setEnabled(enabled && (object = selection.getFirstElement()) instanceof DBNCloudNode && !(node = (DBNCloudNode)object).getCloud().getCloudConfiguration().isDefaultConfiguration());
                    CloudExplorerPanel.this.viewConnectionsItem.setEnabled(enabled && selection.getFirstElement() instanceof DBNCloudNode);
                }
            }
        });
        if (this.hasConfigEditAccess()) {
            treeViewer.addDoubleClickListener(event -> this.editSelectedItem());
        }
        NavigatorUtils.addDragAndDropSupport((Viewer)treeViewer, (boolean)true, (boolean)false);
        treeViewer.addSelectionChangedListener(event -> {
            boolean hasDataSourceNodes = false;
            for (Object element : treeViewer.getStructuredSelection()) {
                if (element instanceof DBNCloudDataSourceNode) {
                    hasDataSourceNodes = true;
                    continue;
                }
                hasDataSourceNodes = false;
                break;
            }
            if (this.addConnectionsButton != null) {
                this.addConnectionsButton.setEnabled(hasDataSourceNodes);
            }
        });
        Tree treeControl = treeViewer.getTree();
        treeControl.setHeaderVisible(true);
        treeControl.addPaintListener(e -> {
            if (treeControl.getItemCount() == 0) {
                UIUtils.drawMessageOverControl((Control)treeControl, (PaintEvent)e, (String)CloudUIMessages.cloud_explorer_dialog_message_over_choose_cloud, (int)0);
            }
        });
        this.createColumns(treeViewer);
        UIWidgets.setControlContextMenu((Control)treeControl, manager -> {
            DBNNode selectedNode = NavigatorUtils.getSelectedNode((ISelectionProvider)treeViewer);
            if (selectedNode instanceof DBNCloudDataSourceNode) {
                DBPDataSourceContainer ds = this.getExistingDataSource((DBNCloudDataSourceNode)selectedNode);
                if (ds != null) {
                    manager.add((IAction)new ShowDataSourceAction(ds));
                } else {
                    manager.add((IAction)new AddDataSourceAction((DBNCloudDataSourceNode)selectedNode));
                }
                manager.add((IContributionItem)new Separator());
            }
            UIWidgets.fillDefaultTreeContextMenu((IContributionManager)manager, (Tree)treeControl);
        });
        if (this.showNavigator) {
            UIUtils.createInfoLabel((Composite)composite, (String)CloudUIMessages.cloud_explorer_dialog_tree_dnd_hint);
        }
    }

    private void createCloudButtons(@NotNull Composite parent) {
        Composite buttonsGroup = UIUtils.createComposite((Composite)parent, (int)3);
        buttonsGroup.setLayoutData((Object)new GridData(768));
        this.projectSelector = new ProjectSelectorPanel(buttonsGroup, NavigatorUtils.getSelectedProject(), 1){

            protected void onProjectChange() {
                CloudExplorerPanel.this.allInstances = null;
                CloudExplorerPanel.this.explorerTree.getViewer().refresh();
            }
        };
        UIUtils.createEmptyLabel((Composite)buttonsGroup, (int)1, (int)1).setLayoutData((Object)new GridData(768));
        this.addConnectionsButton = UIUtils.createDialogButton((Composite)buttonsGroup, (String)CloudUIMessages.cloud_explorer_dialog_button_add_to_project, (DBPImage)UIIcon.SQL_NEW_CONNECTION, (String)CloudUIMessages.cloud_explorer_dialog_button_add_to_project_tip, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CloudExplorerPanel.this.addSelectedToProject();
            }
        });
        this.addConnectionsButton.setEnabled(false);
    }

    private void createColumns(TreeViewer viewer) {
        final ILabelProvider mainLabelProvider = (ILabelProvider)viewer.getLabelProvider();
        ViewerColumnController columnController = new ViewerColumnController("projectExplorer", (ColumnViewer)viewer);
        columnController.setForceAutoSize(true);
        columnController.addColumn(CloudUIMessages.cloud_explorer_dialog_button_name, CloudUIMessages.cloud_explorer_dialog_button_name_tip, 16384, true, true, (CellLabelProvider)new CloudExplorerLabelProvider(this, this.explorerTree){

            public String getText(Object element) {
                return mainLabelProvider.getText(element);
            }

            public Image getImage(Object element) {
                return mainLabelProvider.getImage(element);
            }

            public String getToolTipText(Object element) {
                if (mainLabelProvider instanceof IToolTipProvider) {
                    return ((IToolTipProvider)mainLabelProvider).getToolTipText(element);
                }
                return null;
            }
        });
        if (this.showNavigator) {
            columnController.addColumn(CloudUIMessages.cloud_explorer_dialog_button_region, CloudUIMessages.cloud_explorer_dialog_button_region_tip, 16384, true, false, (CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    if (element instanceof DBNCloudDataSourceNode) {
                        return ((DBNCloudDataSourceNode)element).getInstance().getZone().getName();
                    }
                    return null;
                }
            });
        }
        UIUtils.asyncExec(() -> columnController.createColumns(true));
    }

    private void refreshClouds(boolean forceRefresh) {
        DBNCloudsRootNode cloudRootNode;
        DBPProject project = this.getCurrentProject();
        DBNProject projectNode = DBWorkbench.getPlatform().getNavigatorModel().getRoot().getProjectNode(project);
        if (projectNode != null && (cloudRootNode = (DBNCloudsRootNode)projectNode.getExtraNode(DBNCloudsRootNode.class)) != null) {
            if (forceRefresh) {
                cloudRootNode.refreshCloudList();
            }
            this.explorerTree.setInput((DBNNode)cloudRootNode);
            this.explorerTree.getViewer().getTree().notifyListeners(13, new Event());
            try {
                DBNCloudNode[] clouds = cloudRootNode.getChildren((DBRProgressMonitor)new VoidProgressMonitor());
                if (clouds != null && clouds.length == 1) {
                    this.explorerTree.getViewer().expandToLevel(2);
                }
            }
            catch (DBException e) {
                DBWorkbench.getPlatformUI().showError("Refresh configurations", "Error reading cloud nodes", (Throwable)e);
            }
        }
    }

    private DBPProject getCurrentProject() {
        return this.projectSelector != null ? this.projectSelector.getSelectedProject() : NavigatorUtils.getSelectedProject();
    }

    private void addSelectedToProject() {
        ArrayList<DBNCloudDataSourceNode> dsNodes = new ArrayList<DBNCloudDataSourceNode>();
        for (Object element : this.explorerTree.getViewer().getStructuredSelection()) {
            if (!(element instanceof DBNCloudDataSourceNode)) continue;
            dsNodes.add((DBNCloudDataSourceNode)element);
        }
        if (!dsNodes.isEmpty()) {
            this.addNodesToProject(dsNodes);
        }
    }

    private List<DBPDataSourceContainer> addNodesToProject(List<DBNCloudDataSourceNode> dsNodes) {
        if (!dsNodes.isEmpty()) {
            try {
                List<DBNDataSource> nodes;
                this.allInstances = null;
                List dsList = CPCloudUtils.createDataSourcesFromCloudNodes((DBPProject)this.getCurrentProject(), null, dsNodes);
                if (!dsList.isEmpty() && !(nodes = CloudExplorerUtils.getDataSourceNodes(dsList)).isEmpty()) {
                    DBNDataSource dsNode = nodes.get(0);
                    this.container.lockPanel(true);
                    try {
                        NavigatorUtils.showNodeInNavigator((DBNDatabaseNode)dsNode);
                    }
                    finally {
                        this.container.lockPanel(false);
                    }
                }
                this.explorerTree.getViewer().refresh();
            }
            catch (DBException e) {
                DBWorkbench.getPlatformUI().showError("Error adding connections", "Error while creating connections from cloud explorer", (Throwable)e);
            }
        }
        return null;
    }

    private DBPDataSourceContainer getExistingDataSource(DBNCloudDataSourceNode element) {
        CPDatabaseNode instance = element.getInstance();
        String instanceId = instance.getCloudResourceId();
        if (!CommonUtils.isEmpty((String)instanceId)) {
            return this.getCreatedInstances().get(instanceId);
        }
        return null;
    }

    private Map<String, DBPDataSourceContainer> getCreatedInstances() {
        if (this.allInstances == null) {
            this.allInstances = new HashMap<String, DBPDataSourceContainer>();
            DBPProject project = this.getCurrentProject();
            if (project != null) {
                for (DBPDataSourceContainer ds : project.getDataSourceRegistry().getDataSources()) {
                    DBPDataSourceOrigin origin;
                    if (ds.isHidden() || !((origin = ds.getOrigin()) instanceof DataSourceOriginCloud)) continue;
                    String resourceId = ((DataSourceOriginCloud)origin).getResourceId();
                    this.allInstances.put(resourceId, ds);
                }
            }
        }
        return this.allInstances;
    }

    private class AddDataSourceAction
    extends Action {
        private final DBNCloudDataSourceNode node;

        AddDataSourceAction(DBNCloudDataSourceNode node) {
            super("Add '" + node.getNodeDisplayName() + "' to project");
            this.node = node;
        }

        public void run() {
            CloudExplorerPanel.this.addNodesToProject(Collections.singletonList(this.node));
        }
    }

    private class CloudExplorerLabelProvider
    extends DatabaseNavigatorLabelProvider {
        CloudExplorerLabelProvider(DatabaseNavigatorTree tree) {
            super(tree);
        }

        public Font getFont(Object element) {
            DBNCloudNode cn;
            if (element instanceof DBNCloudNode && (cn = (DBNCloudNode)element).getCloud().getCloudConfiguration().isDefaultConfiguration()) {
                return CloudExplorerPanel.this.boldFont;
            }
            return super.getFont(element);
        }

        public Color getForeground(Object element) {
            DBNCloudDataSourceNode dsn;
            if (element instanceof DBNCloudDataSourceNode && CloudExplorerPanel.this.getExistingDataSource(dsn = (DBNCloudDataSourceNode)element) != null) {
                return CloudExplorerPanel.this.explorerTree.getViewer().getControl().getDisplay().getSystemColor(18);
            }
            return super.getForeground(element);
        }
    }

    static interface PanelContainer {
        public void lockPanel(boolean var1);
    }

    private static class ShowDataSourceAction
    extends Action {
        private final DBPDataSourceContainer dataSource;

        ShowDataSourceAction(DBPDataSourceContainer dataSource) {
            super("Show in database navigator");
            this.dataSource = dataSource;
        }

        public void run() {
            DBNDatabaseNode dsNode = DBNUtils.getNodeByObject((DBSObject)this.dataSource);
            if (dsNode == null) {
                return;
            }
            NavigatorUtils.showNodeInNavigator((DBNDatabaseNode)dsNode);
            super.run();
        }
    }
}

