/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.ui.explorer;

import com.dbeaver.cloud.internal.CloudUIMessages;
import com.dbeaver.cloud.model.CPCloud;
import com.dbeaver.cloud.model.CPCloudConfiguration;
import com.dbeaver.cloud.model.CPCloudSession;
import com.dbeaver.cloud.model.CPCloudSessionManager;
import com.dbeaver.cloud.model.CPCloudUtils;
import com.dbeaver.cloud.registry.CPCloudConfigurationProvider;
import com.dbeaver.cloud.registry.CloudConfigurationEditorDescriptor;
import com.dbeaver.cloud.registry.CloudProviderDescriptor;
import com.dbeaver.cloud.registry.CloudProviderRegistry;
import com.dbeaver.cloud.registry.CloudUIRegistry;
import com.dbeaver.cloud.statistic.CloudFeature;
import com.dbeaver.cloud.ui.explorer.CloudConfigurationDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.auth.SMAuthSpace;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

public class CloudConfigurationEditPage
extends DialogPage {
    private static final String DATA_CLOUD_PROVIDER = "cloudProvider";
    private static final String DATA_CLOUD_CONFIGURATION = "cloudConfiguration";
    private List<CloudConfigurationDescriptor> allConfigurations;
    private CTabFolder configFolder;
    private Text configurationIdText;
    private Text configurationNameText;
    private CloudConfigurationDescriptor currentCloudConfig;
    private Runnable propChangeListener;
    private boolean createConfiguration = true;

    public CloudConfigurationEditPage() {
        try {
            this.allConfigurations = CloudConfigurationDescriptor.getAllCloudConfigurations();
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Configuration error", "Error loading cloud configurations", (Throwable)e);
            this.allConfigurations = new ArrayList<CloudConfigurationDescriptor>();
        }
    }

    public CloudConfigurationDescriptor getCurrentCloudConfig() {
        return this.currentCloudConfig;
    }

    public void setConfiguration(CloudConfigurationDescriptor currentCloudConfig) {
        this.currentCloudConfig = currentCloudConfig;
        this.createConfiguration = currentCloudConfig == null;
    }

    public void setPropChangeListener(Runnable propChangeListener) {
        this.propChangeListener = propChangeListener;
    }

    public void createControl(Composite parent) {
        this.createCloudEditGroup(parent);
    }

    private void createCloudEditGroup(Composite parent) {
        Composite composite = UIUtils.createComposite((Composite)parent, (int)2);
        GridData gd = new GridData(1808);
        gd.minimumWidth = 500;
        composite.setLayoutData((Object)gd);
        this.configurationNameText = UIUtils.createLabelText((Composite)composite, (String)CloudUIMessages.cloud_conf_edit_page_configuration_name_text, null, (int)2048);
        this.configurationNameText.addModifyListener(e -> {
            if (this.propChangeListener != null) {
                this.propChangeListener.run();
            }
        });
        this.configurationIdText = UIUtils.createLabelText((Composite)composite, (String)CloudUIMessages.cloud_conf_edit_page_configuration_id_text, null, (int)2048);
        this.configurationIdText.addModifyListener(e -> {
            if (this.propChangeListener != null) {
                this.propChangeListener.run();
            }
        });
        this.configurationIdText.setToolTipText(CloudUIMessages.cloud_conf_edit_page_configuration_id_description);
        this.configFolder = new CTabFolder(composite, 2176);
        this.configFolder.setLayout((Layout)new GridLayout());
        this.configFolder.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 4).grab(true, true).span(2, 1).create());
        this.configFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    CloudConfigurationEditPage.this.currentCloudConfig = this.getOrCreateCloudConfiguration(CloudConfigurationEditPage.this.configFolder.getSelection());
                    CloudConfigurationEditPage.this.showCloudConfiguration();
                    if (CloudConfigurationEditPage.this.propChangeListener != null) {
                        CloudConfigurationEditPage.this.propChangeListener.run();
                    }
                }
                catch (DBException ex) {
                    DBWorkbench.getPlatformUI().showError("Configuration create error", "Error creating cloud configurations", (Throwable)ex);
                }
            }

            @NotNull
            private CloudConfigurationDescriptor getOrCreateCloudConfiguration(@NotNull CTabItem item) throws DBException {
                CloudConfigurationDescriptor cloudConfiguration = (CloudConfigurationDescriptor)item.getData(CloudConfigurationEditPage.DATA_CLOUD_CONFIGURATION);
                if (cloudConfiguration == null) {
                    CloudProviderDescriptor cloudProvider = (CloudProviderDescriptor)item.getData(CloudConfigurationEditPage.DATA_CLOUD_PROVIDER);
                    CPCloudConfigurationProvider cloudConfigProvider = CloudProviderRegistry.getInstance().getConfigurationProvider(cloudProvider.getId());
                    cloudConfiguration = CloudConfigurationEditPage.this.createCloudConfiguration(cloudProvider, cloudConfigProvider);
                    item.setData(CloudConfigurationEditPage.DATA_CLOUD_CONFIGURATION, (Object)cloudConfiguration);
                }
                return cloudConfiguration;
            }
        });
        for (CloudProviderDescriptor provider : CloudProviderRegistry.getInstance().getCloudProviders()) {
            if (this.currentCloudConfig != null && this.currentCloudConfig.getCloudProvider() != provider) continue;
            CTabItem item = new CTabItem(this.configFolder, 0);
            Composite editorPlaceholder = new Composite((Composite)this.configFolder, 0);
            editorPlaceholder.setLayoutData((Object)new GridData(1808));
            editorPlaceholder.setLayout((Layout)new FillLayout());
            item.setControl((Control)editorPlaceholder);
            item.setData(DATA_CLOUD_PROVIDER, (Object)provider);
            item.setText(provider.getDisplayName());
            item.setToolTipText(provider.getDescription());
            item.setImage(DBeaverIcons.getImage((DBPImage)provider.getIcon()));
            if (this.currentCloudConfig != null && this.currentCloudConfig.getCloudProvider() == provider) {
                item.setData(DATA_CLOUD_CONFIGURATION, (Object)this.currentCloudConfig);
            }
            if (this.currentCloudConfig == null || this.currentCloudConfig.getCloudProvider() != provider) continue;
            this.configFolder.setSelection(item);
        }
        if (this.configFolder.getSelection() == null) {
            this.configFolder.setSelection(0);
        }
        this.resetToDefaults();
        this.setControl((Control)composite);
        this.configFolder.setFocus();
    }

    void resetToDefaults() {
        this.showCloudConfiguration();
        if (this.propChangeListener != null) {
            this.propChangeListener.run();
        }
    }

    private CloudConfigurationDescriptor createCloudConfiguration(CloudProviderDescriptor cloudProvider, CPCloudConfigurationProvider<?> cfgProvider) throws DBException {
        CPCloudConfiguration cloudConfiguration;
        try {
            cloudConfiguration = (CPCloudConfiguration)cfgProvider.getCloudConfigurationClass().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Can not create cloud configuration", e);
        }
        CloudConfigurationDescriptor cfg = new CloudConfigurationDescriptor(cloudProvider, cloudConfiguration);
        cfg.getConfiguration().setCloudId(CPCloudUtils.generateCloudId((CloudProviderDescriptor)cloudProvider));
        cfg.getConfiguration().setCloudName(this.generateCloudName(cfg));
        return cfg;
    }

    @NotNull
    public String generateCloudName(CloudConfigurationDescriptor cfg) {
        return this.generateCloudName(cfg.getCloudProvider());
    }

    @NotNull
    public String generateCloudName(CloudProviderDescriptor cfg) {
        int i = 0;
        while (true) {
            String name = cfg.getLabel() + " configuration";
            if (i > 0) {
                name = name + " (" + i + ")";
            }
            for (CloudConfigurationDescriptor ccd : this.allConfigurations) {
                if (!name.equals(ccd.getConfiguration().getCloudName())) continue;
                name = null;
                break;
            }
            if (name != null) {
                return name;
            }
            ++i;
        }
    }

    private void showCloudConfiguration() {
        if (this.currentCloudConfig == null) {
            CloudProviderDescriptor cloudProvider = CloudConfigurationEditPage.getActiveCloudProvider();
            CPCloudConfigurationProvider<?> cfgProvider = CloudConfigurationEditPage.getCloudConfigurationProvider(null);
            if (cloudProvider != null && cfgProvider != null) {
                try {
                    this.currentCloudConfig = this.createCloudConfiguration(cloudProvider, cfgProvider);
                }
                catch (DBException e) {
                    DBWorkbench.getPlatformUI().showError("Configuration error", "Error loading cloud configurations", (Throwable)e);
                }
            }
        }
        if (this.currentCloudConfig == null) {
            return;
        }
        this.configurationNameText.setText(CommonUtils.notEmpty((String)this.currentCloudConfig.getConfiguration().getCloudName()));
        this.configurationIdText.setText(CommonUtils.notEmpty((String)this.currentCloudConfig.getConfiguration().getCloudId()));
        this.configurationIdText.setEditable(!this.allConfigurations.contains(this.currentCloudConfig));
        CTabItem tabItem = this.configFolder.getSelection();
        Composite editorPlaceholder = (Composite)tabItem.getControl();
        if (editorPlaceholder.getChildren().length > 0) {
            return;
        }
        CloudConfigurationEditorDescriptor cloudEditorDescriptor = CloudUIRegistry.getInstance().getConfigurationEditor(this.currentCloudConfig.getCloudProvider());
        if (cloudEditorDescriptor == null) {
            DBWorkbench.getPlatformUI().showError("No cloud configuration editor", "No configuration editor for cloud '" + this.currentCloudConfig.getCloudProvider().getId() + "'");
            return;
        }
        try {
            IObjectPropertyConfigurator<Object, CPCloudConfiguration> editorInstance = cloudEditorDescriptor.createInstance();
            tabItem.setData("editor", editorInstance);
            editorInstance.createControl(editorPlaceholder, (Object)this.currentCloudConfig, this.propChangeListener);
            editorInstance.loadSettings(this.currentCloudConfig.getConfiguration());
            editorPlaceholder.layout(true, true);
        }
        catch (Exception e) {
            DBWorkbench.getPlatformUI().showError("Editor error", "Error while creating configuration editor", (Throwable)e);
        }
    }

    private void saveConfigurationFromUI() {
        CTabItem tabItem;
        IObjectPropertyConfigurator editorInstance;
        if (this.currentCloudConfig != null && (editorInstance = (IObjectPropertyConfigurator)(tabItem = this.configFolder.getSelection()).getData("editor")) != null && editorInstance.isComplete()) {
            CPCloudConfiguration<?> cfg = this.currentCloudConfig.getConfiguration();
            cfg.setCloudId(this.configurationIdText.getText());
            cfg.setCloudName(this.configurationNameText.getText());
            editorInstance.saveSettings(cfg);
        }
    }

    static CPCloudConfigurationProvider<?> getCloudConfigurationProvider(CloudConfigurationDescriptor config) {
        CPCloudConfigurationProvider ccProvider;
        if (config == null) {
            CloudProviderDescriptor cloudProvider = CloudConfigurationEditPage.getActiveCloudProvider();
            if (cloudProvider == null) {
                return null;
            }
            ccProvider = CloudProviderRegistry.getInstance().getConfigurationProvider(cloudProvider.getId());
            if (ccProvider == null) {
                DBWorkbench.getPlatformUI().showError("Invalid configuration provider", "Error creating cloud configuration provider");
                return null;
            }
        } else {
            ccProvider = CloudProviderRegistry.getInstance().getConfigurationProvider(config.getCloudProvider().getId());
        }
        return ccProvider;
    }

    private static CloudProviderDescriptor getActiveCloudProvider() {
        List cloudProviders = CloudProviderRegistry.getInstance().getCloudProviders();
        if (cloudProviders.isEmpty()) {
            DBWorkbench.getPlatformUI().showError("No cloud configuration provider", "No cloud configuration providers found");
            return null;
        }
        return (CloudProviderDescriptor)cloudProviders.get(0);
    }

    public boolean saveConfigurations() {
        this.saveConfigurationFromUI();
        if (this.createConfiguration) {
            this.allConfigurations.add(this.currentCloudConfig);
            this.createConfiguration = false;
        }
        ArrayList<CloudConfigurationDescriptor> configurationsToSave = new ArrayList<CloudConfigurationDescriptor>();
        for (CloudConfigurationDescriptor cfgDesc : this.allConfigurations) {
            if (cfgDesc.getCloudProvider() != this.currentCloudConfig.getCloudProvider()) continue;
            configurationsToSave.add(cfgDesc);
        }
        CloudFeature.CLOUD_CONFIGURATION_CREATE.use(Map.of("origin", "cloud." + this.currentCloudConfig.getCloudProvider().getId()));
        return CloudConfigurationEditPage.saveConfigurations(configurationsToSave);
    }

    public static boolean saveConfigurations(@NotNull Collection<CloudConfigurationDescriptor> configurations) {
        LinkedHashMap<CPCloudConfigurationProvider, List> configMap = new LinkedHashMap<CPCloudConfigurationProvider, List>();
        for (CloudConfigurationDescriptor ccd : configurations) {
            CPCloudConfigurationProvider<?> ccp = CloudConfigurationEditPage.getCloudConfigurationProvider(ccd);
            if (ccp == null) continue;
            configMap.computeIfAbsent(ccp, c -> new ArrayList()).add(ccd.getConfiguration());
        }
        for (CPCloudConfigurationProvider ccpc : configMap.keySet()) {
            List list = (List)configMap.get(ccpc);
            try {
                ccpc.saveCloudConfigurations((Collection)list);
            }
            catch (DBException e) {
                DBWorkbench.getPlatformUI().showError("Save cloud configuration", "Error saving cloud secure configuration", (Throwable)e);
                return false;
            }
            for (CPCloudConfiguration cc : list) {
                if (cc.getCloudId() == null) continue;
                try {
                    CPCloudSession activeSession;
                    CPCloud cloud = CPCloudUtils.getCloud(null, (String)cc.getCloudId(), null);
                    if (!(cloud instanceof CPCloudSessionManager) || (activeSession = ((CPCloudSessionManager)cloud).getActiveSession()) == null) continue;
                    activeSession.closeSession();
                    DBWorkbench.getPlatform().getWorkspace().getAuthContext().getSpaceSession((DBRProgressMonitor)new VoidProgressMonitor(), (SMAuthSpace)cloud, true);
                }
                catch (DBException e) {
                    DBWorkbench.getPlatformUI().showError("Session refresh", "Error reopening cloud session", (Throwable)e);
                }
            }
        }
        return true;
    }

    public boolean isComplete() {
        CTabItem tabItem = this.configFolder.getSelection();
        IObjectPropertyConfigurator editorInstance = (IObjectPropertyConfigurator)tabItem.getData("editor");
        return editorInstance != null && editorInstance.isComplete();
    }
}

