/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.ui.connection;

import com.dbeaver.cloud.model.CPCloud;
import com.dbeaver.cloud.registry.DataSourceOriginCloud;
import com.dbeaver.cloud.ui.explorer.CloudConfigurationDescriptor;
import com.dbeaver.cloud.ui.explorer.CloudConfigurationEditDialog;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIUtils;

public class CloudAuthModelConfigurator
implements IObjectPropertyConfigurator<Object, DBPDataSourceContainer> {
    private static final Log log = Log.getLog(CloudAuthModelConfigurator.class);
    private Link cloudInfoLabel;
    private DataSourceOriginCloud<?, ?> cloudOrigin;

    public void loadSettings(@NotNull DBPDataSourceContainer dataSource) {
        boolean isCloudProvided;
        boolean bl = isCloudProvided = !"local".equals(dataSource.getOrigin().getType());
        if (this.cloudInfoLabel != null) {
            this.cloudInfoLabel.setVisible(isCloudProvided);
            Object object = this.cloudInfoLabel.getLayoutData();
            if (object instanceof GridData) {
                GridData gd = (GridData)object;
                boolean bl2 = gd.exclude = !isCloudProvided;
            }
            if (isCloudProvided) {
                this.cloudOrigin = (DataSourceOriginCloud)dataSource.getOrigin();
                try {
                    CPCloud cloud = this.cloudOrigin.getCloud();
                    this.cloudInfoLabel.setText("Authentication parameters are provided by <a>" + cloud.getName() + "</a> cloud");
                }
                catch (DBException e) {
                    log.error((Object)e);
                }
            }
            this.cloudInfoLabel.getShell().layout(true, true);
        } else {
            this.cloudOrigin = null;
        }
    }

    public void saveSettings(@NotNull DBPDataSourceContainer dataSource) {
    }

    public void resetSettings(@NotNull DBPDataSourceContainer dataSourceContainer) {
    }

    public boolean isComplete() {
        return true;
    }

    public void createControl(@NotNull Composite authPanel, Object object, @NotNull Runnable propertyChangeListener) {
        this.cloudInfoLabel = UIUtils.createLink((Composite)authPanel, (String)"This is cloud provided config", (SelectionListener)SelectionListener.widgetSelectedAdapter(selectionEvent -> this.openCloudConfiguration(authPanel.getShell())));
        GridData gd = new GridData(768);
        Layout layout = authPanel.getLayout();
        if (layout instanceof GridLayout) {
            GridLayout gl = (GridLayout)layout;
            gd.horizontalSpan = gl.numColumns;
        }
        this.cloudInfoLabel.setLayoutData((Object)gd);
    }

    private void openCloudConfiguration(Shell shell) {
        try {
            CPCloud cloud = this.cloudOrigin.getCloud();
            CloudConfigurationDescriptor ccd = new CloudConfigurationDescriptor(this.cloudOrigin.getCloudProvider(), cloud.getCloudConfiguration());
            CloudConfigurationEditDialog dialog = new CloudConfigurationEditDialog(shell, ccd);
            dialog.open();
        }
        catch (Throwable e) {
            DBWorkbench.getPlatformUI().showError("Cloud config error", "Cannot open cloud configuration", e);
        }
    }
}

