/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.registry;

import com.dbeaver.cloud.fs.DBFCloudConfigurationListener;
import com.dbeaver.cloud.registry.CPCloudConfigurationListener;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.utils.CommonUtils;

public class CPCloudConfigurationRegistry {
    private static CPCloudConfigurationRegistry instance = null;
    private final List<CPCloudConfigurationListener> listeners = new ArrayList<CPCloudConfigurationListener>();

    private CPCloudConfigurationRegistry() {
        this.addConfigurationChangeListener(new DBFCloudConfigurationListener(), false);
    }

    public static synchronized CPCloudConfigurationRegistry getInstance() {
        if (instance == null) {
            instance = new CPCloudConfigurationRegistry();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConfigurationChangeListener(CPCloudConfigurationListener listener, boolean first) {
        List<CPCloudConfigurationListener> list = this.listeners;
        synchronized (list) {
            if (first) {
                this.listeners.add(0, listener);
            } else {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConfigurationChangeListener(CPCloudConfigurationListener listener) {
        List<CPCloudConfigurationListener> list = this.listeners;
        synchronized (list) {
            if (!CommonUtils.isEmpty(this.listeners)) {
                this.listeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireCloudConfigurationChange() {
        ArrayList<CPCloudConfigurationListener> listenersCopy = null;
        List<CPCloudConfigurationListener> list = this.listeners;
        synchronized (list) {
            if (!CommonUtils.isEmpty(this.listeners)) {
                listenersCopy = new ArrayList<CPCloudConfigurationListener>(this.listeners);
            }
        }
        if (listenersCopy != null) {
            for (CPCloudConfigurationListener listener : listenersCopy) {
                listener.handleCloudConfigurationChange();
            }
        }
    }
}

