/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.registry;

import com.dbeaver.cloud.impl.AbstractCloudConfiguration;
import com.dbeaver.cloud.model.CPCloudConfiguration;
import com.dbeaver.cloud.model.CPCloudServiceAccount;
import com.dbeaver.cloud.model.CPCloudUtils;
import com.dbeaver.cloud.registry.CPCloudConfigurationProvider;
import com.dbeaver.cloud.registry.CPCloudConfigurationRegistry;
import com.dbeaver.cloud.registry.CloudConfigSerializationStrategy;
import com.dbeaver.model.DBSecureConfigurationController;
import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.Strictness;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBConfigurationController;
import org.jkiss.dbeaver.model.DBPExternalConfiguration;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.net.DBWNetworkProfile;
import org.jkiss.dbeaver.model.secret.DBSSecretController;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public abstract class BaseCloudConfigurationProvider<CONFIG extends CPCloudConfiguration<?>>
implements CPCloudConfigurationProvider<CONFIG> {
    protected static final Gson gson = new GsonBuilder().setPrettyPrinting().setStrictness(Strictness.LENIENT).addSerializationExclusionStrategy((ExclusionStrategy)new CloudConfigSerializationStrategy()).create();
    private static final Log log = Log.getLog(BaseCloudConfigurationProvider.class);
    private static final String CLOUD_CONFIG_FOLDER = ".cloud-data";

    protected abstract String getCloudTypeId();

    @NotNull
    protected Path getCloudConfigFolder(boolean create) {
        Path cloudsFolder = DBWorkbench.getPlatform().getWorkspace().getMetadataFolder().resolve(CLOUD_CONFIG_FOLDER);
        if (create && !Files.exists(cloudsFolder, new LinkOption[0])) {
            try {
                Files.createDirectories(cloudsFolder, new FileAttribute[0]);
            }
            catch (IOException e) {
                log.error((Object)("Cannot create directory '" + String.valueOf(cloudsFolder.toAbsolutePath()) + "'"), (Throwable)e);
            }
        }
        return cloudsFolder;
    }

    @NotNull
    protected Path getCloudConfigFile(boolean create) {
        return this.getCloudConfigFolder(create).resolve(this.getCloudTypeId() + "-clouds.json");
    }

    @NotNull
    public String getCloudConfigurationFileName() {
        return "clouds/" + this.getCloudTypeId() + "-clouds.json";
    }

    @NotNull
    protected String getCloudServiceAccountsFileName() {
        return "clouds/" + this.getCloudTypeId() + "-clouds-service-accounts.json";
    }

    @Override
    @NotNull
    public List<CONFIG> loadCloudConfigurations() throws DBException {
        try {
            Path cloudConfigFile;
            String configContent = DBWorkbench.getPlatform().getConfigurationController().loadConfigurationFile(this.getCloudConfigurationFileName());
            if (CommonUtils.isEmpty((String)configContent) && Files.exists(cloudConfigFile = this.getCloudConfigFile(false), new LinkOption[0])) {
                configContent = Files.readString(cloudConfigFile, StandardCharsets.UTF_8);
            }
            if (!CommonUtils.isEmpty((String)configContent)) {
                CPCloudConfiguration[] configs;
                Class<?> arrClass = Array.newInstance(this.getCloudConfigurationClass(), 0).getClass();
                CPCloudConfiguration[] cPCloudConfigurationArray = configs = (CPCloudConfiguration[])gson.fromJson(configContent, arrClass);
                int n = configs.length;
                int n2 = 0;
                while (n2 < n) {
                    CPCloudConfiguration cfg = cPCloudConfigurationArray[n2];
                    if (cfg instanceof AbstractCloudConfiguration) {
                        AbstractCloudConfiguration acc = (AbstractCloudConfiguration)cfg;
                        acc.processPostLoadActions();
                    }
                    this.loadSecureProperties(cfg);
                    ++n2;
                }
                ArrayList result = new ArrayList();
                Collections.addAll(result, configs);
                HashSet<String> configIds = new HashSet<String>();
                Iterator iter = result.iterator();
                while (iter.hasNext()) {
                    CPCloudConfiguration cfg = (CPCloudConfiguration)iter.next();
                    if (configIds.contains(cfg.getCloudId())) {
                        iter.remove();
                        continue;
                    }
                    configIds.add(cfg.getCloudId());
                }
                return result;
            }
        }
        catch (Exception e) {
            throw new DBException("Error loading cloud configuration", (Throwable)e);
        }
        return Collections.emptyList();
    }

    @Override
    public CONFIG importExternalCloudConfiguration(DBPExternalConfiguration externalConfiguration) throws DBException {
        String jsonString;
        Gson gson = CPCloudUtils.createSecureGson(false);
        CPCloudConfiguration config = (CPCloudConfiguration)gson.fromJson(jsonString = gson.toJson((Object)externalConfiguration.getProperties()), this.getCloudConfigurationClass());
        if (config instanceof AbstractCloudConfiguration) {
            ((AbstractCloudConfiguration)config).processPostLoadActions();
        }
        ArrayList<CONFIG> allConfigs = new ArrayList<CONFIG>(this.loadCloudConfigurations());
        int i = 0;
        while (i < allConfigs.size()) {
            CPCloudConfiguration oldCfg = (CPCloudConfiguration)allConfigs.get(i);
            if (Objects.equals(oldCfg.getCloudId(), config.getCloudId())) {
                allConfigs.set(i, config);
                config = null;
                break;
            }
            ++i;
        }
        if (config != null) {
            allConfigs.add(config);
        }
        try {
            this.saveCloudConfigurations(allConfigs);
        }
        catch (DBException e) {
            log.error((Object)("Error saving cloud '" + this.getCloudTypeId() + "' secure configuration"), (Throwable)e);
        }
        return (CONFIG)config;
    }

    protected boolean loadSecureProperties(CONFIG cfg) throws DBException {
        List<DBWNetworkProfile> tunnelProfiles;
        if (cfg instanceof AbstractCloudConfiguration && !CommonUtils.isEmpty(tunnelProfiles = ((AbstractCloudConfiguration)cfg).getTunnelProfiles())) {
            for (DBWNetworkProfile profile : tunnelProfiles) {
                profile.resolveSecrets(DBSSecretController.getGlobalSecretController());
            }
            return true;
        }
        return false;
    }

    protected boolean saveSecureProperties(CONFIG cfg) throws DBException {
        List<DBWNetworkProfile> tunnelProfiles;
        if (cfg instanceof AbstractCloudConfiguration && !CommonUtils.isEmpty(tunnelProfiles = ((AbstractCloudConfiguration)cfg).getTunnelProfiles())) {
            for (DBWNetworkProfile profile : tunnelProfiles) {
                profile.persistSecrets(DBSSecretController.getGlobalSecretController());
            }
            return true;
        }
        return false;
    }

    @Override
    public void saveCloudConfigurations(@NotNull Collection<CONFIG> configurations) throws DBException {
        boolean securePropsSaved = false;
        for (CPCloudConfiguration cfg : configurations) {
            if (!this.saveSecureProperties(cfg)) continue;
            securePropsSaved = true;
        }
        Gson saveGson = securePropsSaved ? CPCloudUtils.createSecureGson(false) : gson;
        StringWriter buf = new StringWriter();
        try {
            JsonWriter jsonWriter = saveGson.newJsonWriter((Writer)buf);
            saveGson.toJson(configurations, configurations.getClass(), jsonWriter);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        DBWorkbench.getPlatform().getConfigurationController().saveConfigurationFile(this.getCloudConfigurationFileName(), buf.toString());
        CPCloudConfigurationRegistry.getInstance().fireCloudConfigurationChange();
    }

    @Override
    public Map<String, Object> serializeCloudConfiguration(CONFIG configuration) {
        Gson gson = CPCloudUtils.createSecureGson(false);
        String jsonString = gson.toJson(configuration, configuration.getClass());
        return JSONUtils.parseMap((Gson)gson, (Reader)new StringReader(jsonString));
    }

    @Override
    @NotNull
    public List<? extends CPCloudServiceAccount> loadCloudServiceAccounts() throws DBException {
        DBSecureConfigurationController scc;
        String configContent;
        DBConfigurationController cfgController = DBWorkbench.getPlatform().getConfigurationController();
        if (cfgController instanceof DBSecureConfigurationController && !CommonUtils.isEmpty((String)(configContent = (scc = (DBSecureConfigurationController)cfgController).loadSecureConfigurationFile(this.getCloudServiceAccountsFileName())))) {
            try {
                Class<?> arrClass = Array.newInstance(this.getCloudServiceAccountClass(), 0).getClass();
                CPCloudServiceAccount[] configs = (CPCloudServiceAccount[])gson.fromJson(configContent, arrClass);
                return List.of(configs);
            }
            catch (Exception e) {
                throw new DBException("Error deserializing service accounts", (Throwable)e);
            }
        }
        return Collections.emptyList();
    }

    @Override
    public void saveCloudServiceAccounts(@NotNull List<? extends CPCloudServiceAccount> serviceAccounts) throws DBException {
        StringWriter buf = new StringWriter();
        try {
            JsonWriter jsonWriter = gson.newJsonWriter((Writer)buf);
            Class<?> arrClass = Array.newInstance(this.getCloudServiceAccountClass(), 0).getClass();
            gson.toJson((Object)serviceAccounts.toArray(), arrClass, jsonWriter);
        }
        catch (Exception e) {
            throw new DBException("Error serializing service accounts", (Throwable)e);
        }
        DBConfigurationController cfgController = DBWorkbench.getPlatform().getConfigurationController();
        if (cfgController instanceof DBSecureConfigurationController) {
            DBSecureConfigurationController scc = (DBSecureConfigurationController)cfgController;
            scc.saveSecureConfigurationFile(this.getCloudServiceAccountsFileName(), buf.toString());
        }
    }

    @NotNull
    protected String getSecretId(CONFIG cfg, String key) {
        return this.getCloudTypeId() + "/credentials/" + cfg.getCloudId() + "/" + key;
    }

    @NotNull
    protected DBSSecretController getSecretController() throws DBException {
        return DBSSecretController.getGlobalSecretController();
    }
}

