/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.model.navigator;

import com.dbeaver.cloud.model.CPCloudExplorer;
import com.dbeaver.cloud.model.navigator.DBNCloudClusterNode;
import com.dbeaver.cloud.model.navigator.DBNCloudDataSourceNode;
import com.dbeaver.cloud.model.navigator.DBNCloudDatabaseNode;
import com.dbeaver.cloud.model.navigator.DBNCloudFolderNode;
import com.dbeaver.cloud.model.navigator.DBNCloudItemNode;
import com.dbeaver.cloud.model.services.CPDatabaseCluster;
import com.dbeaver.cloud.model.services.CPDatabaseFolder;
import com.dbeaver.cloud.model.services.CPDatabaseInstance;
import com.dbeaver.cloud.model.services.CPDatabaseNode;
import com.dbeaver.cloud.registry.CloudDatabaseServiceDescriptor;
import java.util.ArrayList;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.navigator.DBNLazyNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class DBNCloudServiceNode
extends DBNCloudItemNode
implements DBNLazyNode {
    private static final Log log = Log.getLog(DBNCloudServiceNode.class);
    private final CloudDatabaseServiceDescriptor service;
    private DBNNode[] childNodes;

    DBNCloudServiceNode(DBNNode parentNode, CloudDatabaseServiceDescriptor service) {
        super(parentNode);
        this.service = service;
    }

    @NotNull
    public String getNodeType() {
        return "databaseService";
    }

    @NotNull
    public String getNodeDisplayName() {
        return this.service.getLabel();
    }

    @Nullable
    public String getNodeDescription() {
        return this.service.getDescription();
    }

    @Nullable
    public DBPImage getNodeIcon() {
        return this.service.getIcon();
    }

    protected boolean allowsChildren() {
        return true;
    }

    @Nullable
    public DBNNode[] getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.childNodes == null && !monitor.isForceCacheUsage()) {
            this.childNodes = this.readServiceInstances(monitor);
        }
        return this.childNodes;
    }

    @Override
    @Deprecated
    @NotNull
    public String getNodeItemPath() {
        return this.getParentNode().getNodeItemPath() + "/" + this.service.getLabel();
    }

    private DBNNode[] readServiceInstances(DBRProgressMonitor monitor) throws DBException {
        CPCloudExplorer<?> cloudExplorer = this.getCloudNode().getCloudExplorer(monitor);
        CPDatabaseNode[] databaseNodes = cloudExplorer.getDatabaseInstances(monitor, this.service.getId(), this.getParentDatabaseFolder());
        return DBNCloudServiceNode.createDatabaseNodes(monitor, this, databaseNodes);
    }

    private CPDatabaseFolder getParentDatabaseFolder() {
        DBNNode parent = this.getParentNode();
        while (parent != null) {
            if (parent instanceof DBNCloudFolderNode) {
                return ((DBNCloudFolderNode)parent).getFolder();
            }
            parent = parent.getParentNode();
        }
        return null;
    }

    @NotNull
    static DBNNode[] createDatabaseNodes(DBRProgressMonitor monitor, DBNCloudItemNode parentNode, CPDatabaseNode[] databaseNodes) throws DBException {
        ArrayList<Object> nodes = new ArrayList<Object>();
        if (databaseNodes != null) {
            CPDatabaseNode[] cPDatabaseNodeArray = databaseNodes;
            int n = databaseNodes.length;
            int n2 = 0;
            while (n2 < n) {
                CPDatabaseNode databaseNode = cPDatabaseNodeArray[n2];
                if (databaseNode instanceof CPDatabaseInstance) {
                    try {
                        CPDatabaseInstance instance = (CPDatabaseInstance)databaseNode;
                        DBPDataSourceContainer dataSourceContainer = instance.createDataSourceContainer(monitor, parentNode.getCloudNode().getDataSourceRegistry());
                        nodes.add((Object)new DBNCloudDataSourceNode(parentNode, instance, dataSourceContainer));
                    }
                    catch (Exception e) {
                        throw new DBException("Error creating datasource for database instance '" + databaseNode.getNodeId() + "'", (Throwable)e);
                    }
                } else if (databaseNode instanceof CPDatabaseCluster) {
                    nodes.add((Object)new DBNCloudClusterNode(parentNode, (CPDatabaseCluster)databaseNode));
                } else {
                    nodes.add((Object)new DBNCloudDatabaseNode(parentNode, databaseNode));
                }
                ++n2;
            }
        }
        return nodes.toArray(new DBNNode[0]);
    }

    @Nullable
    public DBNNode refreshNode(@NotNull DBRProgressMonitor monitor, @Nullable Object source) throws DBException {
        if (this.childNodes != null) {
            DBNNode[] dBNNodeArray = this.childNodes;
            int n = this.childNodes.length;
            int n2 = 0;
            while (n2 < n) {
                DBNNode node = dBNNodeArray[n2];
                DBNUtils.disposeNode((DBNNode)node, (boolean)true);
                ++n2;
            }
            this.childNodes = null;
        }
        return this;
    }

    @Override
    @NotNull
    public String toString() {
        return this.service.toString();
    }

    public boolean needsInitialization() {
        return this.childNodes == null;
    }
}

