/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.model;

import com.dbeaver.cloud.impl.AbstractCloud;
import com.dbeaver.cloud.statistic.CloudFeature;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.auth.SMSessionContext;
import org.jkiss.dbeaver.model.fs.AbstractVirtualFileSystem;
import org.jkiss.dbeaver.model.fs.DBFVirtualFileSystemRoot;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public abstract class AbstractCloudVirtualFileSystem<BUCKET_TYPE extends DBFVirtualFileSystemRoot, CLOUD_TYPE extends AbstractCloud>
extends AbstractVirtualFileSystem {
    protected List<BUCKET_TYPE> buckets;
    protected CLOUD_TYPE cloud;
    protected SMSessionContext sessionContext;

    public AbstractCloudVirtualFileSystem(CLOUD_TYPE cloud, SMSessionContext sessionContext) {
        this.cloud = cloud;
        this.sessionContext = sessionContext;
    }

    public CLOUD_TYPE getCloud() {
        return this.cloud;
    }

    public void refreshRoots(DBRProgressMonitor monitor) throws DBException {
        this.buckets = null;
        this.getRootFolders(monitor);
    }

    @NotNull
    public List<BUCKET_TYPE> getRootFolders(DBRProgressMonitor monitor) throws DBException {
        if (this.buckets == null) {
            this.buckets = this.getBucketsFromCloudSystem(monitor);
            CloudFeature.CLOUD_STORAGE_CONNECT.use(Map.of("origin", "cloud." + ((AbstractCloud)this.cloud).getProvider().getCloudProviderId()));
        }
        return this.buckets;
    }

    public void close() throws IOException {
        if (this.buckets != null) {
            for (DBFVirtualFileSystemRoot bucket : this.buckets) {
                bucket.close();
            }
            this.buckets = Collections.emptyList();
        }
    }

    protected abstract List<BUCKET_TYPE> getBucketsFromCloudSystem(DBRProgressMonitor var1) throws DBException;
}

