/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.impl;

import com.dbeaver.cloud.model.CPCloud;
import com.dbeaver.cloud.model.CPCloudConfiguration;
import com.dbeaver.cloud.model.CPCloudProvider;
import com.dbeaver.cloud.model.CPCloudUtils;
import com.dbeaver.cloud.registry.BaseCloudConfigurationProvider;
import com.dbeaver.cloud.registry.CPCloudConfigurationListener;
import com.dbeaver.cloud.registry.CPCloudConfigurationProvider;
import com.dbeaver.cloud.registry.CPCloudConfigurationRegistry;
import com.dbeaver.cloud.registry.CloudProviderRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.WorkspaceConfigEventManager;
import org.jkiss.utils.CommonUtils;

public abstract class AbstractCloudProvider<CLOUD extends CPCloud<?, ?>>
implements CPCloudProvider,
CPCloudConfigurationListener {
    private List<CLOUD> allClouds;

    public AbstractCloudProvider() {
        CPCloudConfigurationRegistry.getInstance().addConfigurationChangeListener(this, true);
        CPCloudConfigurationProvider<?> confProvider = CloudProviderRegistry.getInstance().getConfigurationProvider(this.getCloudProviderId());
        if (confProvider instanceof BaseCloudConfigurationProvider) {
            BaseCloudConfigurationProvider baseProvider = (BaseCloudConfigurationProvider)confProvider;
            WorkspaceConfigEventManager.addConfigChangedListener((String)baseProvider.getCloudConfigurationFileName(), o -> this.handleCloudConfigurationChange());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<CLOUD> getAvailableClouds() throws DBException {
        if (this.allClouds == null) {
            CPCloudConfigurationProvider<?> configurationProvider = CloudProviderRegistry.getInstance().getConfigurationProvider(this.getCloudProviderId());
            List<Object> configurations = new ArrayList();
            if (configurationProvider != null) {
                configurations = configurationProvider.loadCloudConfigurations();
            }
            AbstractCloudProvider abstractCloudProvider = this;
            synchronized (abstractCloudProvider) {
                if (this.allClouds != null) {
                    return this.allClouds;
                }
                this.allClouds = new ArrayList<CLOUD>();
            }
            for (CPCloudConfiguration cPCloudConfiguration : configurations) {
                CLOUD cloud;
                if (CommonUtils.isEmpty((String)cPCloudConfiguration.getCloudId())) {
                    String newCloudId = cPCloudConfiguration.getCloudName();
                    if (CommonUtils.isEmpty((String)newCloudId)) {
                        newCloudId = CPCloudUtils.generateCloudId(this.getCloudProviderId(), configurations.stream().map(CPCloudConfiguration::getCloudId).collect(Collectors.toList()));
                    }
                    cPCloudConfiguration.setCloudId(newCloudId);
                }
                if ((cloud = this.createCloudFromConfiguration(cPCloudConfiguration)) == null) continue;
                this.allClouds.add(cloud);
            }
        }
        return this.allClouds;
    }

    @Override
    public void handleCloudConfigurationChange() {
        this.reloadClouds();
    }

    public void reloadClouds() {
        this.allClouds = null;
    }

    public abstract CLOUD createCloudFromConfiguration(CPCloudConfiguration var1);
}

