/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.security;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.StringJoiner;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;

public class AdvancedSecurityUtils {
    public static PublicKey getPublicKey(@NotNull String algorithm, @NotNull long[] data, int length) throws DBException {
        try {
            return KeyFactory.getInstance(algorithm).generatePublic(new X509EncodedKeySpec(AdvancedSecurityUtils.shakeDownData(data, length)));
        }
        catch (InvalidKeySpecException e) {
            throw new DBException("Invalid public key", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new DBException("Invalid algorithm", (Throwable)e);
        }
    }

    @NotNull
    private static String shakeUpData(byte[] data) {
        VarHandle handle = MethodHandles.byteArrayViewVarHandle(long[].class, ByteOrder.nativeOrder());
        byte[] buffer = Arrays.copyOf(data, (data.length + 8 - 1) / 8 * 8);
        StringJoiner string = new StringJoiner(", ", "{", "}");
        int i = 0;
        while (i < buffer.length) {
            string.add("%#018xL".formatted(handle.get(buffer, i)));
            i += 8;
        }
        return string.toString();
    }

    @NotNull
    private static byte[] shakeDownData(@NotNull long[] input, int length) {
        VarHandle handle = MethodHandles.byteArrayViewVarHandle(long[].class, ByteOrder.nativeOrder());
        byte[] buffer = new byte[input.length * 8];
        int i = 0;
        while (i < input.length) {
            handle.set(buffer, i * 8, input[i]);
            ++i;
        }
        return Arrays.copyOf(buffer, length);
    }
}

