/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.net;

import com.dbeaver.model.net.CustomNameService;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class ConfigurableNameService
implements CustomNameService {
    public static final ConfigurableNameService INSTANCE = new ConfigurableNameService();
    private final Map<String, InetAddress[]> hostMappings = new HashMap<String, InetAddress[]>();

    private ConfigurableNameService() {
    }

    @Override
    public InetAddress[] lookupAllHostAddr(String host) throws UnknownHostException {
        return this.hostMappings.get(host);
    }

    @Override
    public String getHostByAddr(byte[] addr) throws UnknownHostException {
        for (Map.Entry<String, InetAddress[]> me : this.hostMappings.entrySet()) {
            InetAddress[] inetAddressArray = me.getValue();
            int n = inetAddressArray.length;
            int n2 = 0;
            while (n2 < n) {
                InetAddress ia = inetAddressArray[n2];
                if (Arrays.equals(ia.getAddress(), addr)) {
                    return me.getKey();
                }
                ++n2;
            }
        }
        return null;
    }

    public void mapHostAddress(String hostName, InetAddress[] addresses) {
        this.hostMappings.put(hostName, addresses);
    }

    public void unmapHostAddress(String hostName) {
        this.hostMappings.remove(hostName);
    }
}

