/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.datasource.parameters;

import com.dbeaver.model.datasource.DataSourceDescriptorPRO;
import com.dbeaver.model.datasource.parameters.DBPDatasourceExternalParameters;
import com.dbeaver.model.datasource.parameters.DBPParametersConfiguration;
import com.dbeaver.model.datasource.parameters.DBPParametersMappingRule;
import com.dbeaver.model.datasource.parameters.DBPParametersProvider;
import com.dbeaver.model.datasource.parameters.registry.DBPParametersProviderDescriptor;
import com.dbeaver.model.datasource.parameters.registry.DBPParametersProviderRegistry;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class DBPParametersUtils {
    private static final Log log = Log.getLog(DBPParametersUtils.class);

    public static void patchDataSourceConfiguration(@NotNull DBRProgressMonitor monitor, @NotNull DataSourceDescriptorPRO dataSourceDescriptor, @NotNull DBPConnectionConfiguration configuration) throws DBException {
        DBPDatasourceExternalParameters externalParametersConfig = dataSourceDescriptor.getExternalParametersConfig();
        if (dataSourceDescriptor.getExternalParametersConfig() == null) {
            return;
        }
        if (CommonUtils.isEmpty((String)dataSourceDescriptor.getExternalParametersConfig().getSecretName())) {
            throw new DBException("Secrets config is missing a secret name");
        }
        if (!DBWorkbench.getPlatform().getWorkspace().isEnabledSecretProviders()) {
            throw new DBException("The connection requires Secret Management, it is disabled on the server");
        }
        DBPParametersProviderRegistry parametersProviderRegistry = DBPParametersProviderRegistry.getInstance();
        DBPParametersProviderDescriptor parametersProviderDescriptor = parametersProviderRegistry.getProviderByConfigurationId(externalParametersConfig.getConfigurationId());
        DBPParametersProvider<?> parametersProvider = parametersProviderDescriptor.getInstance();
        Map<String, ?> externalDatasourceParameters = parametersProvider.readParameters(monitor, dataSourceDescriptor);
        if (externalDatasourceParameters == null || externalDatasourceParameters.isEmpty()) {
            log.warn((Object)("DataSource parameters not found in secret: " + externalParametersConfig.getSecretName()));
            return;
        }
        DBPParametersConfiguration providerConfig = parametersProviderRegistry.getProviderConfiguration(externalParametersConfig.getConfigurationId());
        if (providerConfig == null) {
            log.warn((Object)("Provider configuration is not found: " + externalParametersConfig.getConfigurationId()));
            return;
        }
        DBPParametersMappingRule usedMappingRule = externalParametersConfig.getCustomDatasourceRule() != null ? new DBPParametersMappingRule(externalParametersConfig.getCustomDatasourceRule(), providerConfig.getMappingRule()) : providerConfig.getMappingRule();
        Map<String, Object> mappedParameters = DBPParametersUtils.remapParametersByRules(externalDatasourceParameters, usedMappingRule);
        DBPParametersUtils.processExternalProperties(configuration, mappedParameters, dataSourceDescriptor.getDriver());
    }

    private static void processExternalProperties(@NotNull DBPConnectionConfiguration configuration, @NotNull Map<String, Object> parameters, @NotNull DBPDriver driver) {
        String server;
        String database;
        String port;
        String username;
        if (parameters.isEmpty()) {
            return;
        }
        String password = JSONUtils.getString(parameters, (String)"password");
        if (password != null) {
            configuration.setUserPassword(password);
        }
        if ((username = JSONUtils.getString(parameters, (String)"user")) != null) {
            configuration.setUserName(username);
        }
        boolean connectionUrlChanged = false;
        String host = JSONUtils.getString(parameters, (String)"host");
        if (host != null) {
            configuration.setHostName(host);
            connectionUrlChanged = true;
        }
        if ((port = JSONUtils.getString(parameters, (String)"port")) != null) {
            configuration.setHostPort(port);
            connectionUrlChanged = true;
        }
        if ((database = JSONUtils.getString(parameters, (String)"database")) != null) {
            configuration.setDatabaseName(database);
            connectionUrlChanged = true;
        }
        if (connectionUrlChanged) {
            configuration.setUrl(driver.getConnectionURL(configuration));
        }
        if ((server = JSONUtils.getString(parameters, (String)"server")) != null) {
            configuration.setServerName(server);
        }
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            String key;
            if (entry.getKey().startsWith("auth.")) {
                key = entry.getKey().substring("auth.".length());
                configuration.setAuthProperty(key, JSONUtils.getString(parameters, (String)entry.getKey()));
                continue;
            }
            if (!entry.getKey().startsWith("properties.")) continue;
            key = entry.getKey().substring("properties.".length());
            configuration.setProperty(key, JSONUtils.getString(parameters, (String)entry.getKey()));
        }
    }

    @NotNull
    private static Map<String, Object> remapParametersByRules(@NotNull Map<String, ?> externalDatasourceParameters, @NotNull DBPParametersMappingRule mappingRule) {
        LinkedHashMap<String, Object> resultParametersMap = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, ?> entry : externalDatasourceParameters.entrySet()) {
            resultParametersMap.put(mappingRule.getExpectedKeyName(entry.getKey()), entry.getValue());
        }
        return resultParametersMap;
    }
}

