/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.data.hints;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDValueRow;
import org.jkiss.dbeaver.model.data.hints.DBDValueHint;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.utils.CommonUtils;

public class ValueHintForeignKey
implements DBDValueHint {
    public static final Object DICT_KEY_MISSING = new Object();
    @Nullable
    private final Object hintText;
    @NotNull
    private final DBDAttributeBinding attribute;
    @Nullable
    private final DBDValueRow row;
    @NotNull
    private final DBSEntityAssociation association;

    public ValueHintForeignKey(@NotNull Object hintText, @NotNull DBDAttributeBinding attribute, @NotNull DBDValueRow row, @NotNull DBSEntityAssociation association) {
        this.hintText = hintText;
        this.attribute = attribute;
        this.row = row;
        this.association = association;
    }

    public ValueHintForeignKey(@NotNull DBDAttributeBinding attribute, @NotNull DBSEntityAssociation association) {
        this.hintText = null;
        this.attribute = attribute;
        this.row = null;
        this.association = association;
    }

    @NotNull
    public DBSEntityAssociation getAssociation() {
        return this.association;
    }

    public DBDValueHint.HintType getHintType() {
        return DBDValueHint.HintType.STRING;
    }

    @NotNull
    public String getHintText() {
        if (this.hintText == DICT_KEY_MISSING) {
            return "Dictionary value not found";
        }
        return CommonUtils.toString((Object)this.hintText, (String)"");
    }

    public String getHintDescription() {
        return "Dictionary title for '" + this.attribute.getName() + "' referenced row";
    }

    public DBDValueHint.HintStyle getHintStyle() {
        if (this.hintText == DICT_KEY_MISSING) {
            return DBDValueHint.HintStyle.ERROR;
        }
        return DBDValueHint.HintStyle.NORMAL;
    }
}

