/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.ai.engine.aws;

import com.dbeaver.model.ai.engine.aws.AwsBedrockEngine;
import com.dbeaver.model.ai.engine.aws.AwsBedrockProperties;
import com.dbeaver.ui.ai.engine.aws.AwsBedrockMessages;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.ai.engine.AIEngineProperties;
import org.jkiss.dbeaver.model.ai.engine.AIModel;
import org.jkiss.dbeaver.model.ai.registry.AIEngineDescriptor;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.ai.preferences.AIIObjectPropertyConfigurator;
import org.jkiss.utils.CommonUtils;
import software.amazon.awssdk.regions.Region;

public class AwsBedrockConfigurator
implements AIIObjectPropertyConfigurator<AIEngineDescriptor, AwsBedrockProperties> {
    private String accessKey = "";
    private String secretKey = "";
    private volatile String model = "";
    private String region;
    private boolean logQuery = false;
    private Button logQueryCheck;
    private boolean showInferences;
    private Button showInferencesCheck;
    private Text accessKeyText;
    private Text secretKeyText;
    private Combo awsRegionCombo;
    private Text temperatureText;
    private Text contextSizeText;
    private String contextSize;
    private Combo modelCombo;
    private String temperature = "0.0";
    private Button listModelsButton;

    public void createControl(@NotNull Composite parent, AIEngineDescriptor object, @NotNull Runnable propertyChangeListener) {
        Composite rootComposite = UIUtils.createComposite((Composite)parent, (int)3);
        rootComposite.setLayoutData((Object)new GridData(768));
        this.accessKeyText = UIUtils.createLabelText((Composite)rootComposite, (String)AwsBedrockMessages.aws_bedrock_preference_page_access_key, (String)"", (int)0x400800);
        GridData gridData = new GridData(768);
        gridData.widthHint = 150;
        gridData.horizontalSpan = 2;
        this.accessKeyText.setLayoutData((Object)gridData);
        this.accessKeyText.addModifyListener(e -> {
            String string = this.accessKey = this.accessKeyText.getText();
        });
        this.accessKeyText.setMessage(AwsBedrockMessages.aws_bedrock_preference_page_access_key_message);
        this.secretKeyText = UIUtils.createLabelText((Composite)rootComposite, (String)AwsBedrockMessages.aws_bedrock_preference_page_secret_key, (String)"", (int)0x400800);
        this.secretKeyText.setMessage(AwsBedrockMessages.aws_bedrock_preference_page_secret_key_message);
        this.secretKeyText.setLayoutData((Object)gridData);
        this.secretKeyText.addModifyListener(e -> {
            String string = this.secretKey = this.secretKeyText.getText();
        });
        rootComposite.setLayoutData((Object)new GridData(768));
        this.createModelCombo(rootComposite);
        this.contextSizeText = UIUtils.createLabelText((Composite)rootComposite, (String)AwsBedrockMessages.aws_bedrock_preference_page_context_size, (String)"", (int)2048);
        this.contextSizeText.setLayoutData((Object)gridData);
        this.contextSizeText.addModifyListener(e -> {
            String string = this.contextSize = this.contextSizeText.getText();
        });
        this.contextSizeText.setMessage(AwsBedrockMessages.aws_bedrock_preference_page_context_size_message);
        this.contextSizeText.addVerifyListener(UIUtils.getIntegerVerifyListener((Locale)Locale.getDefault()));
        this.temperatureText = UIUtils.createLabelText((Composite)rootComposite, (String)AwsBedrockMessages.aws_bedrock_preference_page_text_temperature, (String)"0.0");
        this.temperatureText.setToolTipText(AwsBedrockMessages.aws_bedrock_preference_page_text_temperature_tip);
        this.temperatureText.addVerifyListener(UIUtils.getNumberVerifyListener((Locale)Locale.getDefault()));
        this.temperatureText.addModifyListener(e -> {
            String string = this.temperature = this.temperatureText.getText();
        });
        this.temperatureText.setLayoutData((Object)gridData);
        this.logQueryCheck = UIUtils.createCheckbox((Composite)rootComposite, (String)AwsBedrockMessages.aws_bedrock_preference_page_text_debug, (String)AwsBedrockMessages.aws_bedrock_preference_page_text_debug_tip, (boolean)false, (int)3);
        this.logQueryCheck.addSelectionListener(SelectionListener.widgetSelectedAdapter(selectionEvent -> {
            boolean bl = this.logQuery = this.logQueryCheck.getSelection();
        }));
    }

    public void loadSettings(@NotNull AwsBedrockProperties configuration) {
        this.accessKey = CommonUtils.toString((Object)configuration.getAccessKey(), (String)"");
        this.contextSize = CommonUtils.toString((Object)configuration.getContextWindowSize(), (String)"20000");
        this.secretKey = CommonUtils.toString((Object)configuration.getSecretAccessKey(), (String)"");
        this.region = CommonUtils.toString((Object)configuration.getAwsRegionId(), (String)"");
        this.temperature = CommonUtils.toString((Object)configuration.getTemperature(), (String)"0.0");
        this.logQuery = CommonUtils.toBoolean((Object)configuration.isLoggingEnabled());
        this.showInferences = CommonUtils.toBoolean((Object)configuration.isShowInferences());
        this.model = CommonUtils.toString((Object)configuration.getModel(), (String)"");
        this.applySettings();
    }

    public void saveSettings(@NotNull AwsBedrockProperties configuration) {
        configuration.setAccessKey(this.accessKey);
        configuration.setSecretAccessKey(this.secretKey);
        configuration.setAwsRegionId(this.region);
        configuration.setTemperature(CommonUtils.toDouble((Object)this.temperature, (double)0.0));
        configuration.setLoggingEnabled(this.logQuery);
        configuration.setModel(this.model);
        configuration.setContextWindowSize(Integer.valueOf(CommonUtils.toInt((Object)this.contextSize, (int)200)));
        configuration.setShowInferences(this.showInferences);
    }

    public void resetSettings(@NotNull AwsBedrockProperties awsBedrockProperties) {
    }

    public boolean isComplete() {
        return !this.contextSizeText.getText().isEmpty() && !this.accessKeyText.getText().isEmpty() && !this.secretKeyText.getText().isEmpty() && !this.modelCombo.getText().isEmpty();
    }

    public Optional<AIEngineProperties> getCurrentProperties() {
        AwsBedrockProperties configuration = new AwsBedrockProperties();
        this.saveSettings(configuration);
        return Optional.of(configuration);
    }

    protected void applySettings() {
        if (this.accessKey != null) {
            this.accessKeyText.setText(this.accessKey);
        }
        if (this.secretKey != null) {
            this.secretKeyText.setText(this.secretKey);
        }
        if (this.temperature != null) {
            this.temperatureText.setText(this.temperature);
        }
        if (this.listModelsButton.isEnabled()) {
            this.modelCombo.setItems(new String[]{this.model});
            this.modelCombo.select(0);
            this.modelCombo.setText(this.model);
        }
        if (this.awsRegionCombo != null && this.region != null) {
            this.awsRegionCombo.select(this.awsRegionCombo.indexOf(this.region));
        }
        this.contextSizeText.setText(this.contextSize);
        this.showInferencesCheck.setSelection(this.showInferences);
        this.logQueryCheck.setSelection(this.logQuery);
    }

    private void createRegionCombo(@NotNull Composite rootComposite) {
        this.awsRegionCombo = UIUtils.createLabelCombo((Composite)rootComposite, (String)AwsBedrockMessages.aws_bedrock_preference_page_region, (String)"", (int)2056);
        this.awsRegionCombo.setLayoutData((Object)new GridData(768));
        this.awsRegionCombo.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.region = this.awsRegionCombo.getText();
            this.refreshModels();
        }));
        List<String> regionNames = Region.regions().stream().map(Region::id).toList();
        this.awsRegionCombo.setItems(regionNames.toArray(new String[0]));
        GridData gridData = new GridData(768);
        gridData.widthHint = 150;
        gridData.horizontalSpan = 2;
        this.awsRegionCombo.setLayoutData((Object)gridData);
    }

    private void createModelCombo(@NotNull Composite parentComposite) {
        GridData gridData = new GridData(768);
        gridData.widthHint = 150;
        gridData.horizontalSpan = 3;
        Group modelGroup = UIUtils.createControlGroup((Composite)parentComposite, (String)AwsBedrockMessages.aws_bedrock_preference_page_aws_model_group, (int)3, (int)768, (int)0);
        this.createRegionCombo((Composite)modelGroup);
        modelGroup.setLayoutData((Object)gridData);
        this.modelCombo = UIUtils.createLabelCombo((Composite)modelGroup, (String)AwsBedrockMessages.aws_bedrock_preference_page_model_or_inference, (String)"", (int)2048);
        this.modelCombo.setLayoutData((Object)new GridData(768));
        this.modelCombo.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            String string = this.model = this.modelCombo.getText();
        }));
        this.modelCombo.addModifyListener(e -> {
            String string = this.model = this.modelCombo.getText();
        });
        this.listModelsButton = UIUtils.createPushButton((Composite)modelGroup, null, (String)AwsBedrockMessages.aws_bedrock_preference_page_load_model, (DBPImage)UIIcon.REFRESH, (SelectionListener)SelectionListener.widgetSelectedAdapter(e -> this.refreshModels()));
        this.createShowInferencesCheckbox((Composite)modelGroup, gridData);
    }

    private void createShowInferencesCheckbox(@NotNull Composite composite, @NotNull GridData gridData) {
        this.showInferencesCheck = UIUtils.createCheckbox((Composite)composite, (String)AwsBedrockMessages.aws_bedrock_preference_page_show_inferences, (String)AwsBedrockMessages.aws_bedrock_preference_page_show_inferences_tip, (boolean)false, (int)3);
        this.showInferencesCheck.setLayoutData((Object)gridData);
        this.showInferencesCheck.addSelectionListener(SelectionListener.widgetSelectedAdapter(selectionEvent -> {
            this.modelCombo.clearSelection();
            this.modelCombo.setItems(new String[0]);
            this.showInferences = this.showInferencesCheck.getSelection();
            this.refreshModels();
        }));
    }

    private void refreshModels() {
        new AbstractJob("Listing models"){

            protected IStatus run(DBRProgressMonitor monitor) {
                if (CommonUtils.isEmpty((String)AwsBedrockConfigurator.this.accessKey) || CommonUtils.isEmpty((String)AwsBedrockConfigurator.this.secretKey)) {
                    DBWorkbench.getPlatformUI().showError("Error reading model list", "Please enter your access key and secret key", (Throwable)new Exception("Token is empty"));
                    return Status.CANCEL_STATUS;
                }
                AwsBedrockProperties properties = new AwsBedrockProperties();
                properties.setAccessKey(AwsBedrockConfigurator.this.accessKey);
                properties.setSecretAccessKey(AwsBedrockConfigurator.this.secretKey);
                properties.setAwsRegionId(AwsBedrockConfigurator.this.region);
                properties.setShowInferences(AwsBedrockConfigurator.this.showInferences);
                try {
                    Throwable throwable = null;
                    Object var4_6 = null;
                    try (AwsBedrockEngine bedrockEngine = new AwsBedrockEngine(properties);){
                        String prevModel = AwsBedrockConfigurator.this.model;
                        List models = bedrockEngine.getModels(monitor);
                        UIUtils.syncExec(() -> {
                            AwsBedrockConfigurator.this.modelCombo.setItems((String[])models.stream().map(AIModel::name).sorted().toArray(String[]::new));
                            int i = 0;
                            while (i < models.size()) {
                                if (AwsBedrockConfigurator.this.modelCombo.getItem(i).equals(prevModel)) {
                                    AwsBedrockConfigurator.this.modelCombo.select(i);
                                }
                                ++i;
                            }
                        });
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception ex) {
                    DBWorkbench.getPlatformUI().showError("Error reading model list", "Failed to read AWS model list", (Throwable)ex);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }
}

