/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.cassandra.exec;

import com.datastax.oss.driver.api.core.cql.AsyncResultSet;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.dbeaver.db.cassandra.exec.CasResultSet;
import com.dbeaver.db.cassandra.exec.CasSession;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.impl.AbstractStatement;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.runtime.DBRBlockingObject;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public abstract class CasBaseStatement
extends AbstractStatement<CasSession> {
    private static final Log log = Log.getLog(CasBaseStatement.class);
    protected final String query;
    protected DBCExecutionSource source;
    protected AsyncResultSet result;
    protected Throwable executeError;
    protected long offset;
    protected long limit;
    protected long updateCount = -1L;
    protected int statementTimeout;
    protected volatile CompletionStage<AsyncResultSet> resultSetFuture;

    protected CasBaseStatement(CasSession session, String query) {
        super((DBCSession)session);
        this.query = query;
        if (session.isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementOpen((DBCStatement)this);
        }
    }

    public String getQueryString() {
        return this.query;
    }

    public DBCExecutionSource getStatementSource() {
        return this.source;
    }

    public void setStatementSource(@Nullable DBCExecutionSource source) {
        this.source = source;
    }

    public CasResultSet openResultSet() {
        if (this.result == null) {
            return null;
        }
        return new CasResultSet(this, this.result);
    }

    public long getUpdateRowCount() {
        return this.updateCount;
    }

    public boolean nextResults() {
        this.updateCount = -1L;
        this.result = null;
        return false;
    }

    public void setLimit(long offset, long limit) {
        this.offset = offset;
        this.limit = limit;
    }

    @Nullable
    public Throwable[] getStatementWarnings() {
        ExecutionInfo executionInfo;
        if (this.result != null && (executionInfo = this.result.getExecutionInfo()) != null && !CommonUtils.isEmpty((Collection)executionInfo.getWarnings())) {
            List warnings = executionInfo.getWarnings();
            Throwable[] result = new Throwable[warnings.size()];
            int i = 0;
            while (i < warnings.size()) {
                String warning = (String)warnings.get(i);
                result[i] = new Exception(warning);
                ++i;
            }
            return result;
        }
        return null;
    }

    public void cancelBlock(@NotNull DBRProgressMonitor monitor, @Nullable Thread blockThread) throws DBException {
        CompletionStage<AsyncResultSet> rsFuture = this.resultSetFuture;
        if (rsFuture != null) {
            if (!rsFuture.toCompletableFuture().cancel(true)) {
                throw new DBException("Can't cancel future result set");
            }
        } else if (blockThread != null) {
            blockThread.interrupt();
        } else {
            throw new DBException("Can't cancel - no future result set");
        }
    }

    public void setStatementTimeout(int timeout) {
        this.statementTimeout = timeout;
    }

    public void setResultsFetchSize(int fetchSize) {
    }

    public long getOffset() {
        return this.offset;
    }

    public long getLimit() {
        return this.limit;
    }

    public abstract Statement getStatementImpl();

    protected DBCException handleExecuteError(Throwable ex) {
        this.executeError = ex;
        if (ex instanceof DBCException) {
            return (DBCException)ex;
        }
        return new DBCException(ex, (DBCExecutionContext)((CasSession)this.getSession()).getExecutionContext());
    }

    public void startBlock(String name) {
        ((CasSession)this.getSession()).getProgressMonitor().startBlock((DBRBlockingObject)this, "Execute prepared statement");
    }

    public void endBlock() {
        ((CasSession)this.getSession()).getProgressMonitor().endBlock();
    }
}

