/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.cassandra.data.handlers;

import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.dbeaver.db.cassandra.data.handlers.CasBaseValueHandler;
import com.dbeaver.db.cassandra.exec.CasPreparedStatement;
import com.dbeaver.db.cassandra.exec.CasSession;
import java.util.UUID;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class CasUUIDValueHandler
extends CasBaseValueHandler {
    public static final CasUUIDValueHandler INSTANCE = new CasUUIDValueHandler();

    @NotNull
    public Class<UUID> getValueObjectType(@NotNull DBSTypedObject attribute) {
        return UUID.class;
    }

    public Object getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, Object object, boolean copy, boolean validateValue) throws DBCException {
        if (object == null) {
            return null;
        }
        if (object instanceof UUID) {
            return object;
        }
        String str = object.toString();
        if (str.isEmpty()) {
            return null;
        }
        return UUID.fromString(str);
    }

    @Override
    protected void bindParameter(CasSession session, CasPreparedStatement statement, DBSTypedObject paramType, int paramIndex, Object value) throws DBCException {
        if (value instanceof String) {
            value = UUID.fromString((String)value);
        }
        if (value == null) {
            statement.updateBoundStatement((BoundStatement)statement.getBoundStatement().setToNull(paramIndex));
            return;
        }
        statement.updateBoundStatement((BoundStatement)statement.getBoundStatement().setUuid(paramIndex, (UUID)value));
    }
}

