/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.redshift.model;

import com.dbeaver.db.redshift.model.RedshiftDataSource;
import com.dbeaver.db.redshift.model.RedshiftDatabase;
import com.dbeaver.db.redshift.model.RedshiftDatashare;
import com.dbeaver.db.redshift.model.RedshiftSharedSchema;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.Reader;
import java.io.StringReader;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBDatabaseException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreObject;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.cache.ListCache;
import org.jkiss.utils.CommonUtils;

public class RedshiftSharedDatabase
implements PostgreObject,
DBSObjectContainer,
DBPRefreshableObject {
    private static final Log log = Log.getLog(RedshiftSharedDatabase.class);
    private static final Gson OPTIONS_PARSER = new GsonBuilder().create();
    private final RedshiftDataSource dataSource;
    private final RedshiftDatabase ownerDatabase;
    private final long dbId;
    private final String name;
    private Map<String, Object> databaseOptions;
    private ListCache<RedshiftSharedDatabase, RedshiftSharedSchema> schemaCache;

    public RedshiftSharedDatabase(RedshiftDataSource dataSource, RedshiftDatabase ownerDatabase, ResultSet dbResult) {
        block4: {
            this.schemaCache = null;
            this.dataSource = dataSource;
            this.ownerDatabase = ownerDatabase;
            this.dbId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"oid");
            this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"datname");
            String databaseOptionsString = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"database_options");
            if (!CommonUtils.isEmpty((String)databaseOptionsString)) {
                try {
                    this.databaseOptions = JSONUtils.parseMap((Gson)OPTIONS_PARSER, (Reader)new StringReader(databaseOptionsString));
                }
                catch (Exception e) {
                    String shareName;
                    log.debug((Object)("Error parsing datashare options as JSON: " + e.getMessage()));
                    Matcher matcher = Pattern.compile("\"datashare_name\":\"([\\w]+)\"").matcher(databaseOptionsString);
                    if (!matcher.find() || (shareName = matcher.group(1)) == null) break block4;
                    this.databaseOptions = new HashMap<String, Object>();
                    this.databaseOptions.put("datashare_name", shareName);
                }
            }
        }
        if (this.databaseOptions == null) {
            this.databaseOptions = Collections.emptyMap();
        }
    }

    @Nullable
    public DBSObject getParentObject() {
        return this.dataSource;
    }

    @NotNull
    public PostgreDataSource getDataSource() {
        return this.dataSource;
    }

    @NotNull
    public PostgreDatabase getDatabase() {
        return this.ownerDatabase;
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    @Property(viewable=false, order=10)
    public long getObjectId() {
        return this.dbId;
    }

    public boolean isPersisted() {
        return true;
    }

    @Property(viewable=true, order=2)
    public RedshiftDatashare getDatashare(DBRProgressMonitor monitor) throws DBException {
        return this.ownerDatabase.getDatashare(monitor, this.getDatashareName());
    }

    @Property(viewable=true, order=5)
    public Map<String, Object> getDatabaseOptions() {
        return this.databaseOptions;
    }

    public String getDatashareName() {
        return (String)this.databaseOptions.get("datashare_name");
    }

    @Nullable
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.schemaCache = null;
        return this;
    }

    @Association
    public List<RedshiftSharedSchema> getSchemas(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (!monitor.isForceCacheUsage()) {
            this.readSchemas(monitor);
        }
        return this.schemaCache == null ? null : this.schemaCache.getCachedObjects();
    }

    public void readSchemas(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.schemaCache == null) {
            ArrayList<RedshiftSharedSchema> schemas = new ArrayList<RedshiftSharedSchema>();
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)this.getDataSource(), (String)"Read shared schemas");){
                    Throwable throwable2 = null;
                    Object var7_11 = null;
                    try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT * FROM pg_catalog.svv_redshift_schemas\nWHERE database_name=? AND schema_type='shared'");){
                        dbStat.setString(1, this.getName());
                        Throwable throwable3 = null;
                        Object var10_16 = null;
                        try (ResultSet resultSet = dbStat.executeQuery();){
                            while (resultSet.next()) {
                                schemas.add(new RedshiftSharedSchema(this, resultSet));
                            }
                        }
                        catch (Throwable throwable4) {
                            if (throwable3 == null) {
                                throwable3 = throwable4;
                            } else if (throwable3 != throwable4) {
                                throwable3.addSuppressed(throwable4);
                            }
                            throw throwable3;
                        }
                    }
                    catch (Throwable throwable5) {
                        if (throwable2 == null) {
                            throwable2 = throwable5;
                        } else if (throwable2 != throwable5) {
                            throwable2.addSuppressed(throwable5);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable6) {
                    if (throwable == null) {
                        throwable = throwable6;
                    } else if (throwable != throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                throw new DBDatabaseException((Throwable)e, (DBPDataSource)this.getDataSource());
            }
            this.schemaCache = new ListCache(schemas);
        }
    }

    public List<RedshiftSharedSchema> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (!monitor.isForceCacheUsage()) {
            this.readSchemas(monitor);
        }
        return this.schemaCache == null ? null : this.schemaCache.getAllObjects(monitor, (DBSObject)this);
    }

    @Nullable
    public RedshiftSharedSchema getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        if (monitor != null) {
            this.readSchemas(monitor);
        }
        return (RedshiftSharedSchema)this.schemaCache.getObject(monitor, (DBSObject)this, childName);
    }

    @NotNull
    public Class<? extends DBSObject> getPrimaryChildType(@Nullable DBRProgressMonitor monitor) throws DBException {
        return RedshiftSharedSchema.class;
    }

    public void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
        this.readSchemas(monitor);
    }
}

