/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.aws.ui;

import com.dbeaver.cloud.aws.AWSCloudConfiguration;
import com.dbeaver.cloud.aws.AWSCloudUtils;
import com.dbeaver.cloud.aws.parameters.AWSParametersProviderConfiguration;
import com.dbeaver.cloud.model.CPCloudConfiguration;
import com.dbeaver.cloud.model.DBPCloudParametersConfiguration;
import com.dbeaver.cloud.ui.provider.BaseCloudParametersProviderEditor;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;
import software.amazon.awssdk.regions.Region;

public class AwsParametersProviderConfigurator
extends BaseCloudParametersProviderEditor<AWSCloudConfiguration, AWSParametersProviderConfiguration> {
    private Combo regionCombo;

    public AwsParametersProviderConfigurator() {
        super(AWSCloudConfiguration.class);
    }

    public void createControl(@NotNull Composite parent, AWSParametersProviderConfiguration object, @NotNull Runnable propertyChangeListener) {
        super.createControl(parent, (DBPCloudParametersConfiguration)object, propertyChangeListener);
        this.regionCombo = UIUtils.createLabelCombo((Composite)parent, (String)"Region", (int)4);
    }

    public void loadSettings(@NotNull AWSParametersProviderConfiguration configuration) {
        super.loadSettings((DBPCloudParametersConfiguration)configuration);
        this.updateRegion(configuration);
    }

    public void saveSettings(@NotNull AWSParametersProviderConfiguration configuration) {
        super.saveSettings((DBPCloudParametersConfiguration)configuration);
        configuration.setRegion(this.regionCombo.getText());
    }

    public boolean isComplete() {
        return super.isComplete() && !CommonUtils.isEmpty((String)this.regionCombo.getText());
    }

    protected void onCloudChange(AWSCloudConfiguration selectedCloud) {
        super.onCloudChange((CPCloudConfiguration)selectedCloud);
        this.updateRegion((AWSParametersProviderConfiguration)this.getCurrentParameters());
    }

    private void updateRegion(@NotNull AWSParametersProviderConfiguration configuration) {
        this.regionCombo.removeAll();
        AWSCloudConfiguration currentCloud = (AWSCloudConfiguration)this.getCurrentCloud();
        if (currentCloud != null) {
            for (Region region : AWSCloudUtils.getAllRegions((AWSCloudConfiguration)currentCloud)) {
                this.regionCombo.add(region.toString());
            }
        }
        this.regionCombo.setText(CommonUtils.notEmpty((String)configuration.getRegion()));
    }
}

