/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.aws.ui;

import com.dbeaver.cloud.aws.AWSCloud;
import com.dbeaver.cloud.aws.AWSCloudConfiguration;
import com.dbeaver.cloud.aws.AWSCloudProvider;
import com.dbeaver.cloud.aws.AWSCloudUtils;
import com.dbeaver.cloud.aws.ui.PrefPageAwsSecretManager;
import com.dbeaver.cloud.aws.ui.internal.AwsCloudUIMessages;
import com.dbeaver.cloud.model.CPCloudConfiguration;
import com.dbeaver.cloud.ui.provider.BaseCloudConfigurationEditor;
import com.dbeaver.net.auth.aws.AuthModelAWSAbstract;
import com.dbeaver.net.auth.aws.AuthModelAWSCredentials;
import com.dbeaver.ui.auth.aws.AuthModelAWSConfigurator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import software.amazon.awssdk.regions.PartitionMetadata;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.RegionMetadata;

public class AwsCloudConfigurationEditor
extends BaseCloudConfigurationEditor<AWSCloud, AWSCloudConfiguration, AuthModelAWSConfigurator> {
    private Combo partitionCombo;
    private CheckboxTreeViewer regionTreeViewer;
    private PrefPageAwsSecretManager smPage;
    private final Map<String, PartitionMetadata> awsPartitions = new LinkedHashMap<String, PartitionMetadata>();
    private PartitionMetadata selectedPartition;

    public AwsCloudConfigurationEditor() {
        for (Region region : AWSCloudUtils.getAllRegions(null)) {
            PartitionMetadata partition = region.metadata().partition();
            this.awsPartitions.put(partition.id(), partition);
        }
    }

    protected boolean isSessionOpen(AuthModelAWSConfigurator configurator, AWSCloudConfiguration curConfiguration) {
        if (curConfiguration != null && configurator != null && configurator.isSSOEnabled()) {
            return AWSCloudProvider.getInstance().createCloudFromConfiguration((CPCloudConfiguration)curConfiguration).getActiveSession() != null;
        }
        return false;
    }

    protected void createAdditionTabs(CTabFolder configTabs) {
        if (DBWorkbench.isDistributed()) {
            this.createSecretManagerConfigTab(configTabs);
        }
    }

    private void createSecretManagerConfigTab(final CTabFolder parent) {
        Composite saTabGroup = new Composite((Composite)parent, 0);
        saTabGroup.setLayout((Layout)new FillLayout());
        final CTabItem saTab = new CTabItem(parent, 0);
        saTab.setText("Secret manager");
        saTab.setControl((Control)saTabGroup);
        this.smPage = new PrefPageAwsSecretManager();
        this.smPage.createControl(saTabGroup);
        parent.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (parent.getSelection() == saTab) {
                    AwsCloudConfigurationEditor.this.smPage.loadSettings(AwsCloudConfigurationEditor.this.getCurConfiguration());
                    parent.removeSelectionListener((SelectionListener)this);
                }
            }
        });
    }

    protected AuthModelAWSConfigurator createAuthConfigurator(Composite parent, Runnable propertyChangeListener) {
        AuthModelAWSConfigurator iamConfigurator = new AuthModelAWSConfigurator();
        iamConfigurator.setCloudProvided(false);
        iamConfigurator.setDatabaseConfiguration(false);
        iamConfigurator.createIAMAuthControls(parent, () -> {
            this.updateSessionActions();
            propertyChangeListener.run();
        }, false);
        iamConfigurator.initAuthTypes();
        return iamConfigurator;
    }

    protected AWSCloud createCloudFromConfiguration(AWSCloudConfiguration config) {
        return AWSCloudProvider.getInstance().createCloudFromConfiguration((CPCloudConfiguration)config);
    }

    public void createGeneralTab(CTabFolder parent, Runnable propertyChangeListener) {
        super.createGeneralTab(parent, propertyChangeListener);
    }

    protected void createExtraTabs(CTabFolder configTabs, Runnable propertyChangeListener) {
        this.createRegionsTab(configTabs, propertyChangeListener);
    }

    private void createRegionsTab(CTabFolder parent, final Runnable propertyChangeListener) {
        Composite regionsGroup = UIUtils.createComposite((Composite)parent, (int)1);
        Composite partComp = UIUtils.createComposite((Composite)regionsGroup, (int)2);
        partComp.setLayoutData((Object)new GridData(768));
        this.partitionCombo = UIUtils.createLabelCombo((Composite)partComp, (String)"Partition", (String)"AWS partition / global region", (int)12);
        for (PartitionMetadata partition : this.awsPartitions.values()) {
            this.partitionCombo.add(partition.name());
        }
        this.partitionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String partName = AwsCloudConfigurationEditor.this.partitionCombo.getText();
                for (PartitionMetadata pm : AwsCloudConfigurationEditor.this.awsPartitions.values()) {
                    if (!pm.name().equals(partName)) continue;
                    AwsCloudConfigurationEditor.this.selectedPartition = pm;
                    break;
                }
                AwsCloudConfigurationEditor.this.setSelectedRegions((AWSCloudConfiguration)AwsCloudConfigurationEditor.this.getCurConfiguration());
            }
        });
        final Tree regionTree = new Tree(regionsGroup, 65572);
        GridData gd = new GridData(1808);
        gd.heightHint = 300;
        gd.widthHint = 300;
        regionTree.setLayoutData((Object)gd);
        UIUtils.createTreeColumn((Tree)regionTree, (int)16384, (String)AwsCloudUIMessages.aws_configurator_tree_column_region_id);
        UIUtils.createTreeColumn((Tree)regionTree, (int)16384, (String)AwsCloudUIMessages.aws_configurator_tree_column_region_name);
        List allRegions = AWSCloudUtils.getAllRegions(null);
        final LinkedHashMap<String, List> regionMap = new LinkedHashMap<String, List>();
        for (Region region : allRegions) {
            List subRegions = regionMap.computeIfAbsent(AWSCloudUtils.getSuperRegion((Region)region), rl -> new ArrayList());
            subRegions.add(region);
        }
        this.regionTreeViewer = new ContainerCheckedTreeViewer(regionTree);
        this.regionTreeViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getElements(Object inputElement) {
                return regionMap.keySet().toArray(new String[0]);
            }

            public Object[] getChildren(Object parentElement) {
                return regionMap.getOrDefault(parentElement, Collections.emptyList()).toArray();
            }

            @Nullable
            public Object getParent(Object element) {
                if (element instanceof Region) {
                    Region region = (Region)element;
                    return AWSCloudUtils.getSuperRegion((Region)region);
                }
                return null;
            }

            public boolean hasChildren(Object element) {
                return element instanceof String;
            }
        });
        this.regionTreeViewer.setLabelProvider((IBaseLabelProvider)new CellLabelProvider(){

            /*
             * WARNING - void declaration
             */
            public void update(ViewerCell cell) {
                void region;
                Object element = cell.getElement();
                if (element instanceof String) {
                    String superRegion = (String)element;
                    cell.setText(superRegion);
                }
                if (!(element instanceof Region)) {
                    return;
                }
                Region region2 = (Region)element;
                if (cell.getColumnIndex() == 0) {
                    cell.setText(region.id());
                }
                if (cell.getColumnIndex() == 1) {
                    cell.setText(region.metadata().description());
                }
            }
        });
        this.regionTreeViewer.setFilters(new ViewerFilter[]{new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof Region) {
                    Region region = (Region)element;
                    RegionMetadata metadata = region.metadata();
                    if (metadata != null) {
                        return AwsCloudConfigurationEditor.this.selectedPartition == metadata.partition();
                    }
                    return false;
                }
                List regions = (List)regionMap.get(element);
                if (regions != null) {
                    for (Region region : regions) {
                        RegionMetadata metadata = region.metadata();
                        if (metadata == null || AwsCloudConfigurationEditor.this.selectedPartition != metadata.partition()) continue;
                        return true;
                    }
                }
                return false;
            }
        }});
        this.regionTreeViewer.setInput(regionMap);
        this.regionTreeViewer.expandAll();
        CTabItem regionsTab = new CTabItem(parent, 0);
        regionsTab.setText(AwsCloudUIMessages.aws_configurator_tab_item_regions);
        regionsTab.setControl((Control)regionsGroup);
        regionTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                propertyChangeListener.run();
            }
        });
        parent.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UIUtils.packColumns((Tree)regionTree, (boolean)true, null);
            }
        });
    }

    public void loadSettings(@NotNull AWSCloudConfiguration configuration) {
        super.loadSettings((CPCloudConfiguration)configuration);
        this.mainGroup.setRedraw(false);
        try {
            LinkedHashMap authProperties = new LinkedHashMap();
            AuthModelAWSAbstract.saveCredentialsToMap((AuthModelAWSCredentials)configuration.getDefaultCredentials(), authProperties);
            ((AuthModelAWSConfigurator)this.getDataSourceConfigurator()).loadIAMAuthSettings(authProperties);
            ((AuthModelAWSConfigurator)this.getDataSourceConfigurator()).updateControls();
        }
        finally {
            this.mainGroup.setRedraw(true);
        }
        this.selectedPartition = ((AWSCloudConfiguration)this.getCurConfiguration()).getRegionPartition();
        if (this.selectedPartition != null) {
            this.partitionCombo.setText(this.selectedPartition.name());
        } else {
            this.partitionCombo.select(0);
        }
        this.setSelectedRegions(configuration);
        this.updateSessionActions();
    }

    private void setSelectedRegions(@NotNull AWSCloudConfiguration configuration) {
        this.regionTreeViewer.refresh();
        this.regionTreeViewer.expandToLevel(2);
        Set<String> defaultRegions = Set.of(configuration.getDefaultRegions());
        this.regionTreeViewer.setCheckedElements(Arrays.stream(this.regionTreeViewer.getTree().getItems()).flatMap(item -> Arrays.stream(item.getItems())).filter(treeItem -> treeItem.getData() instanceof Region).map(treeItem -> (Region)treeItem.getData()).filter(region -> defaultRegions.contains(region.id())).toArray());
    }

    public void saveSettings(@NotNull AWSCloudConfiguration configuration) {
        super.saveSettings((CPCloudConfiguration)configuration);
        LinkedHashMap authProperties = new LinkedHashMap();
        ((AuthModelAWSConfigurator)this.getDataSourceConfigurator()).saveIAMAuthSettings(authProperties);
        AuthModelAWSAbstract.loadCredentialsFromMap((AuthModelAWSCredentials)configuration.getDefaultCredentials(), authProperties);
        String[] defaultRegions = (String[])Arrays.stream(this.regionTreeViewer.getCheckedElements()).filter(o -> o instanceof Region).map(o -> (Region)o).map(Region::id).toArray(String[]::new);
        configuration.setDefaultRegions(defaultRegions);
        if (this.smPage != null && this.smPage.getControl() != null) {
            this.smPage.performApply();
        }
    }

    public void resetSettings(@NotNull AWSCloudConfiguration configuration) {
    }
}

