/*
 * Decompiled with CFR 0.152.
 */
package io.github.jopenlibs.vault.api;

import io.github.jopenlibs.vault.VaultConfig;
import io.github.jopenlibs.vault.VaultException;
import io.github.jopenlibs.vault.rest.Rest;

public abstract class OperationsBase {
    protected final VaultConfig config;

    protected OperationsBase(VaultConfig config) {
        this.config = config;
    }

    protected <T> T retry(EndpointOperation<T> op) throws VaultException {
        return OperationsBase.retry(op, this.config.getMaxRetries(), this.config.getRetryIntervalMilliseconds());
    }

    static <T> T retry(EndpointOperation<T> op, int retryCount, long retryIntervalMs) throws VaultException {
        int attempt = 0;
        while (true) {
            try {
                return op.run(attempt);
            }
            catch (Exception e) {
                if (attempt < retryCount) {
                    ++attempt;
                    OperationsBase.sleep(retryIntervalMs);
                    continue;
                }
                if (e instanceof VaultException) {
                    throw (VaultException)e;
                }
                throw new VaultException(e);
            }
            break;
        }
    }

    protected Rest getRest() {
        return new Rest(this.config.getHttpClient());
    }

    private static void sleep(long delay) {
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static interface EndpointOperation<T> {
        public T run(int var1) throws Exception;
    }
}

