/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.sched.ui;

import com.dbeaver.ee.sched.ui.ScheduleTaskDialog;
import com.dbeaver.ee.sched.ui.TaskHandlerScheduleBase;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.task.DBTScheduler;
import org.jkiss.dbeaver.model.task.DBTSchedulerDescriptor;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskScheduleConfiguration;
import org.jkiss.dbeaver.runtime.DBWorkbench;

public class TaskHandlerScheduleEdit
extends TaskHandlerScheduleBase {
    @Override
    protected void execute(@NotNull ExecutionEvent event, @NotNull DBTTask task, @NotNull DBTSchedulerDescriptor descriptor, @NotNull DBTScheduler scheduler) throws DBException {
        if (!this.ensureCanSchedule()) {
            return;
        }
        DBTTaskScheduleConfiguration configuration = scheduler.getScheduledTaskConfiguration(task);
        if (configuration == null) {
            DBWorkbench.getPlatformUI().showError("Task schedule edit", "Task '" + task.getName() + "' schedule not found or invalid");
            return;
        }
        ScheduleTaskDialog dialog = new ScheduleTaskDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), task, descriptor, scheduler, configuration, true);
        if (dialog.open() == 0) {
            DBWorkbench.getPlatformUI().showNotification("Task scheduled", "Task '" + task.getName() + "' has been scheduled in " + scheduler.getSchedulerName(), false, null);
            this.refreshScheduledInfo(event);
        }
    }
}

