/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.azure.storage;

import com.azure.resourcemanager.storage.StorageManager;
import com.azure.resourcemanager.storage.fluent.models.ListContainerItemInner;
import com.azure.resourcemanager.storage.models.BlobContainer;
import com.azure.resourcemanager.storage.models.BlobContainers;
import com.azure.resourcemanager.storage.models.StorageAccount;
import com.dbeaver.cloud.azure.AzureCloud;
import com.dbeaver.cloud.azure.AzureCloudConfiguration;
import com.dbeaver.cloud.azure.AzureCloudSession;
import com.dbeaver.cloud.azure.storage.AZBFileSystemContainer;
import com.dbeaver.cloud.impl.AbstractCloud;
import com.dbeaver.cloud.model.AbstractCloudVirtualFileSystem;
import com.dbeaver.net.auth.azure.AuthModelAzureCredentials;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.auth.SMAuthSpace;
import org.jkiss.dbeaver.model.auth.SMSession;
import org.jkiss.dbeaver.model.auth.SMSessionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class AZBFileSystem
extends AbstractCloudVirtualFileSystem<AZBFileSystemContainer, AzureCloud> {
    private static final Log log = Log.getLog(AZBFileSystem.class);
    private static final Map<String, Boolean> directoryFlagCache = new HashMap<String, Boolean>();

    public AZBFileSystem(@NotNull AzureCloud cloud, @NotNull SMSessionContext sessionContext) {
        super((AbstractCloud)cloud, sessionContext);
    }

    public AzureCloud getCloud() {
        return (AzureCloud)this.cloud;
    }

    @NotNull
    public String getFileSystemDisplayName() {
        return ((AzureCloud)this.cloud).getName();
    }

    @NotNull
    public String getType() {
        return "azb";
    }

    public String getDescription() {
        return "Azure BLOB Storage for " + ((AzureCloud)this.cloud).getName();
    }

    public DBPImage getIcon() {
        return null;
    }

    @NotNull
    public String getId() {
        return ((AzureCloud)this.cloud).getCloudId();
    }

    @NotNull
    public String getProviderId() {
        return "azure-storage";
    }

    protected List<AZBFileSystemContainer> getBucketsFromCloudSystem(DBRProgressMonitor monitor) throws DBException {
        AuthModelAzureCredentials credentials = this.getAuthCredentials(monitor);
        if (credentials == null) {
            throw new DBException("Error of obtaining auth credential.");
        }
        StorageManager manager = (StorageManager)credentials.authenticateWithToken(monitor, (AuthModelAzureCredentials.AzureScopes)AuthModelAzureCredentials.Resource.MANAGEMENT, StorageManager::authenticate);
        if (manager == null) {
            throw new DBException("Error of accessing storage manager.");
        }
        List<AZBFileSystemContainer> containerList = Collections.synchronizedList(new ArrayList());
        BlobContainers blobContainers = manager.blobContainers();
        StorageAccount account = manager.storageAccounts().list().stream().filter(a -> a.name().equals(((AzureCloudConfiguration)((AzureCloud)this.cloud).getCloudConfiguration()).getStorageAccountId())).findFirst().orElse(null);
        if (account != null) {
            for (ListContainerItemInner cl : blobContainers.list(account.resourceGroupName(), account.name())) {
                String containerName = cl.name();
                BlobContainer blobContainer = blobContainers.get(account.resourceGroupName(), account.name(), containerName);
                containerList.add(new AZBFileSystemContainer(this, account, blobContainer));
            }
        }
        return containerList;
    }

    @NotNull
    public Path getPathByURI(@NotNull DBRProgressMonitor monitor, @NotNull URI uri) throws DBException {
        String containerName = CommonUtils.toString((Object)uri.getHost(), (String)uri.getAuthority());
        String uriPath = uri.getPath();
        int containerNameDiv = uriPath.indexOf(":/");
        if (containerNameDiv != -1) {
            containerName = uriPath.substring(0, containerNameDiv);
            if (containerName.startsWith("/")) {
                containerName = containerName.substring(1);
            }
            uriPath = uriPath.substring(containerNameDiv + 2);
        }
        if (CommonUtils.isEmpty((String)containerName)) {
            if (uriPath.startsWith("/") && uriPath.endsWith(":")) {
                containerName = uriPath.substring(1, uriPath.length() - 1);
                uriPath = "";
            } else {
                throw new DBException("Cannot extract storage container name from URI '" + String.valueOf(uri) + "'");
            }
        }
        List roots = this.getRootFolders(monitor);
        String finalContainerName = containerName;
        AZBFileSystemContainer container = roots.stream().filter(c -> c.getName().equals(finalContainerName)).findFirst().orElseThrow(() -> new DBException("Cannot find container '" + finalContainerName + "'"));
        Path rootPath = container.getRootPath(monitor);
        return CommonUtils.isEmpty((String)uriPath) ? rootPath : rootPath.resolve(uriPath);
    }

    public boolean isDirectory(Path path) {
        String pathString = path.toUri().toString();
        Boolean isDir = directoryFlagCache.get(pathString);
        if (isDir == null) {
            if (pathString.endsWith(":")) {
                isDir = true;
            } else {
                try {
                    isDir = Files.isDirectory(path, new LinkOption[0]);
                }
                catch (Exception e) {
                    log.debug((Object)"Error determining that file is a directory", (Throwable)e);
                    isDir = false;
                }
            }
            directoryFlagCache.put(pathString, isDir);
        }
        return isDir;
    }

    AuthModelAzureCredentials getAuthCredentials(@NotNull DBRProgressMonitor monitor) throws DBException {
        SMSession session = this.sessionContext.getSpaceSession(monitor, (SMAuthSpace)this.cloud, true);
        if (session instanceof AzureCloudSession) {
            AzureCloudSession s = (AzureCloudSession)session;
            return s.getCredentials();
        }
        throw new DBException("Can't obtain Azure cloud session from context");
    }
}

