/*
 * Decompiled with CFR 0.152.
 */
package com.informix.timeseries;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;

class IfxCalendar
extends GregorianCalendar {
    private static final long serialVersionUID = 1L;
    protected static final long MILL_IN_YEAR = 31536000000L;
    protected static final long MILL_IN_MONTH = 2592000000L;
    protected static final long MILL_IN_WEEK = 604800000L;
    protected static final long MILL_IN_DAY = 86400000L;
    protected static final long MILL_IN_HOUR = 3600000L;
    protected static final long MILL_IN_MINUTE = 60000L;
    protected static final long MILL_IN_SECOND = 1000L;
    protected static final int NANOSECOND = 6666;
    protected static final int NANOSECONDMIN = 0;
    protected static final int NANOSECONDMAX = 999999;
    private int nanoSeconds;
    private boolean nanoSecondsSet;

    IfxCalendar(Timestamp ts) {
        super.setTimeInMillis(ts.getTime());
        this.nanoSeconds = ts.getNanos();
    }

    IfxCalendar(Calendar calendar) {
        super.setTimeInMillis(calendar.getTimeInMillis());
        this.nanoSeconds = 0;
    }

    protected void setNanoSecond(int value) {
        this.nanoSeconds = value;
        this.nanoSecondsSet = true;
    }

    protected int getNanoSeconds() {
        return this.nanoSeconds;
    }

    protected boolean isNanoSecondsSet() {
        return this.nanoSecondsSet;
    }

    @Override
    public String toString() {
        Timestamp tStamp = new Timestamp(super.getTimeInMillis());
        tStamp.setNanos(this.nanoSeconds);
        return tStamp.toString();
    }

    protected String toCalString() {
        return super.toString();
    }

    protected Timestamp getTimestamp() {
        Timestamp returnVal = new Timestamp(super.getTimeInMillis());
        returnVal.setNanos(this.nanoSeconds);
        return returnVal;
    }

    @Override
    public void add(int fld, int amount) {
        switch (fld) {
            case 6666: {
                this.nanoSeconds += amount;
                break;
            }
            default: {
                super.add(fld, amount);
            }
        }
    }

    @Override
    public void roll(int fld, boolean up) {
        switch (fld) {
            case 6666: {
                break;
            }
            default: {
                super.roll(fld, up);
            }
        }
    }

    @Override
    public boolean after(Object cal) {
        if (!(cal instanceof IfxCalendar)) {
            return false;
        }
        return super.after(cal) && (this.nanoSeconds > ((IfxCalendar)cal).getNanoSeconds() || this.nanoSeconds == ((IfxCalendar)cal).getNanoSeconds());
    }

    @Override
    public boolean before(Object cal) {
        if (cal instanceof IfxCalendar) {
            return false;
        }
        return !super.before(cal) || this.getNanoSeconds() >= ((IfxCalendar)cal).getNanoSeconds();
    }

    @Override
    public int getGreatestMinimum(int fld) {
        switch (fld) {
            case 6666: {
                return 0;
            }
        }
        return super.getGreatestMinimum(fld);
    }

    @Override
    public int getLeastMaximum(int fld) {
        switch (fld) {
            case 6666: {
                return 999999;
            }
        }
        return super.getLeastMaximum(fld);
    }

    @Override
    public int getMaximum(int fld) {
        switch (fld) {
            case 6666: {
                return 999999;
            }
        }
        return super.getMaximum(fld);
    }

    @Override
    public int getMinimum(int fld) {
        switch (fld) {
            case 6666: {
                return 0;
            }
        }
        return super.getMinimum(fld);
    }

    protected int getDifference(IfxCalendar cal, int iVal) throws SQLException {
        int diffmonth;
        int msecStart;
        int secStart;
        int minStart;
        int hourStart;
        int dayStart;
        int monthStart;
        int yearStart;
        int msecEnd;
        int secEnd;
        int minEnd;
        int hourEnd;
        int dayEnd;
        int monthEnd;
        int yearEnd;
        double diff;
        long calDSTOffset = cal.get(16);
        long thisDSTOffset = this.get(16);
        if (this.before(cal)) {
            diff = thisDSTOffset == 0L ? (double)(cal.getTime().getTime() - this.getTime().getTime() + calDSTOffset) : (calDSTOffset == 0L ? (double)(cal.getTime().getTime() - this.getTime().getTime() - thisDSTOffset) : (double)(cal.getTime().getTime() - this.getTime().getTime()));
            yearEnd = cal.get(1);
            monthEnd = cal.get(2);
            dayEnd = cal.get(5);
            hourEnd = cal.get(11);
            minEnd = cal.get(12);
            secEnd = cal.get(13);
            msecEnd = cal.get(14);
            yearStart = this.get(1);
            monthStart = this.get(2);
            dayStart = this.get(5);
            hourStart = this.get(11);
            minStart = this.get(12);
            secStart = this.get(13);
            msecStart = this.get(14);
        } else {
            diff = calDSTOffset == 0L ? (double)(this.getTime().getTime() - cal.getTime().getTime() + thisDSTOffset) : (thisDSTOffset == 0L ? (double)(this.getTime().getTime() - cal.getTime().getTime() - calDSTOffset) : (double)(this.getTime().getTime() - cal.getTime().getTime()));
            yearStart = cal.get(1);
            monthStart = cal.get(2);
            dayStart = cal.get(5);
            hourStart = cal.get(11);
            minStart = cal.get(12);
            secStart = cal.get(13);
            msecStart = cal.get(14);
            yearEnd = this.get(1);
            monthEnd = this.get(2);
            dayEnd = this.get(5);
            hourEnd = this.get(11);
            minEnd = this.get(12);
            secEnd = this.get(13);
            msecEnd = this.get(14);
        }
        int diffyear = yearEnd - yearStart;
        if (yearEnd > yearStart && monthEnd < monthStart) {
            --diffyear;
        }
        if (yearEnd == yearStart) {
            diffmonth = monthEnd - monthStart;
            if (monthEnd > monthStart && dayEnd < dayStart || monthEnd > monthStart && dayEnd == dayStart && hourEnd < hourStart || monthEnd > monthStart && dayEnd == dayStart && hourEnd == hourStart && minEnd < minStart || monthEnd > monthStart && dayEnd == dayStart && hourEnd == hourStart && minEnd == minStart && secEnd < secStart || monthEnd > monthStart && dayEnd == dayStart && hourEnd == hourStart && minEnd == minStart && secEnd == secStart && msecEnd < msecStart) {
                --diffmonth;
            }
        } else {
            diffmonth = monthEnd - monthStart + diffyear * 12;
            if (dayEnd < dayStart || dayEnd == dayStart && hourEnd < hourStart || dayEnd == dayStart && hourEnd == hourStart && minEnd < minStart || dayEnd == dayStart && hourEnd == hourStart && minEnd == minStart && secEnd < secStart || dayEnd == dayStart && hourEnd == hourStart && minEnd == minStart && secEnd == secStart && msecEnd < msecStart) {
                --diffmonth;
            }
        }
        switch (iVal) {
            case 90: {
                return diffyear;
            }
            case 80: {
                return diffmonth;
            }
            case 70: {
                return (int)Math.rint(diff / 6.048E8);
            }
            case 60: {
                return (int)Math.rint(diff / 8.64E7);
            }
            case 50: {
                return (int)Math.rint(diff / 3600000.0);
            }
            case 40: {
                return (int)Math.rint(diff / 60000.0);
            }
            case 30: {
                return (int)Math.rint(diff / 1000.0);
            }
        }
        throw new SQLException("Error in getDifference!");
    }

    protected void addCalPatInterval(int iVal, int amount) throws SQLException {
        switch (iVal) {
            case 90: {
                super.add(1, amount);
                break;
            }
            case 80: {
                super.add(2, amount);
                break;
            }
            case 70: {
                super.add(3, amount);
                break;
            }
            case 60: {
                super.add(6, amount);
                break;
            }
            case 50: {
                super.add(10, amount);
                break;
            }
            case 40: {
                super.add(12, amount);
                break;
            }
            case 30: {
                super.add(13, amount);
                break;
            }
            default: {
                throw new SQLException("Interval not supported yet!");
            }
        }
    }
}

