/*
 * Decompiled with CFR 0.152.
 */
package com.informix.timeseries;

import com.informix.jdbc.IfmxUDTSQLInput;
import com.informix.jdbc.IfmxUDTSQLOutput;
import com.informix.timeseries.IfmxCalendarPatternUDT;
import com.informix.timeseries.JdbcUtilities;
import com.informix.timeseries.TimeSeriesTypeMap;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLOutput;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class IfmxCalendarPattern
implements IfmxCalendarPatternUDT,
SQLData {
    private static final String SQL_TYPE_NAME = "calendarpattern";
    private String name = null;
    private int length = 0;
    private int totalDuration = 0;
    private int onDuration = 0;
    private byte intervalTypeId;
    private byte[] spare = new byte[3];
    private int[] intervalData;

    public static final Builder builder() {
        return new Builder();
    }

    public IfmxCalendarPattern() {
    }

    public IfmxCalendarPattern(String calPatString) throws SQLException {
        this.calPatParseString(calPatString);
    }

    IfmxCalendarPattern(IfmxUDTSQLInput stream) throws SQLException {
        this.readFromStream(stream);
    }

    @Override
    public String getSQLTypeName() {
        return SQL_TYPE_NAME;
    }

    public synchronized String getName() {
        return this.name;
    }

    synchronized void setName(String name) {
        this.name = name;
    }

    @Override
    public void create(Connection connection) throws SQLException {
        if (this.name == null) {
            throw new SQLException("The calendar pattern name must not be null");
        }
        if (this.intervalData == null || this.intervalData.length == 0) {
            throw new SQLException("The calendar pattern must contain interval data");
        }
        String sql = "INSERT INTO calendarpatterns(cp_name,cp_pattern) VALUES (?,?)";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            try {
                preparedStatement = connection.prepareStatement("INSERT INTO calendarpatterns(cp_name,cp_pattern) VALUES (?,?)");
                preparedStatement.setString(1, this.name);
                preparedStatement.setObject(2, this);
                preparedStatement.execute();
                preparedStatement.getUpdateCount();
            }
            catch (SQLException e) {
                throw new SQLException(MessageFormat.format("Unable to create calendar pattern {0} {1}", this.name, this.toString()), e);
            }
        }
        finally {
            JdbcUtilities.closeWithoutException(resultSet);
            JdbcUtilities.closeWithoutException(preparedStatement);
        }
    }

    @Override
    public boolean delete(Connection connection) throws SQLException {
        if (this.name == null || this.name.trim().length() == 0) {
            throw new SQLException("The calendar pattern name must be specified when deleting it from a database");
        }
        return IfmxCalendarPattern.delete(connection, this.name);
    }

    public static boolean delete(Connection connection, String name) throws SQLException {
        if (name == null) {
            throw new SQLException("The calendar pattern name must not be null");
        }
        String sql = "DELETE FROM calendarpatterns WHERE cp_name = ?";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement("DELETE FROM calendarpatterns WHERE cp_name = ?");
            preparedStatement.setString(1, name);
            preparedStatement.execute();
            boolean bl = preparedStatement.getUpdateCount() > 0;
            return bl;
        }
        catch (SQLException e) {
            throw new SQLException(MessageFormat.format("Unable to delete calendar pattern {0}", name), e);
        }
        finally {
            JdbcUtilities.closeWithoutException(resultSet);
            JdbcUtilities.closeWithoutException(preparedStatement);
        }
    }

    public static boolean deleteAll(Connection connection) throws SQLException {
        String sql = "DELETE FROM calendarpatterns";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement("DELETE FROM calendarpatterns");
            preparedStatement.execute();
            boolean bl = preparedStatement.getUpdateCount() > 0;
            return bl;
        }
        catch (SQLException e) {
            throw new SQLException("Unable to delete all calendar patterns", e);
        }
        finally {
            JdbcUtilities.closeWithoutException(resultSet);
            JdbcUtilities.closeWithoutException(preparedStatement);
        }
    }

    @Override
    public boolean exists(Connection connection) throws SQLException {
        try {
            IfmxCalendarPattern other = IfmxCalendarPattern.getCalendarPattern(connection, this.getName());
            return this.equals(other);
        }
        catch (SQLException e) {
            if (e.getErrorCode() == -206) {
                return false;
            }
            throw e;
        }
    }

    public static IfmxCalendarPattern getCalendarPattern(Connection connection, String name) throws SQLException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block4: {
            IfmxCalendarPattern ifmxCalendarPattern;
            String sql = "SELECT cp_pattern FROM calendarpatterns WHERE cp_name = ?";
            preparedStatement = null;
            resultSet = null;
            try {
                preparedStatement = connection.prepareStatement("SELECT cp_pattern FROM calendarpatterns WHERE cp_name = ?");
                preparedStatement.setString(1, name);
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block4;
                IfmxCalendarPattern calendarPattern = (IfmxCalendarPattern)resultSet.getObject(1, TimeSeriesTypeMap.builder().build());
                calendarPattern.name = name;
                ifmxCalendarPattern = calendarPattern;
            }
            catch (SQLException e) {
                try {
                    throw new SQLException(MessageFormat.format("Unable to get calendar pattern {0}", name), e);
                }
                catch (Throwable throwable) {
                    JdbcUtilities.closeWithoutException(resultSet);
                    JdbcUtilities.closeWithoutException(preparedStatement);
                    throw throwable;
                }
            }
            JdbcUtilities.closeWithoutException(resultSet);
            JdbcUtilities.closeWithoutException(preparedStatement);
            return ifmxCalendarPattern;
        }
        JdbcUtilities.closeWithoutException(resultSet);
        JdbcUtilities.closeWithoutException(preparedStatement);
        return null;
    }

    public static Set<IfmxCalendarPattern> getCalendarPatterns(Connection connection) throws SQLException {
        HashSet<IfmxCalendarPattern> calendarPatterns = new HashSet<IfmxCalendarPattern>();
        String sql = "SELECT cp_name, cp_pattern FROM calendarpatterns";
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            try {
                statement = connection.createStatement();
                resultSet = statement.executeQuery("SELECT cp_name, cp_pattern FROM calendarpatterns");
                while (resultSet.next()) {
                    String name = resultSet.getString(1);
                    IfmxCalendarPattern calendarPattern = (IfmxCalendarPattern)resultSet.getObject(2, TimeSeriesTypeMap.builder().build());
                    calendarPattern.name = name;
                    calendarPatterns.add(calendarPattern);
                }
            }
            catch (SQLException e) {
                throw new SQLException("Unable to get calendars", e);
            }
        }
        catch (Throwable throwable) {
            JdbcUtilities.closeWithoutException(resultSet);
            JdbcUtilities.closeWithoutException(statement);
            throw throwable;
        }
        JdbcUtilities.closeWithoutException(resultSet);
        JdbcUtilities.closeWithoutException(statement);
        return calendarPatterns;
    }

    public String toCalendarPatternString() {
        int numElements = this.getNumberOfIntervals();
        StringBuilder sb = new StringBuilder();
        sb.append(String.valueOf('{'));
        int i = 0;
        while (i < numElements) {
            if (i > 0) {
                sb.append(String.valueOf(String.valueOf(',')) + String.valueOf(' '));
            }
            sb.append(this.intervalData[i] & 0xFFFFFFF);
            sb.append((this.intervalData[i] & 0x10000000) == 0x10000000 ? " on" : " off");
            ++i;
        }
        sb.append(String.valueOf('}'));
        sb.append(String.valueOf(','));
        sb.append(String.valueOf(' '));
        sb.append(this.getIntervalString(this.intervalTypeId));
        return sb.toString();
    }

    @Override
    public int getNumberOfIntervals() {
        return (this.length - 16) / 4;
    }

    public byte getIntervalTypeId() throws SQLException {
        return this.intervalTypeId;
    }

    public IntervalType getIntervalType() {
        return IntervalType.findByNumericalId(this.intervalTypeId);
    }

    public List<Interval> getIntervals() {
        LinkedList<Interval> intervals = new LinkedList<Interval>();
        int i = 0;
        while (i < this.intervalData.length) {
            Interval interval = new Interval(this.getIntervalDuration(i), this.isOn(i));
            intervals.add(interval);
            ++i;
        }
        return intervals;
    }

    public String getIntervalStr() throws SQLException {
        return this.getIntervalString(this.intervalTypeId);
    }

    @Override
    public int getIntervalDuration(int interval) {
        if (interval < 0 || interval >= this.intervalData.length) {
            throw new IllegalArgumentException(MessageFormat.format("The interval index must be between 0 and {1}, inclusive", this.intervalData.length - 1));
        }
        return this.intervalData[interval] & 0xFFFFFFF;
    }

    @Override
    public boolean isOn(int interval) {
        if (interval < 0 || interval >= this.intervalData.length) {
            throw new IllegalArgumentException(MessageFormat.format("The interval index must be between 0 and {1}, inclusive", this.intervalData.length - 1));
        }
        return (this.intervalData[interval] & 0x10000000) == 0x10000000;
    }

    @Override
    public void readSQL(SQLInput stream, String type) throws SQLException {
        if (!(stream instanceof IfmxUDTSQLInput)) {
            throw new SQLException(MessageFormat.format("The stream must be an instance of the interface {0}", IfmxUDTSQLInput.class.getName()));
        }
        this.readFromStream((IfmxUDTSQLInput)stream);
    }

    private void readFromStream(IfmxUDTSQLInput stream) throws SQLException {
        this.length = stream.readInt();
        this.totalDuration = stream.readInt();
        this.onDuration = stream.readInt();
        this.intervalTypeId = stream.readByte();
        this.spare = stream.readBytes(3);
        int numberOfIntervals = (this.length - 16) / 4;
        this.intervalData = new int[numberOfIntervals];
        int i = 0;
        while (i < numberOfIntervals) {
            this.intervalData[i] = stream.readInt();
            ++i;
        }
    }

    @Override
    public void writeSQL(SQLOutput stream) throws SQLException {
        this.writeToStream((IfmxUDTSQLOutput)stream);
    }

    protected int getLength() {
        return this.length;
    }

    @Override
    public int getTotalDuration() {
        return this.totalDuration;
    }

    @Override
    public int getOnDuration() {
        return this.onDuration;
    }

    @Override
    public int getOffDuration() {
        return this.totalDuration - this.onDuration;
    }

    protected int getValMask(int intervalIndex) throws SQLException {
        if (intervalIndex < 0 || intervalIndex >= this.intervalData.length) {
            throw new SQLException(MessageFormat.format("The calendar pattern interval index must be between 0 and {1}, inclusive", this.intervalData.length - 1));
        }
        return this.intervalData[intervalIndex] & 0xFFFFFFF;
    }

    private void writeToStream(IfmxUDTSQLOutput stream) throws SQLException {
        stream.writeInt(this.length);
        stream.writeInt(this.totalDuration);
        stream.writeInt(this.onDuration);
        stream.writeByte(this.intervalTypeId);
        stream.writeBytes(this.spare);
        int numberOfIntervals = (this.length - 16) / 4;
        int i = 0;
        while (i < numberOfIntervals) {
            stream.writeInt(this.intervalData[i]);
            ++i;
        }
    }

    private String getIntervalString(byte cPatInterval) {
        switch (cPatInterval) {
            case 30: {
                return "second";
            }
            case 40: {
                return "minute";
            }
            case 50: {
                return "hour";
            }
            case 60: {
                return "day";
            }
            case 70: {
                return "week";
            }
            case 80: {
                return "month";
            }
            case 90: {
                return "year";
            }
        }
        return "(unknown)";
    }

    private byte getIntervalValue(String cPatInterval) {
        if (cPatInterval.equalsIgnoreCase("second")) {
            return 30;
        }
        if (cPatInterval.equalsIgnoreCase("minute")) {
            return 40;
        }
        if (cPatInterval.equalsIgnoreCase("hour")) {
            return 50;
        }
        if (cPatInterval.equalsIgnoreCase("day")) {
            return 60;
        }
        if (cPatInterval.equalsIgnoreCase("week")) {
            return 70;
        }
        if (cPatInterval.equalsIgnoreCase("month")) {
            return 80;
        }
        if (cPatInterval.equalsIgnoreCase("year")) {
            return 90;
        }
        return -1;
    }

    private void calPatParseString(String calPatString) throws SQLException {
        int index = 0;
        int state = 2;
        boolean notEnd = true;
        boolean valid = false;
        ArrayList<IfxCalPatValues> cPatValues = new ArrayList<IfxCalPatValues>(5);
        this.totalDuration = 0;
        this.onDuration = 0;
        this.intervalTypeId = (byte)-1;
        this.spare = new byte[3];
        String workingStr = calPatString.trim();
        int patLength = workingStr.length();
        char curChar = workingStr.charAt(index);
        if (curChar != '{') {
            throw new SQLException("Unexpected character in CalendarPattern string!");
        }
        ++index;
        while (notEnd) {
            int numStart;
            if (!Character.isDigit(workingStr.charAt(index))) {
                throw new SQLException("Unexpected character in CalendarPattern string!");
            }
            int numEnd = numStart = index++;
            while (index < patLength) {
                if (!Character.isDigit(workingStr.charAt(index))) {
                    numEnd = index;
                    break;
                }
                ++index;
            }
            while (index < patLength) {
                curChar = Character.toLowerCase(workingStr.charAt(index));
                if (curChar == ' ') {
                    if (state != 3) {
                        state = 3;
                    } else if (state == 3) {
                        throw new SQLException("Unexpected character in CalendarPattern string!");
                    }
                } else if (curChar == 'o' && state != 0 && state != 1) {
                    state = 0;
                } else if (curChar == 'n' && state == 0) {
                    valid = true;
                    state = 4;
                } else if (curChar == 'f') {
                    if (state != 1) {
                        state = 1;
                    } else if (state == 1) {
                        valid = false;
                        state = 4;
                    }
                }
                if (state == 4) {
                    ++index;
                    break;
                }
                ++index;
            }
            IfxCalPatValues cPatValue = new IfxCalPatValues((int)(Integer.decode(workingStr.substring(numStart, numEnd)) & 0xFFFFFFF), valid);
            cPatValues.add(cPatValue);
            if (workingStr.charAt(index) == '}') {
                notEnd = false;
                if (workingStr.charAt(++index) == ',') {
                    ++index;
                }
                if (workingStr.charAt(index) != ' ') continue;
                ++index;
                continue;
            }
            if (workingStr.charAt(index) == ',') {
                if (workingStr.charAt(++index) != ' ') continue;
                ++index;
                continue;
            }
            throw new SQLException("Unexpected character in CalendarPattern string!");
        }
        if (workingStr.charAt(index) == ' ') {
            ++index;
        }
        this.intervalTypeId = this.getIntervalValue(workingStr.substring(index, patLength));
        if (this.intervalTypeId == -1) {
            throw new SQLException("Unexpected character in CalendarPattern string!");
        }
        cPatValues.size();
        this.intervalData = new int[cPatValues.size()];
        this.length = 16 + 4 * cPatValues.size();
        index = 0;
        while (index < cPatValues.size()) {
            this.totalDuration += ((IfxCalPatValues)cPatValues.get(index)).numIntervals();
            if (((IfxCalPatValues)cPatValues.get(index)).intervalValid()) {
                this.onDuration += ((IfxCalPatValues)cPatValues.get(index)).numIntervals();
                this.intervalData[index] = ((IfxCalPatValues)cPatValues.get(index)).numIntervals() | 0x10000000;
            } else {
                this.intervalData[index] = ((IfxCalPatValues)cPatValues.get(index)).numIntervals();
            }
            ++index;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.intervalData);
        result = 31 * result + this.intervalTypeId;
        result = 31 * result + this.length;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + this.onDuration;
        result = 31 * result + Arrays.hashCode(this.spare);
        result = 31 * result + this.totalDuration;
        return result;
    }

    public boolean equals(Object obj) {
        return this.equals(obj, false);
    }

    @Override
    public boolean equals(Object obj, boolean skipName) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IfmxCalendarPattern other = (IfmxCalendarPattern)obj;
        if (!Arrays.equals(this.intervalData, other.intervalData)) {
            return false;
        }
        if (this.intervalTypeId != other.intervalTypeId) {
            return false;
        }
        if (this.length != other.length) {
            return false;
        }
        if (!skipName && (this.name == null ? other.name != null : !this.name.equals(other.name))) {
            return false;
        }
        if (this.onDuration != other.onDuration) {
            return false;
        }
        if (!Arrays.equals(this.spare, other.spare)) {
            return false;
        }
        return this.totalDuration == other.totalDuration;
    }

    public String toString() {
        StringBuilder builder2 = new StringBuilder();
        builder2.append("IfmxCalendarPattern [name=");
        builder2.append(this.name);
        builder2.append(", intervalTypeId=");
        builder2.append(this.intervalTypeId);
        builder2.append(", intervalData=");
        builder2.append(Arrays.toString(this.intervalData));
        builder2.append(", length=");
        builder2.append(this.length);
        builder2.append(", totalDuration=");
        builder2.append(this.totalDuration);
        builder2.append(", onDuration=");
        builder2.append(this.onDuration);
        builder2.append(", spare=");
        builder2.append(Arrays.toString(this.spare));
        builder2.append(']');
        return builder2.toString();
    }

    public static final class Builder {
        private String name = null;
        private IntervalType intervalType;
        private final List<Interval> intervals = new LinkedList<Interval>();

        public Builder addInterval(Interval interval) {
            this.intervals.add(interval);
            return this;
        }

        public Builder addIntervals(List<Interval> newIntervals) {
            this.intervals.addAll(newIntervals);
            return this;
        }

        public Builder intervalType(IntervalType intervalType) {
            this.intervalType = intervalType;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public IfmxCalendarPattern build() {
            if (this.intervalType == null) {
                throw new IllegalArgumentException("the calendar pattern interval type must not be null");
            }
            if (this.intervals.size() == 0) {
                throw new IllegalArgumentException("the calendar pattern must consist of at least one interval");
            }
            IfmxCalendarPattern result = new IfmxCalendarPattern();
            result.name = this.name;
            result.intervalTypeId = this.intervalType.getNumericalId();
            result.length = this.intervals.size() * 4 + 16;
            result.intervalData = new int[this.intervals.size()];
            int i = 0;
            while (i < this.intervals.size()) {
                Interval interval = this.intervals.get(i);
                IfmxCalendarPattern ifmxCalendarPattern = result;
                ifmxCalendarPattern.totalDuration = ifmxCalendarPattern.totalDuration + interval.getDuration();
                if (interval.isOn()) {
                    ((IfmxCalendarPattern)result).intervalData[i] = interval.getDuration() | 0x10000000;
                    IfmxCalendarPattern ifmxCalendarPattern2 = result;
                    ifmxCalendarPattern2.onDuration = ifmxCalendarPattern2.onDuration + interval.getDuration();
                } else {
                    ((IfmxCalendarPattern)result).intervalData[i] = interval.getDuration();
                }
                ++i;
            }
            return result;
        }
    }

    private static class IfxCalPatValues {
        private final int numIntervals;
        private final boolean intervalValid;

        private IfxCalPatValues(int numIntervals, boolean intervalValid) {
            this.numIntervals = numIntervals;
            this.intervalValid = intervalValid;
        }

        protected int numIntervals() {
            return this.numIntervals;
        }

        protected boolean intervalValid() {
            return this.intervalValid;
        }
    }

    public static final class Interval {
        private final int duration;
        private final boolean on;

        public Interval(int duration, boolean on) {
            if (duration < 0) {
                throw new IllegalArgumentException(MessageFormat.format("the interval duration must be a non-negative value (was {0})", duration));
            }
            this.duration = duration;
            this.on = on;
        }

        public int getDuration() {
            return this.duration;
        }

        public boolean isOn() {
            return this.on;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.duration;
            result = 31 * result + (this.on ? 1231 : 1237);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Interval other = (Interval)obj;
            if (this.duration != other.duration) {
                return false;
            }
            return this.on == other.on;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Interval [duration=");
            builder.append(this.duration);
            builder.append(", on=");
            builder.append(this.on);
            builder.append(']');
            return builder.toString();
        }
    }

    public static enum IntervalType {
        SECOND(30, "second"),
        MINUTE(40, "minute"),
        HOUR(50, "hour"),
        DAY(60, "day"),
        WEEK(70, "week"),
        MONTH(80, "month"),
        YEAR(90, "year");

        private final byte numericalId;
        private final String stringId;

        private IntervalType(byte numericalId, String stringId) {
            this.numericalId = numericalId;
            this.stringId = stringId;
        }

        public byte getNumericalId() {
            return this.numericalId;
        }

        public String getStringId() {
            return this.stringId;
        }

        public static IntervalType findByNumericalId(byte id) {
            IntervalType[] intervalTypeArray = IntervalType.values();
            int n = intervalTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IntervalType it = intervalTypeArray[n2];
                if (it.numericalId == id) {
                    return it;
                }
                ++n2;
            }
            return null;
        }

        public static IntervalType findByStringId(String id) {
            IntervalType[] intervalTypeArray = IntervalType.values();
            int n = intervalTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IntervalType it = intervalTypeArray[n2];
                if (it.stringId.equals(id)) {
                    return it;
                }
                ++n2;
            }
            return null;
        }
    }
}

