/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrock.BedrockClient;
import software.amazon.awssdk.services.bedrock.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyTestResult;
import software.amazon.awssdk.services.bedrock.model.ListAutomatedReasoningPolicyTestResultsRequest;
import software.amazon.awssdk.services.bedrock.model.ListAutomatedReasoningPolicyTestResultsResponse;

public class ListAutomatedReasoningPolicyTestResultsIterable
implements SdkIterable<ListAutomatedReasoningPolicyTestResultsResponse> {
    private final BedrockClient client;
    private final ListAutomatedReasoningPolicyTestResultsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAutomatedReasoningPolicyTestResultsIterable(BedrockClient client, ListAutomatedReasoningPolicyTestResultsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAutomatedReasoningPolicyTestResultsResponseFetcher();
    }

    public Iterator<ListAutomatedReasoningPolicyTestResultsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AutomatedReasoningPolicyTestResult> testResults() {
        Function<ListAutomatedReasoningPolicyTestResultsResponse, Iterator> getIterator = response -> {
            if (response != null && response.testResults() != null) {
                return response.testResults().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAutomatedReasoningPolicyTestResultsResponseFetcher
    implements SyncPageFetcher<ListAutomatedReasoningPolicyTestResultsResponse> {
        private ListAutomatedReasoningPolicyTestResultsResponseFetcher() {
        }

        public boolean hasNextPage(ListAutomatedReasoningPolicyTestResultsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAutomatedReasoningPolicyTestResultsResponse nextPage(ListAutomatedReasoningPolicyTestResultsResponse previousPage) {
            if (previousPage == null) {
                return ListAutomatedReasoningPolicyTestResultsIterable.this.client.listAutomatedReasoningPolicyTestResults(ListAutomatedReasoningPolicyTestResultsIterable.this.firstRequest);
            }
            return ListAutomatedReasoningPolicyTestResultsIterable.this.client.listAutomatedReasoningPolicyTestResults((ListAutomatedReasoningPolicyTestResultsRequest)((Object)ListAutomatedReasoningPolicyTestResultsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

