/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrock.model.BedrockResponse;
import software.amazon.awssdk.services.bedrock.model.ProvisionedModelSummariesCopier;
import software.amazon.awssdk.services.bedrock.model.ProvisionedModelSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListProvisionedModelThroughputsResponse
extends BedrockResponse
implements ToCopyableBuilder<Builder, ListProvisionedModelThroughputsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListProvisionedModelThroughputsResponse.getter(ListProvisionedModelThroughputsResponse::nextToken)).setter(ListProvisionedModelThroughputsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<ProvisionedModelSummary>> PROVISIONED_MODEL_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("provisionedModelSummaries").getter(ListProvisionedModelThroughputsResponse.getter(ListProvisionedModelThroughputsResponse::provisionedModelSummaries)).setter(ListProvisionedModelThroughputsResponse.setter(Builder::provisionedModelSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisionedModelSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProvisionedModelSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, PROVISIONED_MODEL_SUMMARIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListProvisionedModelThroughputsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<ProvisionedModelSummary> provisionedModelSummaries;

    private ListProvisionedModelThroughputsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.provisionedModelSummaries = builder.provisionedModelSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasProvisionedModelSummaries() {
        return this.provisionedModelSummaries != null && !(this.provisionedModelSummaries instanceof SdkAutoConstructList);
    }

    public final List<ProvisionedModelSummary> provisionedModelSummaries() {
        return this.provisionedModelSummaries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProvisionedModelSummaries() ? this.provisionedModelSummaries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProvisionedModelThroughputsResponse)) {
            return false;
        }
        ListProvisionedModelThroughputsResponse other = (ListProvisionedModelThroughputsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasProvisionedModelSummaries() == other.hasProvisionedModelSummaries() && Objects.equals(this.provisionedModelSummaries(), other.provisionedModelSummaries());
    }

    public final String toString() {
        return ToString.builder((String)"ListProvisionedModelThroughputsResponse").add("NextToken", (Object)this.nextToken()).add("ProvisionedModelSummaries", this.hasProvisionedModelSummaries() ? this.provisionedModelSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "provisionedModelSummaries": {
                return Optional.ofNullable(clazz.cast(this.provisionedModelSummaries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("provisionedModelSummaries", PROVISIONED_MODEL_SUMMARIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListProvisionedModelThroughputsResponse, T> g) {
        return obj -> g.apply((ListProvisionedModelThroughputsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ProvisionedModelSummary> provisionedModelSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListProvisionedModelThroughputsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.provisionedModelSummaries(model.provisionedModelSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ProvisionedModelSummary.Builder> getProvisionedModelSummaries() {
            List<ProvisionedModelSummary.Builder> result = ProvisionedModelSummariesCopier.copyToBuilder(this.provisionedModelSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProvisionedModelSummaries(Collection<ProvisionedModelSummary.BuilderImpl> provisionedModelSummaries) {
            this.provisionedModelSummaries = ProvisionedModelSummariesCopier.copyFromBuilder(provisionedModelSummaries);
        }

        @Override
        public final Builder provisionedModelSummaries(Collection<ProvisionedModelSummary> provisionedModelSummaries) {
            this.provisionedModelSummaries = ProvisionedModelSummariesCopier.copy(provisionedModelSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisionedModelSummaries(ProvisionedModelSummary ... provisionedModelSummaries) {
            this.provisionedModelSummaries(Arrays.asList(provisionedModelSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisionedModelSummaries(Consumer<ProvisionedModelSummary.Builder> ... provisionedModelSummaries) {
            this.provisionedModelSummaries(Stream.of(provisionedModelSummaries).map(c -> (ProvisionedModelSummary)((ProvisionedModelSummary.Builder)ProvisionedModelSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListProvisionedModelThroughputsResponse build() {
            return new ListProvisionedModelThroughputsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListProvisionedModelThroughputsResponse> {
        public Builder nextToken(String var1);

        public Builder provisionedModelSummaries(Collection<ProvisionedModelSummary> var1);

        public Builder provisionedModelSummaries(ProvisionedModelSummary ... var1);

        public Builder provisionedModelSummaries(Consumer<ProvisionedModelSummary.Builder> ... var1);
    }
}

