/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyTestListCopier;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyTestResult;
import software.amazon.awssdk.services.bedrock.model.BedrockResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAutomatedReasoningPolicyTestResultsResponse
extends BedrockResponse
implements ToCopyableBuilder<Builder, ListAutomatedReasoningPolicyTestResultsResponse> {
    private static final SdkField<List<AutomatedReasoningPolicyTestResult>> TEST_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("testResults").getter(ListAutomatedReasoningPolicyTestResultsResponse.getter(ListAutomatedReasoningPolicyTestResultsResponse::testResults)).setter(ListAutomatedReasoningPolicyTestResultsResponse.setter(Builder::testResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testResults").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AutomatedReasoningPolicyTestResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAutomatedReasoningPolicyTestResultsResponse.getter(ListAutomatedReasoningPolicyTestResultsResponse::nextToken)).setter(ListAutomatedReasoningPolicyTestResultsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAutomatedReasoningPolicyTestResultsResponse.memberNameToFieldInitializer();
    private final List<AutomatedReasoningPolicyTestResult> testResults;
    private final String nextToken;

    private ListAutomatedReasoningPolicyTestResultsResponse(BuilderImpl builder) {
        super(builder);
        this.testResults = builder.testResults;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasTestResults() {
        return this.testResults != null && !(this.testResults instanceof SdkAutoConstructList);
    }

    public final List<AutomatedReasoningPolicyTestResult> testResults() {
        return this.testResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTestResults() ? this.testResults() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAutomatedReasoningPolicyTestResultsResponse)) {
            return false;
        }
        ListAutomatedReasoningPolicyTestResultsResponse other = (ListAutomatedReasoningPolicyTestResultsResponse)((Object)obj);
        return this.hasTestResults() == other.hasTestResults() && Objects.equals(this.testResults(), other.testResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAutomatedReasoningPolicyTestResultsResponse").add("TestResults", this.hasTestResults() ? this.testResults() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "testResults": {
                return Optional.ofNullable(clazz.cast(this.testResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("testResults", TEST_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAutomatedReasoningPolicyTestResultsResponse, T> g) {
        return obj -> g.apply((ListAutomatedReasoningPolicyTestResultsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockResponse.BuilderImpl
    implements Builder {
        private List<AutomatedReasoningPolicyTestResult> testResults = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAutomatedReasoningPolicyTestResultsResponse model) {
            super(model);
            this.testResults(model.testResults);
            this.nextToken(model.nextToken);
        }

        public final List<AutomatedReasoningPolicyTestResult.Builder> getTestResults() {
            List<AutomatedReasoningPolicyTestResult.Builder> result = AutomatedReasoningPolicyTestListCopier.copyToBuilder(this.testResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTestResults(Collection<AutomatedReasoningPolicyTestResult.BuilderImpl> testResults) {
            this.testResults = AutomatedReasoningPolicyTestListCopier.copyFromBuilder(testResults);
        }

        @Override
        public final Builder testResults(Collection<AutomatedReasoningPolicyTestResult> testResults) {
            this.testResults = AutomatedReasoningPolicyTestListCopier.copy(testResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder testResults(AutomatedReasoningPolicyTestResult ... testResults) {
            this.testResults(Arrays.asList(testResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder testResults(Consumer<AutomatedReasoningPolicyTestResult.Builder> ... testResults) {
            this.testResults(Stream.of(testResults).map(c -> (AutomatedReasoningPolicyTestResult)((AutomatedReasoningPolicyTestResult.Builder)AutomatedReasoningPolicyTestResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAutomatedReasoningPolicyTestResultsResponse build() {
            return new ListAutomatedReasoningPolicyTestResultsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAutomatedReasoningPolicyTestResultsResponse> {
        public Builder testResults(Collection<AutomatedReasoningPolicyTestResult> var1);

        public Builder testResults(AutomatedReasoningPolicyTestResult ... var1);

        public Builder testResults(Consumer<AutomatedReasoningPolicyTestResult.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

