/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningCheckFinding;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningCheckFindingListCopier;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningCheckResult;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyTestCase;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyTestRunResult;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyTestRunStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutomatedReasoningPolicyTestResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutomatedReasoningPolicyTestResult> {
    private static final SdkField<AutomatedReasoningPolicyTestCase> TEST_CASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("testCase").getter(AutomatedReasoningPolicyTestResult.getter(AutomatedReasoningPolicyTestResult::testCase)).setter(AutomatedReasoningPolicyTestResult.setter(Builder::testCase)).constructor(AutomatedReasoningPolicyTestCase::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testCase").build()}).build();
    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyArn").getter(AutomatedReasoningPolicyTestResult.getter(AutomatedReasoningPolicyTestResult::policyArn)).setter(AutomatedReasoningPolicyTestResult.setter(Builder::policyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyArn").build()}).build();
    private static final SdkField<String> TEST_RUN_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("testRunStatus").getter(AutomatedReasoningPolicyTestResult.getter(AutomatedReasoningPolicyTestResult::testRunStatusAsString)).setter(AutomatedReasoningPolicyTestResult.setter(Builder::testRunStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testRunStatus").build()}).build();
    private static final SdkField<List<AutomatedReasoningCheckFinding>> TEST_FINDINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("testFindings").getter(AutomatedReasoningPolicyTestResult.getter(AutomatedReasoningPolicyTestResult::testFindings)).setter(AutomatedReasoningPolicyTestResult.setter(Builder::testFindings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testFindings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AutomatedReasoningCheckFinding::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TEST_RUN_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("testRunResult").getter(AutomatedReasoningPolicyTestResult.getter(AutomatedReasoningPolicyTestResult::testRunResultAsString)).setter(AutomatedReasoningPolicyTestResult.setter(Builder::testRunResult)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testRunResult").build()}).build();
    private static final SdkField<String> AGGREGATED_TEST_FINDINGS_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("aggregatedTestFindingsResult").getter(AutomatedReasoningPolicyTestResult.getter(AutomatedReasoningPolicyTestResult::aggregatedTestFindingsResultAsString)).setter(AutomatedReasoningPolicyTestResult.setter(Builder::aggregatedTestFindingsResult)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregatedTestFindingsResult").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(AutomatedReasoningPolicyTestResult.getter(AutomatedReasoningPolicyTestResult::updatedAt)).setter(AutomatedReasoningPolicyTestResult.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_CASE_FIELD, POLICY_ARN_FIELD, TEST_RUN_STATUS_FIELD, TEST_FINDINGS_FIELD, TEST_RUN_RESULT_FIELD, AGGREGATED_TEST_FINDINGS_RESULT_FIELD, UPDATED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AutomatedReasoningPolicyTestResult.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final AutomatedReasoningPolicyTestCase testCase;
    private final String policyArn;
    private final String testRunStatus;
    private final List<AutomatedReasoningCheckFinding> testFindings;
    private final String testRunResult;
    private final String aggregatedTestFindingsResult;
    private final Instant updatedAt;

    private AutomatedReasoningPolicyTestResult(BuilderImpl builder) {
        this.testCase = builder.testCase;
        this.policyArn = builder.policyArn;
        this.testRunStatus = builder.testRunStatus;
        this.testFindings = builder.testFindings;
        this.testRunResult = builder.testRunResult;
        this.aggregatedTestFindingsResult = builder.aggregatedTestFindingsResult;
        this.updatedAt = builder.updatedAt;
    }

    public final AutomatedReasoningPolicyTestCase testCase() {
        return this.testCase;
    }

    public final String policyArn() {
        return this.policyArn;
    }

    public final AutomatedReasoningPolicyTestRunStatus testRunStatus() {
        return AutomatedReasoningPolicyTestRunStatus.fromValue(this.testRunStatus);
    }

    public final String testRunStatusAsString() {
        return this.testRunStatus;
    }

    public final boolean hasTestFindings() {
        return this.testFindings != null && !(this.testFindings instanceof SdkAutoConstructList);
    }

    public final List<AutomatedReasoningCheckFinding> testFindings() {
        return this.testFindings;
    }

    public final AutomatedReasoningPolicyTestRunResult testRunResult() {
        return AutomatedReasoningPolicyTestRunResult.fromValue(this.testRunResult);
    }

    public final String testRunResultAsString() {
        return this.testRunResult;
    }

    public final AutomatedReasoningCheckResult aggregatedTestFindingsResult() {
        return AutomatedReasoningCheckResult.fromValue(this.aggregatedTestFindingsResult);
    }

    public final String aggregatedTestFindingsResultAsString() {
        return this.aggregatedTestFindingsResult;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.testCase());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.testRunStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTestFindings() ? this.testFindings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.testRunResultAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregatedTestFindingsResultAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedReasoningPolicyTestResult)) {
            return false;
        }
        AutomatedReasoningPolicyTestResult other = (AutomatedReasoningPolicyTestResult)obj;
        return Objects.equals(this.testCase(), other.testCase()) && Objects.equals(this.policyArn(), other.policyArn()) && Objects.equals(this.testRunStatusAsString(), other.testRunStatusAsString()) && this.hasTestFindings() == other.hasTestFindings() && Objects.equals(this.testFindings(), other.testFindings()) && Objects.equals(this.testRunResultAsString(), other.testRunResultAsString()) && Objects.equals(this.aggregatedTestFindingsResultAsString(), other.aggregatedTestFindingsResultAsString()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"AutomatedReasoningPolicyTestResult").add("TestCase", (Object)this.testCase()).add("PolicyArn", (Object)this.policyArn()).add("TestRunStatus", (Object)this.testRunStatusAsString()).add("TestFindings", this.hasTestFindings() ? this.testFindings() : null).add("TestRunResult", (Object)this.testRunResultAsString()).add("AggregatedTestFindingsResult", (Object)this.aggregatedTestFindingsResultAsString()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "testCase": {
                return Optional.ofNullable(clazz.cast(this.testCase()));
            }
            case "policyArn": {
                return Optional.ofNullable(clazz.cast(this.policyArn()));
            }
            case "testRunStatus": {
                return Optional.ofNullable(clazz.cast(this.testRunStatusAsString()));
            }
            case "testFindings": {
                return Optional.ofNullable(clazz.cast(this.testFindings()));
            }
            case "testRunResult": {
                return Optional.ofNullable(clazz.cast(this.testRunResultAsString()));
            }
            case "aggregatedTestFindingsResult": {
                return Optional.ofNullable(clazz.cast(this.aggregatedTestFindingsResultAsString()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("testCase", TEST_CASE_FIELD);
        map.put("policyArn", POLICY_ARN_FIELD);
        map.put("testRunStatus", TEST_RUN_STATUS_FIELD);
        map.put("testFindings", TEST_FINDINGS_FIELD);
        map.put("testRunResult", TEST_RUN_RESULT_FIELD);
        map.put("aggregatedTestFindingsResult", AGGREGATED_TEST_FINDINGS_RESULT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomatedReasoningPolicyTestResult, T> g) {
        return obj -> g.apply((AutomatedReasoningPolicyTestResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AutomatedReasoningPolicyTestCase testCase;
        private String policyArn;
        private String testRunStatus;
        private List<AutomatedReasoningCheckFinding> testFindings = DefaultSdkAutoConstructList.getInstance();
        private String testRunResult;
        private String aggregatedTestFindingsResult;
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomatedReasoningPolicyTestResult model) {
            this.testCase(model.testCase);
            this.policyArn(model.policyArn);
            this.testRunStatus(model.testRunStatus);
            this.testFindings(model.testFindings);
            this.testRunResult(model.testRunResult);
            this.aggregatedTestFindingsResult(model.aggregatedTestFindingsResult);
            this.updatedAt(model.updatedAt);
        }

        public final AutomatedReasoningPolicyTestCase.Builder getTestCase() {
            return this.testCase != null ? this.testCase.toBuilder() : null;
        }

        public final void setTestCase(AutomatedReasoningPolicyTestCase.BuilderImpl testCase) {
            this.testCase = testCase != null ? testCase.build() : null;
        }

        @Override
        public final Builder testCase(AutomatedReasoningPolicyTestCase testCase) {
            this.testCase = testCase;
            return this;
        }

        public final String getPolicyArn() {
            return this.policyArn;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final String getTestRunStatus() {
            return this.testRunStatus;
        }

        public final void setTestRunStatus(String testRunStatus) {
            this.testRunStatus = testRunStatus;
        }

        @Override
        public final Builder testRunStatus(String testRunStatus) {
            this.testRunStatus = testRunStatus;
            return this;
        }

        @Override
        public final Builder testRunStatus(AutomatedReasoningPolicyTestRunStatus testRunStatus) {
            this.testRunStatus(testRunStatus == null ? null : testRunStatus.toString());
            return this;
        }

        public final List<AutomatedReasoningCheckFinding.Builder> getTestFindings() {
            List<AutomatedReasoningCheckFinding.Builder> result = AutomatedReasoningCheckFindingListCopier.copyToBuilder(this.testFindings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTestFindings(Collection<AutomatedReasoningCheckFinding.BuilderImpl> testFindings) {
            this.testFindings = AutomatedReasoningCheckFindingListCopier.copyFromBuilder(testFindings);
        }

        @Override
        public final Builder testFindings(Collection<AutomatedReasoningCheckFinding> testFindings) {
            this.testFindings = AutomatedReasoningCheckFindingListCopier.copy(testFindings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder testFindings(AutomatedReasoningCheckFinding ... testFindings) {
            this.testFindings(Arrays.asList(testFindings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder testFindings(Consumer<AutomatedReasoningCheckFinding.Builder> ... testFindings) {
            this.testFindings(Stream.of(testFindings).map(c -> (AutomatedReasoningCheckFinding)((AutomatedReasoningCheckFinding.Builder)AutomatedReasoningCheckFinding.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getTestRunResult() {
            return this.testRunResult;
        }

        public final void setTestRunResult(String testRunResult) {
            this.testRunResult = testRunResult;
        }

        @Override
        public final Builder testRunResult(String testRunResult) {
            this.testRunResult = testRunResult;
            return this;
        }

        @Override
        public final Builder testRunResult(AutomatedReasoningPolicyTestRunResult testRunResult) {
            this.testRunResult(testRunResult == null ? null : testRunResult.toString());
            return this;
        }

        public final String getAggregatedTestFindingsResult() {
            return this.aggregatedTestFindingsResult;
        }

        public final void setAggregatedTestFindingsResult(String aggregatedTestFindingsResult) {
            this.aggregatedTestFindingsResult = aggregatedTestFindingsResult;
        }

        @Override
        public final Builder aggregatedTestFindingsResult(String aggregatedTestFindingsResult) {
            this.aggregatedTestFindingsResult = aggregatedTestFindingsResult;
            return this;
        }

        @Override
        public final Builder aggregatedTestFindingsResult(AutomatedReasoningCheckResult aggregatedTestFindingsResult) {
            this.aggregatedTestFindingsResult(aggregatedTestFindingsResult == null ? null : aggregatedTestFindingsResult.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public AutomatedReasoningPolicyTestResult build() {
            return new AutomatedReasoningPolicyTestResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutomatedReasoningPolicyTestResult> {
        public Builder testCase(AutomatedReasoningPolicyTestCase var1);

        default public Builder testCase(Consumer<AutomatedReasoningPolicyTestCase.Builder> testCase) {
            return this.testCase((AutomatedReasoningPolicyTestCase)((AutomatedReasoningPolicyTestCase.Builder)AutomatedReasoningPolicyTestCase.builder().applyMutation(testCase)).build());
        }

        public Builder policyArn(String var1);

        public Builder testRunStatus(String var1);

        public Builder testRunStatus(AutomatedReasoningPolicyTestRunStatus var1);

        public Builder testFindings(Collection<AutomatedReasoningCheckFinding> var1);

        public Builder testFindings(AutomatedReasoningCheckFinding ... var1);

        public Builder testFindings(Consumer<AutomatedReasoningCheckFinding.Builder> ... var1);

        public Builder testRunResult(String var1);

        public Builder testRunResult(AutomatedReasoningPolicyTestRunResult var1);

        public Builder aggregatedTestFindingsResult(String var1);

        public Builder aggregatedTestFindingsResult(AutomatedReasoningCheckResult var1);

        public Builder updatedAt(Instant var1);
    }
}

