/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyBuildMessageType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutomatedReasoningPolicyBuildStepMessage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutomatedReasoningPolicyBuildStepMessage> {
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("message").getter(AutomatedReasoningPolicyBuildStepMessage.getter(AutomatedReasoningPolicyBuildStepMessage::message)).setter(AutomatedReasoningPolicyBuildStepMessage.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()}).build();
    private static final SdkField<String> MESSAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("messageType").getter(AutomatedReasoningPolicyBuildStepMessage.getter(AutomatedReasoningPolicyBuildStepMessage::messageTypeAsString)).setter(AutomatedReasoningPolicyBuildStepMessage.setter(Builder::messageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_FIELD, MESSAGE_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AutomatedReasoningPolicyBuildStepMessage.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String message;
    private final String messageType;

    private AutomatedReasoningPolicyBuildStepMessage(BuilderImpl builder) {
        this.message = builder.message;
        this.messageType = builder.messageType;
    }

    public final String message() {
        return this.message;
    }

    public final AutomatedReasoningPolicyBuildMessageType messageType() {
        return AutomatedReasoningPolicyBuildMessageType.fromValue(this.messageType);
    }

    public final String messageTypeAsString() {
        return this.messageType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedReasoningPolicyBuildStepMessage)) {
            return false;
        }
        AutomatedReasoningPolicyBuildStepMessage other = (AutomatedReasoningPolicyBuildStepMessage)obj;
        return Objects.equals(this.message(), other.message()) && Objects.equals(this.messageTypeAsString(), other.messageTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AutomatedReasoningPolicyBuildStepMessage").add("Message", (Object)this.message()).add("MessageType", (Object)this.messageTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "messageType": {
                return Optional.ofNullable(clazz.cast(this.messageTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("message", MESSAGE_FIELD);
        map.put("messageType", MESSAGE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomatedReasoningPolicyBuildStepMessage, T> g) {
        return obj -> g.apply((AutomatedReasoningPolicyBuildStepMessage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String message;
        private String messageType;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomatedReasoningPolicyBuildStepMessage model) {
            this.message(model.message);
            this.messageType(model.messageType);
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getMessageType() {
            return this.messageType;
        }

        public final void setMessageType(String messageType) {
            this.messageType = messageType;
        }

        @Override
        public final Builder messageType(String messageType) {
            this.messageType = messageType;
            return this;
        }

        @Override
        public final Builder messageType(AutomatedReasoningPolicyBuildMessageType messageType) {
            this.messageType(messageType == null ? null : messageType.toString());
            return this;
        }

        public AutomatedReasoningPolicyBuildStepMessage build() {
            return new AutomatedReasoningPolicyBuildStepMessage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutomatedReasoningPolicyBuildStepMessage> {
        public Builder message(String var1);

        public Builder messageType(String var1);

        public Builder messageType(AutomatedReasoningPolicyBuildMessageType var1);
    }
}

