/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.util.KsqlException;
import java.util.Base64;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ConsistencyOffsetVector {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private int version;
    private final ConcurrentHashMap<String, ConcurrentHashMap<Integer, Long>> offsetVector;

    @JsonCreator
    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public ConsistencyOffsetVector(@JsonProperty(value="version", required=true) int version, @JsonProperty(value="offsetVector", required=true) ConcurrentHashMap<String, ConcurrentHashMap<Integer, Long>> offsetVector) {
        this.version = version;
        this.offsetVector = offsetVector;
    }

    public static ConsistencyOffsetVector emptyVector() {
        return new ConsistencyOffsetVector(0, new ConcurrentHashMap<String, ConcurrentHashMap<Integer, Long>>());
    }

    public ConsistencyOffsetVector withComponent(String topic, int partition, long offset) {
        this.offsetVector.computeIfAbsent(topic, k -> new ConcurrentHashMap()).compute(partition, (integer, prior) -> prior == null || offset > prior ? Long.valueOf(offset) : prior);
        return this;
    }

    public Map<Integer, Long> getTopicOffsets(String topic) {
        ConcurrentHashMap<Integer, Long> partitionMap = this.offsetVector.get(topic);
        return partitionMap == null ? Collections.emptyMap() : Collections.unmodifiableMap(partitionMap);
    }

    public void update(String topic, int partition, long offset) {
        this.offsetVector.computeIfAbsent(topic, k -> new ConcurrentHashMap()).compute(partition, (key, prior) -> prior == null || offset > prior ? Long.valueOf(offset) : prior);
    }

    public void merge(ConsistencyOffsetVector other) {
        if (other == null) {
            return;
        }
        if (this.getClass() != other.getClass()) {
            throw new KsqlException("Offset vector types don't match");
        }
        for (Map.Entry<String, ConcurrentHashMap<Integer, Long>> entry : other.offsetVector.entrySet()) {
            String topic = entry.getKey();
            Map partitionMap = this.offsetVector.computeIfAbsent(topic, k -> new ConcurrentHashMap());
            for (Map.Entry<Integer, Long> partitionOffset : entry.getValue().entrySet()) {
                Integer partition = partitionOffset.getKey();
                Long offset = partitionOffset.getValue();
                if (partitionMap.containsKey(partition) && (Long)partitionMap.get(partition) >= offset) continue;
                partitionMap.put(partition, offset);
            }
        }
    }

    public ConsistencyOffsetVector copy() {
        return new ConsistencyOffsetVector(this.version, ConsistencyOffsetVector.deepCopy(this.offsetVector));
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int newVersion) {
        this.version = newVersion;
    }

    public ImmutableMap<String, Map<Integer, Long>> getOffsetVector() {
        return ImmutableMap.copyOf(this.offsetVector);
    }

    @JsonAnySetter
    public void setOffsetVector(ConcurrentHashMap<String, ConcurrentHashMap<Integer, Long>> topicOffsets) {
        this.offsetVector.putAll(topicOffsets);
    }

    public String serialize() {
        try {
            byte[] bytes = OBJECT_MAPPER.writeValueAsBytes((Object)this);
            return Base64.getEncoder().encodeToString(bytes);
        }
        catch (Exception e) {
            throw new KsqlException("Couldn't encode consistency token", e);
        }
    }

    public static ConsistencyOffsetVector deserialize(String token) {
        try {
            byte[] bytes = Base64.getDecoder().decode(token);
            return (ConsistencyOffsetVector)OBJECT_MAPPER.readValue(bytes, ConsistencyOffsetVector.class);
        }
        catch (Exception e) {
            throw new KsqlException("Couldn't decode consistency token", e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConsistencyOffsetVector vector1 = (ConsistencyOffsetVector)o;
        return Objects.equals(this.offsetVector, vector1.offsetVector) && this.version == vector1.version;
    }

    public int hashCode() {
        throw new UnsupportedOperationException("Mutable object not suitable for hash key");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ConsistencyOffsetVector{");
        sb.append("version=").append(this.version);
        sb.append(", offsetVector=").append(this.offsetVector);
        sb.append('}');
        return sb.toString();
    }

    private static ConcurrentHashMap<String, ConcurrentHashMap<Integer, Long>> deepCopy(Map<String, ? extends Map<Integer, Long>> map) {
        if (map == null) {
            return new ConcurrentHashMap<String, ConcurrentHashMap<Integer, Long>>();
        }
        ConcurrentHashMap<String, ConcurrentHashMap<Integer, Long>> copy = new ConcurrentHashMap<String, ConcurrentHashMap<Integer, Long>>(map.size());
        for (Map.Entry<String, ? extends Map<Integer, Long>> entry : map.entrySet()) {
            copy.put(entry.getKey(), new ConcurrentHashMap<Integer, Long>(entry.getValue()));
        }
        return copy;
    }

    static {
        OBJECT_MAPPER.registerModule((Module)new Jdk8Module());
    }
}

