/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.models.CapabilityBase;
import com.azure.resourcemanager.postgresqlflexibleserver.models.CapabilityStatus;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ServerSkuCapability;
import com.azure.resourcemanager.postgresqlflexibleserver.models.StorageEditionCapability;
import java.io.IOException;
import java.util.List;

public final class FlexibleServerEditionCapability
extends CapabilityBase {
    private String name;
    private String defaultSkuName;
    private List<StorageEditionCapability> supportedStorageEditions;
    private List<ServerSkuCapability> supportedServerSkus;
    private String reason;
    private CapabilityStatus status;

    public String name() {
        return this.name;
    }

    public String defaultSkuName() {
        return this.defaultSkuName;
    }

    public List<StorageEditionCapability> supportedStorageEditions() {
        return this.supportedStorageEditions;
    }

    public List<ServerSkuCapability> supportedServerSkus() {
        return this.supportedServerSkus;
    }

    @Override
    public String reason() {
        return this.reason;
    }

    @Override
    public CapabilityStatus status() {
        return this.status;
    }

    @Override
    public void validate() {
        if (this.supportedStorageEditions() != null) {
            this.supportedStorageEditions().forEach(e -> e.validate());
        }
        if (this.supportedServerSkus() != null) {
            this.supportedServerSkus().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static FlexibleServerEditionCapability fromJson(JsonReader jsonReader) throws IOException {
        return (FlexibleServerEditionCapability)jsonReader.readObject(reader -> {
            FlexibleServerEditionCapability deserializedFlexibleServerEditionCapability = new FlexibleServerEditionCapability();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("status".equals(fieldName)) {
                    deserializedFlexibleServerEditionCapability.status = CapabilityStatus.fromString(reader.getString());
                    continue;
                }
                if ("reason".equals(fieldName)) {
                    deserializedFlexibleServerEditionCapability.reason = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedFlexibleServerEditionCapability.name = reader.getString();
                    continue;
                }
                if ("defaultSkuName".equals(fieldName)) {
                    deserializedFlexibleServerEditionCapability.defaultSkuName = reader.getString();
                    continue;
                }
                if ("supportedStorageEditions".equals(fieldName)) {
                    List supportedStorageEditions;
                    deserializedFlexibleServerEditionCapability.supportedStorageEditions = supportedStorageEditions = reader.readArray(reader1 -> StorageEditionCapability.fromJson(reader1));
                    continue;
                }
                if ("supportedServerSkus".equals(fieldName)) {
                    List supportedServerSkus;
                    deserializedFlexibleServerEditionCapability.supportedServerSkus = supportedServerSkus = reader.readArray(reader1 -> ServerSkuCapability.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFlexibleServerEditionCapability;
        });
    }
}

