/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.models.BackupSettings;
import java.io.IOException;

public class BackupRequestBase
implements JsonSerializable<BackupRequestBase> {
    private BackupSettings backupSettings;
    private static final ClientLogger LOGGER = new ClientLogger(BackupRequestBase.class);

    public BackupSettings backupSettings() {
        return this.backupSettings;
    }

    public BackupRequestBase withBackupSettings(BackupSettings backupSettings) {
        this.backupSettings = backupSettings;
        return this;
    }

    public void validate() {
        if (this.backupSettings() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property backupSettings in model BackupRequestBase"));
        }
        this.backupSettings().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("backupSettings", (JsonSerializable)this.backupSettings);
        return jsonWriter.writeEndObject();
    }

    public static BackupRequestBase fromJson(JsonReader jsonReader) throws IOException {
        return (BackupRequestBase)jsonReader.readObject(reader -> {
            BackupRequestBase deserializedBackupRequestBase = new BackupRequestBase();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("backupSettings".equals(fieldName)) {
                    deserializedBackupRequestBase.backupSettings = BackupSettings.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBackupRequestBase;
        });
    }
}

